﻿// ========================================================================
// <copyright file="FieldCollisionData.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_6.Build_0.Revision_0
{
    /// <summary>
    /// コリジョンフィールド
    /// </summary>
    public sealed class FieldCollisionData : BaseDataModel<FieldCollisionData>
    {
        #region Properties

        /// <summary>
        /// タイプ（0:反射 1:消滅)
        /// </summary>
        public int Type
        {
            get;
            set;
        }

        /// <summary>
        /// ワールドでかけるか？
        /// </summary>
        public bool IsWorld
        {
            get;
            set;
        }

        /// <summary>
        /// 座標
        /// </summary>
        public float Coordinate
        {
            get;
            set;
        }

        /// <summary>
        /// 反射率
        /// </summary>
        public float Coefficient
        {
            get;
            set;
        }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public FieldCollisionData()
        {
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public FieldCollisionData(FieldCollisionData source)
            : this()
        {
            this.Set(source);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
        }

        /// <summary>
        /// 設定します
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(FieldCollisionData source)
        {
            Ensure.Argument.NotNull(source);

            this.Type = source.Type;
            this.IsWorld = source.IsWorld;
            this.Coordinate = source.Coordinate;
            this.Coefficient = source.Coefficient;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override FieldCollisionData Clone()
        {
            return new FieldCollisionData(this);
        }

        #endregion
    }
}
