﻿// ========================================================================
// <copyright file="EnvConfigData.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System.Collections.Generic;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_2.Build_0.Revision_0
{
    /// <summary>
    /// 環境設定データ
    /// </summary>
    public sealed class EnvConfigData : BaseDataModel<EnvConfigData>
    {
        #region Constructors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public EnvConfigData()
        {
            this.PreviewConfigData = new PreviewConfigData();
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public EnvConfigData(EnvConfigData source)
            : this()
        {
            this.Set(source);
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.PreviewConfigData.Initialize();
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 設定
        /// </summary>
        public override void Set(EnvConfigData source)
        {
            Ensure.Argument.NotNull(source);

            this.PreviewConfigData.Set(source.PreviewConfigData);
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override EnvConfigData Clone()
        {
            return new EnvConfigData(this);
        }

        #endregion

        #region Properties

        /// <summary>
        /// プレビュー設定データモデル
        /// </summary>
        public PreviewConfigData PreviewConfigData { get; set; }

        #endregion
    }
}
