﻿// ========================================================================
// <copyright file="BaseEditData.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Reflection;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NWCore.Serializer.Major_0.Minor_0.Build_0.Revision_0;

namespace NWCore.DataModel.Major_0.Minor_0.Build_0.Revision_0
{
    /// <summary>
    /// EditData用ベースオブジェクト
    /// </summary>
    public abstract class BaseEditData : ICloneable, ISettable, IInitializable
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public BaseEditData()
        {
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public abstract void Initialize();

        /// <summary>
        /// クローン
        /// </summary>
        public abstract object Clone();

        /// <summary>
        /// オブジェクト設定
        /// </summary>
        public abstract void Set(object source);
    }
}
