﻿// ========================================================================
// <copyright file="DocumentUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using NintendoWare.ToolDevelopmentKit;

namespace App.Utility
{
    /// <summary>
    /// ドキュメントユーティリティ
    /// </summary>
    public static class DocumentUtility
    {
        #region 命名規則チェック

        /// <summary>
        /// コメント用文字列のチェック
        /// </summary>
        /// <returns>=true..OK</returns>
        public static bool IsValidateCommentString(string comment)
        {
            return RegexMatch.Check(comment, "[^\\uFF61-\\uFF9F\"&'<>]*");
        }

        /// <summary>
        /// エントリー名用文字列のチェック
        /// </summary>
        /// <returns>=true..OK</returns>
        public static bool IsValidateEntryName(string entryName)
        {
            return RegexMatch.Check( entryName, res.Strings.REGEXP_DOCUMENT_NAME_VALIDATION );
        }

        /// <summary>
        /// エントリー名用文字列のチェックし不正なときはダイアログを表示します。
        /// </summary>
        /// <returns>=true..OK</returns>
        public static bool ValidateEntryName(string entryName)
        {
            bool bResult = IsValidateEntryName(entryName);
            if (bResult == false)
            {
                string text = res.Strings.WARNING_CHANGE_NAME;
                text += res.Strings.WARNING_CHANGE_NAME_POST;

                /*
                App.Controls.ThreadSafeMsgBox.Show( TheApp.MainFrame,
                                                    text,
                                                    res.Strings.WANING_CHANGE_NAME_TITLE,
                                                    MessageBoxButtons.OK,
                                                    MessageBoxIcon.Exclamation );
                */
            }

            return bResult;
        }

        #endregion
    }
}
