﻿// ========================================================================
// <copyright file="IDebugConsoleOwner.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System.Windows.Forms;

namespace App
{
    /// <summary>
    /// Debug オーナー用のインターフェイスです。
    /// </summary>
    public interface IDebugConsoleOwner
    {
        /// <summary>
        /// コマンドキー処理
        /// </summary>
        /// <param name="msg">Messageです</param>
        /// <param name="keyData">キー情報です</param>
        /// <returns>キーストロークがコントロールによって処理および使用された場合は true。
        /// キーストロークをさらに処理できるようにする場合は false。</returns>
        bool ProcessCommandKey(ref Message msg, Keys keyData);
    }
}
