﻿// ========================================================================
// <copyright file="ConfigDataWrapper.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Diagnostics;
using System.Drawing;

using NintendoWare.ToolDevelopmentKit;
//using NintendoWare.ColorPicker;

using App.Data;

namespace App
{
    //=========================================================================
    // ラッパ定義
    //=========================================================================
    #region アプリケーション
    /// <summary>
    /// メインフレーム
    /// </summary>
    partial class CfApplication
    {
        /// <summary>
        /// 言語モードアクセサ
        /// </summary>
        [System.Xml.Serialization.XmlIgnore]
        public App.LanguageMode LanguageModeAccessor
        {
            get { return (App.LanguageMode)LanguageMode; }
            set { LanguageMode = (CfApplicationLanguageMode)value; }
        }
    }
    #endregion

    //=========================================================================
    // ユーザーインターフェースラッパ定義
    //=========================================================================
    #region メインフレーム
    /// <summary>
    /// メインフレーム
    /// </summary>
    partial class CfMainFrame
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CfMainFrame() { Bounds = new CfRectangle(); }
    }
    #endregion

    //-------------------------------------------------------------------------
    #region プロパティウィンドウ
    /// <summary>
    /// プロパティウィンドウ
    /// </summary>
    partial class CfPropertyWindow
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CfPropertyWindow() { Bounds = new CfRectangle(); }
    }

    /// <summary>
    /// ビューアコントロール
    /// </summary>
    partial class CfViewerControl
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CfViewerControl()
        {
            this.Bounds = new CfRectangle();
            this.IsLoop = false;
            this.LoopFrame = 180;
            this.TargetIndex = 0;
        }
    }

    #endregion

    //-------------------------------------------------------------------------
    #region エフェクトブラウザ

    /// <summary>
    /// CfFavoriteDirectories
    /// </summary>
    partial class CfFavoriteDirectories
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CfFavoriteDirectories()
        {
        }
    }

    #endregion

    //-------------------------------------------------------------------------
    #region カラーピッカー
    /// <summary>
    /// カラーピッカー
    /// </summary>
    partial class CfColorPicker
    {
        /// <summary>
        /// カラーの数
        /// </summary>
        public const int CustomColorCount = 16;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CfColorPicker()
        {
            Location = new CfPoint();
            CustomColor = new CfColor[CustomColorCount];
            for (int i = 0; i < CustomColorCount; i++) { CustomColor[i] = new CfColor(); }
        }

        /// <summary>
        /// カラーモードアクセサ
        /// </summary>
        /*
        [System.Xml.Serialization.XmlIgnore]
        public NintendoWare.ColorPicker.ColorMode ColorModeAccessor
        {
            get { return (NintendoWare.ColorPicker.ColorMode)ColorMode; }
            set { ColorMode = (CfColorPickerColorMode)value; }
        }
        */

        /// <summary>
        /// バリューモードアクセサ
        /// </summary>
        /*
        [System.Xml.Serialization.XmlIgnore]
        public NintendoWare.ColorPicker.ValueMode ValueModeAccessor
        {
            get { return (NintendoWare.ColorPicker.ValueMode)ValueMode; }
            set { ValueMode = (CfColorPickerValueMode)value; }
        }
        */
    }
    #endregion

    //-------------------------------------------------------------------------
    #region ドキュメント IO
    /// <summary>
    /// ドキュメント IO
    /// </summary>
    partial class CfDocumentIO
    {
        /// <summary>
        /// Helper method for getting the last accessed directory path of
        /// the type of files with the given file extension.
        /// </summary>
        /// <param name="fileExt">The file extension.</param>
        /// <returns>The last accessed directory path.</returns>
        public string GetLastAccessedDir( string fileExt )
        {
            if ( LastAccessedDirList!=null &&
                 string.IsNullOrEmpty(fileExt)==false )
            {
                string strFileExt = string.Copy( fileExt );

                // Remove the leading '.'
                if ( strFileExt.IndexOf( '.' )==0 )
                    strFileExt.Substring( 1, strFileExt.Length-1 );

                // Convert to lower case string.
                strFileExt = strFileExt.ToLower();

                // Find the directory for the file extension.
                foreach ( CfLastAccessedDir info in LastAccessedDirList )
                {
                    if ( info!=null &&
                         info.FileExt==strFileExt )
                    {
                        return info.DirPath;
                    }
                }
            }

            // The directory for the file extension was not found.
            // Use My Documents as the default directory.
            return Environment.GetFolderPath( Environment.SpecialFolder.MyDocuments );
        }


        /// <summary>
        /// Set the last accessed directory path of the files with the given file extension.
        /// </summary>
        /// <param name="fileExt">The file extension.</param>
        /// <param name="path">The directory or the file path.</param>
        public void SetLastAccessedDir( string fileExt,
                                        string path )
        {
            if ( string.IsNullOrEmpty(fileExt)==true )
                return;

            string strFileExt = string.Copy( fileExt );

            // Remove the leading '.'
            if ( strFileExt.IndexOf( '.' )==0 )
                strFileExt.Substring( 1, strFileExt.Length-1 );

            // Convert to lower case string.
            strFileExt = strFileExt.ToLower();

            string strDirPath = App.IO.DocumentConstants.GetDirectoryName( path );

            // Find the directory for the file extension.
            int i;
            if ( LastAccessedDirList!=null )
            {
                for ( i=0;i<LastAccessedDirList.Length;++i )
                {
                    CfLastAccessedDir info = LastAccessedDirList[i];
                    if ( info!=null &&
                         info.FileExt==strFileExt )
                    {
                        LastAccessedDirList[i].DirPath = string.Copy( strDirPath );
                        return;
                    }
                }
            }

            // The file extension was not found, add it to the list.
            // Create a new list with 1 more element,
            // then copy the original data to the new list.
            CfLastAccessedDir[] newList = null;
            if ( LastAccessedDirList!=null )
            {
                newList = new CfLastAccessedDir[ LastAccessedDirList.Length + 1 ];
                for ( i=0;i<LastAccessedDirList.Length;++i )
                {
                    newList[i] = LastAccessedDirList[i];
                }
            }
            else
            {
                newList = new CfLastAccessedDir[1];
            }

            CfLastAccessedDir newInfo = new CfLastAccessedDir();

            newInfo.FileExt = string.Copy( strFileExt );
            newInfo.DirPath = string.Copy( strDirPath );

            newList[newList.Length-1] = newInfo;

            this.LastAccessedDirList = newList;
        }
    }
    #endregion

    //=========================================================================
    // プリミティブラッパ定義
    //=========================================================================
    #region カラー
    /// <summary>
    /// カラー
    /// </summary>
    partial class CfColor
    {
        /// <summary>
        /// Colorプロパティ
        /// </summary>
        /*
        [System.Xml.Serialization.XmlIgnore]
        public RgbaColor Color
        {
            get
            {
                return new RgbaColor(this.R / 255.0f,
                                     this.G / 255.0f,
                                     this.B / 255.0f,
                                     this.A / 255.0f);
            }
            set
            {
                this.R = ColorUtil.ClampByte(value.R*255.0f);
                this.G = ColorUtil.ClampByte(value.G*255.0f);
                this.B = ColorUtil.ClampByte(value.B*255.0f);
                this.A = ColorUtil.ClampByte(value.A*255.0f);
            }
        }
        */

        /// <summary>
        /// Rgbaプロパティ
        /// </summary>
        /*
        [System.Xml.Serialization.XmlIgnore]
        public Rgba Rgba
        {
            get
            {
                return new Rgba( (int)ColorUtil.ClampByte(this.R),
                                 (int)ColorUtil.ClampByte(this.G),
                                 (int)ColorUtil.ClampByte(this.B),
                                 (int)ColorUtil.ClampByte(this.A) );
            }
            set
            {
                this.R = (float)value.R;
                this.G = (float)value.G;
                this.B = (float)value.B;
                this.A = (float)value.A;
            }
        }
        */
    }
    #endregion

    //-------------------------------------------------------------------------
    #region ポイント
    /// <summary>
    /// ポイント
    /// </summary>
    partial class CfPoint
    {
        /// <summary>
        /// Pointプロパティ
        /// </summary>
        [System.Xml.Serialization.XmlIgnore]
        public Point Point
        {
            get { return new Point(this.X, this.Y); }
            set
            {
                this.X = value.X;
                this.Y = value.Y;
            }
        }
    }
    #endregion

    //-------------------------------------------------------------------------
#if false //TODO:CUT
    #region ポイントF
    /// <summary>
    /// ポイントF
    /// </summary>
    partial class CfPointF
    {
        /// <summary>
        /// Pointプロパティ
        /// </summary>
        [System.Xml.Serialization.XmlIgnore]
        public PointF PointF
        {
            get { return new PointF(this.X, this.Y); }
            set
            {
                this.X = value.X;
                this.Y = value.Y;
            }
        }
    }
    #endregion
#endif
    //-------------------------------------------------------------------------
    #region サイズ
    /// <summary>
    /// サイズ
    /// </summary>
    partial class CfSize
    {
        /// <summary>
        /// Sizeプロパティ
        /// </summary>
        [System.Xml.Serialization.XmlIgnore]
        public Size Size
        {
            get { return new Size(this.Width, this.Height); }
            set
            {
                this.Width = value.Width;
                this.Height = value.Height;
            }
        }
    }
    #endregion

    //-------------------------------------------------------------------------
    #region 矩形
    /// <summary>
    /// 矩形
    /// </summary>
    partial class CfRectangle
    {
        /// <summary>
        /// Rectangleプロパティ
        /// </summary>
        [System.Xml.Serialization.XmlIgnore]
        public Rectangle Rectangle
        {
            get { return new Rectangle(this.X, this.Y, this.Width, this.Height); }
            set
            {
                this.X = value.X;
                this.Y = value.Y;
                this.Width = value.Width;
                this.Height = value.Height;
            }
        }

        /// <summary>
        /// Locationプロパティ
        /// </summary>
        [System.Xml.Serialization.XmlIgnore]
        public Point Location
        {
            get { return new Point(this.X, this.Y); }
            set
            {
                this.X = value.X;
                this.Y = value.Y;
            }
        }

        /// <summary>
        /// Sizeプロパティ
        /// </summary>
        [System.Xml.Serialization.XmlIgnore]
        public Size Size
        {
            get { return new Size(this.Width, this.Height); }
            set
            {
                this.Width = value.Width;
                this.Height = value.Height;
            }
        }
    }
    #endregion

}
