﻿// ========================================================================
// <copyright file="EsetUpdater_1_7_0_0.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
#define ___CE2UPDATE___

using System;
using System.IO;

using App.IO;

using PrevVerDataModel  = NWCore.DataModel.Major_1.Minor_6.Build_0.Revision_0;
using CurrVerDataModel  = NWCore.DataModel;

using PrevVerSerializer = NWCore.Serializer.Major_1.Minor_6.Build_0.Revision_0;
using CurrVerSerializer = NWCore.Serializer;

namespace App.Data
{
    /// <summary>
    /// Emitter set data model updater class.
    /// Version [ 1.6.0.0 ] => [ 1.7.0.0 ]
    /// </summary>
    public class EsetUpdater_1_7_0_0 : IDataModelUpdater
    {
        #region Constructor

        /// <summary>
        /// Constructor.
        /// </summary>
        public EsetUpdater_1_7_0_0()
        {
        }

        #endregion

        #region Properties

        /// <summary>Get the data model version this updater converts from.</summary>
        public Version PreviousVersion { get { return m_prevVersion; } }


        /// <summary>Get the data model version this updater converts to.</summary>
        public Version CurrentVersion { get { return m_currVersion; } }

        #endregion

        #region Derived from IDataModelUpdater

        /// <summary>
        /// Check if the updater can deserialize the data model with
        /// the given binary version.
        /// </summary>
        /// <param name="binaryVersion">The binary version.</param>
        /// <returns>True if the updater can deserialize the file.</returns>
        public bool CanDeserialize( Version binaryVersion )
        {
            if ( binaryVersion.Equals( m_currVersion )==true )
                return true;

            return false;
        }


        /// <summary>
        /// Check if the data model can be updated with this updater.
        /// </summary>
        /// <param name="dataModel">The data model to be updated.</param>
        /// <returns>True if the data model can be updated by this updater.</returns>
        public bool CanUpdate( object dataModel )
        {
            if ( dataModel is PrevVerSerializer.EmitterSetDataXml )
                return true;

            return false;
        }


        /// <summary>
        /// Deserialize the data in the given memory stream and return the
        /// deserialized data model.
        /// </summary>
        /// <param name="binaryVersion">The binary version of the data.</param>
        /// <param name="stream">The memory stream contains the data to be deserialized.</param>
        /// <returns>The deserialized data model.</returns>
        public object Deserialize( Version binaryVersion,
                                   Stream stream )
        {
            CurrVerSerializer.EmitterSetDataXml data = null;
            if ( binaryVersion.Equals( m_currVersion )==true )
            {
                CurrVerSerializer.EmitterSetDataXml content =
                    DocumentIO.DeserializeFromFile<CurrVerSerializer.EmitterSetDataXml>( stream );
                if ( content==null )
                    return null;

                data = content;
            }

            return data;
        }


        /// <summary>
        /// Update the given data model to a later version.
        /// </summary>
        /// <param name="src">The source data model.</param>
        /// <returns>The updated data model.</returns>
        public object Update( object src )
        {
            PrevVerSerializer.EmitterSetDataXml srcData =
                src as PrevVerSerializer.EmitterSetDataXml;
            if ( srcData==null )
                return null;

            CurrVerSerializer.EmitterSetDataXml dstData =
                new CurrVerSerializer.EmitterSetDataXml();

            // TODO : Convert the emitter set data.
            #region Convert emitter set data

            dstData.userData       = srcData.userData;
            dstData.lastUpdateDate = srcData.lastUpdateDate;

            dstData.EmitterSetData.EditData.ColorLabelIndex = srcData.EmitterSetData.EditData.ColorLabelIndex;
            dstData.EmitterSetData.EditData.Comment = string.Copy( srcData.EmitterSetData.EditData.Comment );

            #endregion

            // TODO : Convert the emitter data.
            #region Convert emitter data

            foreach ( PrevVerSerializer.ComplexEmitterDataXml srcEmitter in srcData.EmitterList )
            {
                CurrVerSerializer.ComplexEmitterDataXml dstEmitter =
                    new CurrVerSerializer.ComplexEmitterDataXml();

                dstEmitter.EditData.Initialize();

                ConvertAnimTableList( srcEmitter.Animations,
                                      dstEmitter.Animations );

                dstEmitter.name = srcEmitter.name;
                dstEmitter.isCompactEmitter = srcEmitter.isCompactEmitter;
#if ___CE2UPDATE___  // テクスチャの拡張子を ".tga" から ".ftxb" に変換
                dstEmitter.texture = srcEmitter.texture.Replace(".tga", ".ftxb");
#else
                dstEmitter.texture = srcEmitter.texture;
#endif
                dstEmitter.UI_colorType = srcEmitter.UI_colorType;
                dstEmitter.UI_color0_type = srcEmitter.UI_color0_type;
                dstEmitter.UI_color1_type = srcEmitter.UI_color1_type;

#if ___CE2UPDATE___  // カラー0挙動タイプとカラー1挙動タイプが両方とも固定でないとき、カラー1挙動タイプを固定にする
                if (dstEmitter.UI_color0_type != 0 && dstEmitter.UI_color1_type != 0) {
                    dstEmitter.UI_color1_type = 0;
                }
#endif

                dstEmitter.toCameraOffset = srcEmitter.toCameraOffset;
#if ___CE2UPDATE___  // テクスチャの拡張子を ".tga" から ".ftxb" に変換
                dstEmitter.subTexture = srcEmitter.subTexture.Replace(".tga", ".ftxb");
#else
                dstEmitter.subTexture = srcEmitter.subTexture;
#endif
                dstEmitter.UI_volumeSweep = srcEmitter.UI_volumeSweep;
                dstEmitter.UI_volumeSweepStart = srcEmitter.UI_volumeSweepStart;
                dstEmitter.UI_volumeSweepStartRandom = srcEmitter.UI_volumeSweepStartRandom;
                dstEmitter.volumeTblIndex = srcEmitter.volumeTblIndex;
                dstEmitter.UI_Fog = srcEmitter.UI_Fog;
                dstEmitter.figureVel = srcEmitter.figureVel;
                dstEmitter.emitterVel = srcEmitter.emitterVel;
                dstEmitter.UI_initVelRnd = srcEmitter.UI_initVelRnd;
                dstEmitter.startFrame = srcEmitter.startFrame;
                dstEmitter.UI_emitTime = srcEmitter.UI_emitTime;
                dstEmitter.UI_emitVelInherit = srcEmitter.UI_emitVelInherit;
                dstEmitter.emitterAlpha = srcEmitter.emitterAlpha;
                dstEmitter.emitterColor0 = srcEmitter.emitterColor0;
                dstEmitter.emitterColor1 = srcEmitter.emitterColor1;
                dstEmitter.UI_isOneTime = srcEmitter.UI_isOneTime;
                dstEmitter.lifeStep = srcEmitter.lifeStep;
                dstEmitter.emitRate = (float)(srcEmitter.emitRate);
                dstEmitter.UI_emitRate = (float)(srcEmitter.UI_emitRate);
                dstEmitter.UI_life = srcEmitter.UI_life;
                dstEmitter.UI_lifeRnd = srcEmitter.UI_lifeRnd;
                dstEmitter.UI_lifeInfinit = srcEmitter.UI_lifeInfinit;
                dstEmitter.UI_lifeStepRnd = srcEmitter.UI_lifeStepRnd;
                dstEmitter.airRegist = srcEmitter.airRegist;
                dstEmitter.UI_gravity = srcEmitter.UI_gravity;
                dstEmitter.UI_isFieldCalcType = srcEmitter.UI_isFieldCalcType;
                dstEmitter.UI_color0_time1 = srcEmitter.UI_color0_time1;
                dstEmitter.UI_color0_time2 = srcEmitter.UI_color0_time2;
                dstEmitter.UI_color0_time3 = srcEmitter.UI_color0_time3;
                dstEmitter.UI_color0_numColorRepeat = srcEmitter.UI_color0_numColorRepeat;
                dstEmitter.UI_color1_time1 = srcEmitter.UI_color1_time1;
                dstEmitter.UI_color1_time2 = srcEmitter.UI_color1_time2;
                dstEmitter.UI_color1_time3 = srcEmitter.UI_color1_time3;
                dstEmitter.UI_color1_numColorRepeat = srcEmitter.UI_color1_numColorRepeat;
                dstEmitter.UI_alpha1 = srcEmitter.UI_alpha1;
                dstEmitter.UI_alpha2 = srcEmitter.UI_alpha2;
                dstEmitter.UI_alpha3 = srcEmitter.UI_alpha3;
                dstEmitter.UI_alphaTime1 = srcEmitter.UI_alphaTime1;
                dstEmitter.UI_alphaTime2 = srcEmitter.UI_alphaTime2;
                dstEmitter.UI_scaleTime1 = srcEmitter.UI_scaleTime1;
                dstEmitter.UI_scaleTime2 = srcEmitter.UI_scaleTime2;
                dstEmitter.UI_scaleRand = srcEmitter.UI_scaleRand;
                dstEmitter.UI_scaleVelAddY = srcEmitter.UI_scaleVelAddY;
                dstEmitter.UI_fadeAlphaFrameInFade = srcEmitter.UI_fadeAlphaFrameInFade;
                dstEmitter.UI_texPatDivX = srcEmitter.UI_texPatDivX;
                dstEmitter.UI_texPatDivY = srcEmitter.UI_texPatDivY;
                dstEmitter.UI_texPatNumPattern = srcEmitter.UI_texPatNumPattern;
                dstEmitter.UI_texPatFreqFrame = srcEmitter.UI_texPatFreqFrame;
                dstEmitter.UI_numUseTexPatTbl = srcEmitter.UI_numUseTexPatTbl;
                dstEmitter.UI_texPatAnimMode = srcEmitter.UI_texPatAnimMode;
                dstEmitter.UI_texPatAnim = srcEmitter.UI_texPatAnim;
                dstEmitter.UI_texPatIsRandom = srcEmitter.UI_texPatIsRandom;
                dstEmitter.UI_texPatTbl_0 = srcEmitter.UI_texPatTbl_0;
                dstEmitter.UI_texPatTbl_1 = srcEmitter.UI_texPatTbl_1;
                dstEmitter.UI_texPatTbl_2 = srcEmitter.UI_texPatTbl_2;
                dstEmitter.UI_texPatTbl_3 = srcEmitter.UI_texPatTbl_3;
                dstEmitter.UI_texPatTbl_4 = srcEmitter.UI_texPatTbl_4;
                dstEmitter.UI_texPatTbl_5 = srcEmitter.UI_texPatTbl_5;
                dstEmitter.UI_texPatTbl_6 = srcEmitter.UI_texPatTbl_6;
                dstEmitter.UI_texPatTbl_7 = srcEmitter.UI_texPatTbl_7;
                dstEmitter.UI_texPatTbl_8 = srcEmitter.UI_texPatTbl_8;
                dstEmitter.UI_texPatTbl_9 = srcEmitter.UI_texPatTbl_9;
                dstEmitter.UI_texPatTbl_10 = srcEmitter.UI_texPatTbl_10;
                dstEmitter.UI_texPatTbl_11 = srcEmitter.UI_texPatTbl_11;
                dstEmitter.UI_texPatTbl_12 = srcEmitter.UI_texPatTbl_12;
                dstEmitter.UI_texPatTbl_13 = srcEmitter.UI_texPatTbl_13;
                dstEmitter.UI_texPatTbl_14 = srcEmitter.UI_texPatTbl_14;
                dstEmitter.UI_texPatTbl_15 = srcEmitter.UI_texPatTbl_15;
                dstEmitter.UI_texPatTbl_16 = srcEmitter.UI_texPatTbl_16;
                dstEmitter.UI_texPatTbl_17 = srcEmitter.UI_texPatTbl_17;
                dstEmitter.UI_texPatTbl_18 = srcEmitter.UI_texPatTbl_18;
                dstEmitter.UI_texPatTbl_19 = srcEmitter.UI_texPatTbl_19;
                dstEmitter.UI_texPatTbl_20 = srcEmitter.UI_texPatTbl_20;
                dstEmitter.UI_texPatTbl_21 = srcEmitter.UI_texPatTbl_21;
                dstEmitter.UI_texPatTbl_22 = srcEmitter.UI_texPatTbl_22;
                dstEmitter.UI_texPatTbl_23 = srcEmitter.UI_texPatTbl_23;
                dstEmitter.UI_texPatTbl_24 = srcEmitter.UI_texPatTbl_24;
                dstEmitter.UI_texPatTbl_25 = srcEmitter.UI_texPatTbl_25;
                dstEmitter.UI_texPatTbl_26 = srcEmitter.UI_texPatTbl_26;
                dstEmitter.UI_texPatTbl_27 = srcEmitter.UI_texPatTbl_27;
                dstEmitter.UI_texPatTbl_28 = srcEmitter.UI_texPatTbl_28;
                dstEmitter.UI_texPatTbl_29 = srcEmitter.UI_texPatTbl_29;
                dstEmitter.UI_texPatTbl_30 = srcEmitter.UI_texPatTbl_30;
                dstEmitter.UI_texPatTbl_31 = srcEmitter.UI_texPatTbl_31;
                dstEmitter.UI_childColorType = srcEmitter.UI_childColorType;
                dstEmitter.UI_childColorInheritType = srcEmitter.UI_childColorInheritType;
                dstEmitter.emitterFormScale = srcEmitter.emitterFormScale;
                dstEmitter.volume64TblIndex = srcEmitter.volume64TblIndex;
                dstEmitter.volumeHollow = srcEmitter.volumeHollow;
#if ___CE2UPDATE___
                dstEmitter.childTexture = srcEmitter.childTexture.Replace(".tga", ".ftxb");
#else
                dstEmitter.childTexture = srcEmitter.childTexture;
#endif
                dstEmitter.childTextureTrimming = srcEmitter.childTextureTrimming;
                dstEmitter.childFlg = srcEmitter.childFlg;
                dstEmitter.UI_childLife = srcEmitter.UI_childLife;
                dstEmitter.childEmitRate = srcEmitter.childEmitRate;
                dstEmitter.childEmitTiming = srcEmitter.childEmitTiming;
                dstEmitter.childEmitStep = srcEmitter.childEmitStep;
                dstEmitter.childInitPosRand = srcEmitter.childInitPosRand;
                dstEmitter.childVelInheritRate = srcEmitter.childVelInheritRate;
                dstEmitter.childFigureVel = srcEmitter.childFigureVel;
                dstEmitter.childAirRegist = srcEmitter.childAirRegist;
                dstEmitter.UI_childTexPatDivX = srcEmitter.UI_childTexPatDivX;
                dstEmitter.UI_childTexPatDivY = srcEmitter.UI_childTexPatDivY;
                dstEmitter.UI_childTexPatNumPattern = srcEmitter.UI_childTexPatNumPattern;
                dstEmitter.UI_childTexPatFreqFrame = srcEmitter.UI_childTexPatFreqFrame;
                dstEmitter.UI_childNumUseTexPatTbl = srcEmitter.UI_childNumUseTexPatTbl;
                dstEmitter.UI_childTexPatAnimMode = srcEmitter.UI_childTexPatAnimMode;
                dstEmitter.UI_childTexPatAnim = srcEmitter.UI_childTexPatAnim;
                dstEmitter.UI_childTexPatTbl_0 = srcEmitter.UI_childTexPatTbl_0;
                dstEmitter.UI_childTexPatTbl_1 = srcEmitter.UI_childTexPatTbl_1;
                dstEmitter.UI_childTexPatTbl_2 = srcEmitter.UI_childTexPatTbl_2;
                dstEmitter.UI_childTexPatTbl_3 = srcEmitter.UI_childTexPatTbl_3;
                dstEmitter.UI_childTexPatTbl_4 = srcEmitter.UI_childTexPatTbl_4;
                dstEmitter.UI_childTexPatTbl_5 = srcEmitter.UI_childTexPatTbl_5;
                dstEmitter.UI_childTexPatTbl_6 = srcEmitter.UI_childTexPatTbl_6;
                dstEmitter.UI_childTexPatTbl_7 = srcEmitter.UI_childTexPatTbl_7;
                dstEmitter.UI_childTexPatTbl_8 = srcEmitter.UI_childTexPatTbl_8;
                dstEmitter.UI_childTexPatTbl_9 = srcEmitter.UI_childTexPatTbl_9;
                dstEmitter.UI_childTexPatTbl_10 = srcEmitter.UI_childTexPatTbl_10;
                dstEmitter.UI_childTexPatTbl_11 = srcEmitter.UI_childTexPatTbl_11;
                dstEmitter.UI_childTexPatTbl_12 = srcEmitter.UI_childTexPatTbl_12;
                dstEmitter.UI_childTexPatTbl_13 = srcEmitter.UI_childTexPatTbl_13;
                dstEmitter.UI_childTexPatTbl_14 = srcEmitter.UI_childTexPatTbl_14;
                dstEmitter.UI_childTexPatTbl_15 = srcEmitter.UI_childTexPatTbl_15;
                dstEmitter.UI_childTexPatTbl_16 = srcEmitter.UI_childTexPatTbl_16;
                dstEmitter.UI_childTexPatTbl_17 = srcEmitter.UI_childTexPatTbl_17;
                dstEmitter.UI_childTexPatTbl_18 = srcEmitter.UI_childTexPatTbl_18;
                dstEmitter.UI_childTexPatTbl_19 = srcEmitter.UI_childTexPatTbl_19;
                dstEmitter.UI_childTexPatTbl_20 = srcEmitter.UI_childTexPatTbl_20;
                dstEmitter.UI_childTexPatTbl_21 = srcEmitter.UI_childTexPatTbl_21;
                dstEmitter.UI_childTexPatTbl_22 = srcEmitter.UI_childTexPatTbl_22;
                dstEmitter.UI_childTexPatTbl_23 = srcEmitter.UI_childTexPatTbl_23;
                dstEmitter.UI_childTexPatTbl_24 = srcEmitter.UI_childTexPatTbl_24;
                dstEmitter.UI_childTexPatTbl_25 = srcEmitter.UI_childTexPatTbl_25;
                dstEmitter.UI_childTexPatTbl_26 = srcEmitter.UI_childTexPatTbl_26;
                dstEmitter.UI_childTexPatTbl_27 = srcEmitter.UI_childTexPatTbl_27;
                dstEmitter.UI_childTexPatTbl_28 = srcEmitter.UI_childTexPatTbl_28;
                dstEmitter.UI_childTexPatTbl_29 = srcEmitter.UI_childTexPatTbl_29;
                dstEmitter.UI_childTexPatTbl_30 = srcEmitter.UI_childTexPatTbl_30;
                dstEmitter.UI_childTexPatTbl_31 = srcEmitter.UI_childTexPatTbl_31;
                dstEmitter.UI_childTexPatIsRandom = srcEmitter.UI_childTexPatIsRandom;
                dstEmitter.childAlpha = srcEmitter.childAlpha;
                dstEmitter.childAlphaTarget = srcEmitter.childAlphaTarget;
                dstEmitter.childAlphaInit = srcEmitter.childAlphaInit;
                dstEmitter.UI_childAlphaSec = srcEmitter.UI_childAlphaSec;
                dstEmitter.UI_childAlphaBaseSec = srcEmitter.UI_childAlphaBaseSec;
                dstEmitter.childScaleInheritRate = srcEmitter.childScaleInheritRate;
                dstEmitter.UI_childScaleSec = srcEmitter.UI_childScaleSec;
                dstEmitter.UI_childGravity = srcEmitter.UI_childGravity;
                dstEmitter.fieldFlg = srcEmitter.fieldFlg;
                dstEmitter.fieldRandomBlank = srcEmitter.fieldRandomBlank;
                dstEmitter.fieldMagnetPower = srcEmitter.fieldMagnetPower;
                dstEmitter.fieldMagnetFlg = srcEmitter.fieldMagnetFlg;
                dstEmitter.fieldSpinRotate = srcEmitter.fieldSpinRotate;
                dstEmitter.fieldSpinAxis = srcEmitter.fieldSpinAxis;
                dstEmitter.fieldConvergenceFollowEmitter = srcEmitter.fieldConvergenceFollowEmitter;
                dstEmitter.fieldCollisionType = srcEmitter.fieldCollisionType;
                dstEmitter.fieldCollisionIsWorld = srcEmitter.fieldCollisionIsWorld;
                dstEmitter.fieldCollisionCoord = srcEmitter.fieldCollisionCoord;
                dstEmitter.fieldCollisionCoef = srcEmitter.fieldCollisionCoef;
                dstEmitter.fieldConvergenceRatio = srcEmitter.fieldConvergenceRatio;
                dstEmitter.fluctuationFlg = srcEmitter.fluctuationFlg;
                dstEmitter.fluctuationScale = srcEmitter.fluctuationScale;
                dstEmitter.fluctuationPhaseRnd = srcEmitter.fluctuationPhaseRnd;
                dstEmitter.UI_fluctuationFreq = srcEmitter.UI_fluctuationFreq;
                dstEmitter.stripeFlg = srcEmitter.stripeFlg;
                dstEmitter.stripeStartAlpha = srcEmitter.stripeStartAlpha;
                dstEmitter.stripeEndAlpha = srcEmitter.stripeEndAlpha;
                dstEmitter.stripeNumHistory = srcEmitter.stripeNumHistory;
                dstEmitter.UI_stripeHistoryStep = srcEmitter.UI_stripeHistoryStep;
                dstEmitter.stripeDirInterpolate = srcEmitter.stripeDirInterpolate;
                dstEmitter.volumeRadius = srcEmitter.volumeRadius;
                dstEmitter.spreadVec = srcEmitter.spreadVec;
                dstEmitter.emitterVelDir = srcEmitter.emitterVelDir;
                dstEmitter.UI_gravityDir = srcEmitter.UI_gravityDir;
                dstEmitter.UI_scale2 = srcEmitter.UI_scale2;
                dstEmitter.UI_rotBasis = srcEmitter.UI_rotBasis;
                dstEmitter.UI_transformScale = srcEmitter.UI_transformScale;
                dstEmitter.UI_childRotBasis = srcEmitter.UI_childRotBasis;
                dstEmitter.childRandVel = srcEmitter.childRandVel;
                dstEmitter.childScale = srcEmitter.childScale;
                dstEmitter.childScaleRand = srcEmitter.childScaleRand;
                dstEmitter.UI_childGravityDir = srcEmitter.UI_childGravityDir;
                dstEmitter.fieldRandomVelAdd = srcEmitter.fieldRandomVelAdd;
                dstEmitter.fieldMagnetPos = srcEmitter.fieldMagnetPos;
                dstEmitter.fieldPosAddGlobal = srcEmitter.fieldPosAddGlobal;
                dstEmitter.fieldConvergencePos = srcEmitter.fieldConvergencePos;
                dstEmitter.fieldPosAdd = srcEmitter.fieldPosAdd;
                dstEmitter.fieldSpinOuter = srcEmitter.fieldSpinOuter;
                dstEmitter.stripeUVScroll = srcEmitter.stripeUVScroll;
                dstEmitter.uvScroll = srcEmitter.uvScroll;
                dstEmitter.uvScrollInit = srcEmitter.uvScrollInit;
                dstEmitter.uvScrollInitRand = srcEmitter.uvScrollInitRand;
                dstEmitter.uvRot = srcEmitter.uvRot;
                dstEmitter.uvRotInit = srcEmitter.uvRotInit;
                dstEmitter.uvRotInitRand = srcEmitter.uvRotInitRand;
                dstEmitter.uvScale = srcEmitter.uvScale;
                dstEmitter.uvScaleInit = srcEmitter.uvScaleInit;
                dstEmitter.uvScaleInitRand = srcEmitter.uvScaleInitRand;
                dstEmitter.UI_transformTrans = srcEmitter.UI_transformTrans;

                dstEmitter.useSoftParticle = srcEmitter.useSoftParticle;
                dstEmitter.softParticleFadeDistance = srcEmitter.softParticleFadeDistance;
                dstEmitter.softParticleVolumeParam  = srcEmitter.softParticleVolumeParam;
                dstEmitter.shaderParam0 = srcEmitter.shaderParam0;
                dstEmitter.shaderParam1 = srcEmitter.shaderParam1;
                dstEmitter.childUseSoftParticle = srcEmitter.childUseSoftParticle;
                dstEmitter.childSoftParticleFadeDistance = srcEmitter.childSoftParticleFadeDistance;
                dstEmitter.childSoftParticleVolumeParam  = srcEmitter.childSoftParticleVolumeParam;
                dstEmitter.childShaderParam0 = srcEmitter.childShaderParam0;
                dstEmitter.childShaderParam1 = srcEmitter.childShaderParam1;
                dstEmitter.order = srcEmitter.order;
                dstEmitter.isChildColorScaleInherited = srcEmitter.isChildColorScaleInherited;
                dstEmitter.lineCenter = srcEmitter.lineCenter;

                dstEmitter.color0RepeatStartRand = srcEmitter.color0RepeatStartRand;
                dstEmitter.color1RepeatStartRand = srcEmitter.color1RepeatStartRand;
                dstEmitter.colorScale = srcEmitter.colorScale;
                dstEmitter.drawPath = srcEmitter.drawPath;

                dstEmitter.UI_color0_color1 = srcEmitter.UI_color0_color1;
                dstEmitter.UI_color0_color2 = srcEmitter.UI_color0_color2;
                dstEmitter.UI_color0_color3 = srcEmitter.UI_color0_color3;
                dstEmitter.UI_color1_color1 = srcEmitter.UI_color1_color1;
                dstEmitter.UI_color1_color2 = srcEmitter.UI_color1_color2;
                dstEmitter.UI_color1_color3 = srcEmitter.UI_color1_color3;
                dstEmitter.UI_childConstColor0 = srcEmitter.UI_childConstColor0;
                dstEmitter.UI_childConstColor1 = srcEmitter.UI_childConstColor1;
                dstEmitter.UI_childColor = srcEmitter.UI_childColor;
                dstEmitter.UI_childInheritanceColor = srcEmitter.UI_childInheritanceColor;
#if ___CE2UPDATE___
                dstEmitter.billboardPrimitiveFileSource = srcEmitter.billboardPrimitiveFileSource.Replace(".cmdl", ".fmdb");
#else
                dstEmitter.billboardPrimitiveFileSource = srcEmitter.billboardPrimitiveFileSource;
#endif
                dstEmitter.UI_childTexAvailableMipLevel = srcEmitter.UI_childTexAvailableMipLevel;
                dstEmitter.UI_childTexMipMapBias = srcEmitter.UI_childTexMipMapBias;
                dstEmitter.UI_numUseSubTexPatTbl = srcEmitter.UI_numUseSubTexPatTbl;
                dstEmitter.UI_subAvailableMipLevel = srcEmitter.UI_subAvailableMipLevel;
                dstEmitter.UI_subMipMapBias = srcEmitter.UI_subMipMapBias;
                dstEmitter.UI_subTexPatAnim = srcEmitter.UI_subTexPatAnim;
                dstEmitter.UI_subTexPatAnimMode = srcEmitter.UI_subTexPatAnimMode;
                dstEmitter.UI_subTexPatDivX = srcEmitter.UI_subTexPatDivX;
                dstEmitter.UI_subTexPatDivY = srcEmitter.UI_subTexPatDivY;
                dstEmitter.UI_subTexPatFreqFrame = srcEmitter.UI_subTexPatFreqFrame;
                dstEmitter.UI_subTexPatIsRandom = srcEmitter.UI_subTexPatIsRandom;
                dstEmitter.UI_subTexPatNumPattern = srcEmitter.UI_subTexPatNumPattern;
                dstEmitter.UI_subTexPatTbl_0  = srcEmitter.UI_subTexPatTbl_0;
                dstEmitter.UI_subTexPatTbl_1  = srcEmitter.UI_subTexPatTbl_1;
                dstEmitter.UI_subTexPatTbl_2  = srcEmitter.UI_subTexPatTbl_2;
                dstEmitter.UI_subTexPatTbl_3  = srcEmitter.UI_subTexPatTbl_3;
                dstEmitter.UI_subTexPatTbl_4  = srcEmitter.UI_subTexPatTbl_4;
                dstEmitter.UI_subTexPatTbl_5  = srcEmitter.UI_subTexPatTbl_5;
                dstEmitter.UI_subTexPatTbl_6  = srcEmitter.UI_subTexPatTbl_6;
                dstEmitter.UI_subTexPatTbl_7  = srcEmitter.UI_subTexPatTbl_7;
                dstEmitter.UI_subTexPatTbl_8  = srcEmitter.UI_subTexPatTbl_8;
                dstEmitter.UI_subTexPatTbl_9  = srcEmitter.UI_subTexPatTbl_9;
                dstEmitter.UI_subTexPatTbl_10 = srcEmitter.UI_subTexPatTbl_10;
                dstEmitter.UI_subTexPatTbl_11 = srcEmitter.UI_subTexPatTbl_11;
                dstEmitter.UI_subTexPatTbl_12 = srcEmitter.UI_subTexPatTbl_12;
                dstEmitter.UI_subTexPatTbl_13 = srcEmitter.UI_subTexPatTbl_13;
                dstEmitter.UI_subTexPatTbl_14 = srcEmitter.UI_subTexPatTbl_14;
                dstEmitter.UI_subTexPatTbl_15 = srcEmitter.UI_subTexPatTbl_15;
                dstEmitter.UI_subTexPatTbl_16 = srcEmitter.UI_subTexPatTbl_16;
                dstEmitter.UI_subTexPatTbl_17 = srcEmitter.UI_subTexPatTbl_17;
                dstEmitter.UI_subTexPatTbl_18 = srcEmitter.UI_subTexPatTbl_18;
                dstEmitter.UI_subTexPatTbl_19 = srcEmitter.UI_subTexPatTbl_19;
                dstEmitter.UI_subTexPatTbl_20 = srcEmitter.UI_subTexPatTbl_20;
                dstEmitter.UI_subTexPatTbl_21 = srcEmitter.UI_subTexPatTbl_21;
                dstEmitter.UI_subTexPatTbl_22 = srcEmitter.UI_subTexPatTbl_22;
                dstEmitter.UI_subTexPatTbl_23 = srcEmitter.UI_subTexPatTbl_23;
                dstEmitter.UI_subTexPatTbl_24 = srcEmitter.UI_subTexPatTbl_24;
                dstEmitter.UI_subTexPatTbl_25 = srcEmitter.UI_subTexPatTbl_25;
                dstEmitter.UI_subTexPatTbl_26 = srcEmitter.UI_subTexPatTbl_26;
                dstEmitter.UI_subTexPatTbl_27 = srcEmitter.UI_subTexPatTbl_27;
                dstEmitter.UI_subTexPatTbl_28 = srcEmitter.UI_subTexPatTbl_28;
                dstEmitter.UI_subTexPatTbl_29 = srcEmitter.UI_subTexPatTbl_29;
                dstEmitter.UI_subTexPatTbl_30 = srcEmitter.UI_subTexPatTbl_30;
                dstEmitter.UI_subTexPatTbl_31 = srcEmitter.UI_subTexPatTbl_31;
                dstEmitter.UI_texAvailableMipLevel = srcEmitter.UI_texAvailableMipLevel;
                dstEmitter.UI_texMipMapBias = srcEmitter.UI_texMipMapBias;

#if ___CE2UPDATE___
                dstEmitter.childBillboardPrimitiveFileSource = srcEmitter.childBillboardPrimitiveFileSource.Replace(".cmdl", ".fmdb");
#else
                dstEmitter.childBillboardPrimitiveFileSource = srcEmitter.childBillboardPrimitiveFileSource;
#endif
                dstEmitter.childColorScale = srcEmitter.childColorScale;
                dstEmitter.rotResist = srcEmitter.rotResist;
                dstEmitter.childRotResist = srcEmitter.childRotResist;
                dstEmitter.stripeHLType = srcEmitter.stripeHLType;
                dstEmitter.stripeNumDivisions = srcEmitter.stripeNumDivisions;
                dstEmitter.stripeSubDivs = srcEmitter.stripeSubDivs;

                dstEmitter.subTexUVRot = srcEmitter.subTexUVRot;
                dstEmitter.subTexUVRotInit = srcEmitter.subTexUVRotInit;
                dstEmitter.subTexUVRotInitRand = srcEmitter.subTexUVRotInitRand;
                dstEmitter.subTexUVScale = srcEmitter.subTexUVScale;
                dstEmitter.subTexUVScaleInit = srcEmitter.subTexUVScaleInit;
                dstEmitter.subTexUVScaleInitRand = srcEmitter.subTexUVScaleInitRand;
                dstEmitter.subTexUVScroll = srcEmitter.subTexUVScroll;
                dstEmitter.subTexUVScrollInit = srcEmitter.subTexUVScrollInit;
                dstEmitter.subTexUVScrollInitRand = srcEmitter.subTexUVScrollInitRand;

#if ___CE2UPDATE___
                dstEmitter.texture2                 = srcEmitter.texture2.Replace(".tga", ".ftxb");
#else
                dstEmitter.texture2                 = srcEmitter.texture2;
#endif

                dstEmitter.tex2UVRot                = srcEmitter.tex2UVRot;
                dstEmitter.tex2UVRotInit            = srcEmitter.tex2UVRotInit;
                dstEmitter.tex2UVRotInitRand        = srcEmitter.tex2UVRotInitRand;
                dstEmitter.tex2UVScale              = srcEmitter.tex2UVScale;
                dstEmitter.tex2UVScaleInit          = srcEmitter.tex2UVScaleInit;
                dstEmitter.tex2UVScaleInitRand      = srcEmitter.tex2UVScaleInitRand;
                dstEmitter.tex2UVScroll             = srcEmitter.tex2UVScroll;
                dstEmitter.tex2UVScrollInit         = srcEmitter.tex2UVScrollInit;
                dstEmitter.tex2UVScrollInitRand     = srcEmitter.tex2UVScrollInitRand;

                dstEmitter.UI_tex2AvailableMipLevel = srcEmitter.UI_tex2AvailableMipLevel;
                dstEmitter.UI_numUseTex2PatTbl      = srcEmitter.UI_numUseTex2PatTbl;
                dstEmitter.UI_tex2MipMapBias        = srcEmitter.UI_tex2MipMapBias;
                dstEmitter.UI_tex2PatAnim           = srcEmitter.UI_tex2PatAnim;
                dstEmitter.UI_tex2PatAnimMode       = srcEmitter.UI_tex2PatAnimMode;
                dstEmitter.UI_tex2PatDivX           = srcEmitter.UI_tex2PatDivX;
                dstEmitter.UI_tex2PatDivY           = srcEmitter.UI_tex2PatDivY;
                dstEmitter.UI_tex2PatFreqFrame      = srcEmitter.UI_tex2PatFreqFrame;
                dstEmitter.UI_tex2PatIsRandom       = srcEmitter.UI_tex2PatIsRandom;
                dstEmitter.UI_tex2PatNumPattern     = srcEmitter.UI_tex2PatNumPattern;
                dstEmitter.UI_tex2PatTbl_0          = srcEmitter.UI_tex2PatTbl_0;
                dstEmitter.UI_tex2PatTbl_1          = srcEmitter.UI_tex2PatTbl_1;
                dstEmitter.UI_tex2PatTbl_2          = srcEmitter.UI_tex2PatTbl_2;
                dstEmitter.UI_tex2PatTbl_3          = srcEmitter.UI_tex2PatTbl_3;
                dstEmitter.UI_tex2PatTbl_4          = srcEmitter.UI_tex2PatTbl_4;
                dstEmitter.UI_tex2PatTbl_5          = srcEmitter.UI_tex2PatTbl_5;
                dstEmitter.UI_tex2PatTbl_6          = srcEmitter.UI_tex2PatTbl_6;
                dstEmitter.UI_tex2PatTbl_7          = srcEmitter.UI_tex2PatTbl_7;
                dstEmitter.UI_tex2PatTbl_8          = srcEmitter.UI_tex2PatTbl_8;
                dstEmitter.UI_tex2PatTbl_9          = srcEmitter.UI_tex2PatTbl_9;
                dstEmitter.UI_tex2PatTbl_10         = srcEmitter.UI_tex2PatTbl_10;
                dstEmitter.UI_tex2PatTbl_11         = srcEmitter.UI_tex2PatTbl_11;
                dstEmitter.UI_tex2PatTbl_12         = srcEmitter.UI_tex2PatTbl_12;
                dstEmitter.UI_tex2PatTbl_13         = srcEmitter.UI_tex2PatTbl_13;
                dstEmitter.UI_tex2PatTbl_14         = srcEmitter.UI_tex2PatTbl_14;
                dstEmitter.UI_tex2PatTbl_15         = srcEmitter.UI_tex2PatTbl_15;
                dstEmitter.UI_tex2PatTbl_16         = srcEmitter.UI_tex2PatTbl_16;
                dstEmitter.UI_tex2PatTbl_17         = srcEmitter.UI_tex2PatTbl_17;
                dstEmitter.UI_tex2PatTbl_18         = srcEmitter.UI_tex2PatTbl_18;
                dstEmitter.UI_tex2PatTbl_19         = srcEmitter.UI_tex2PatTbl_19;
                dstEmitter.UI_tex2PatTbl_20         = srcEmitter.UI_tex2PatTbl_20;
                dstEmitter.UI_tex2PatTbl_21         = srcEmitter.UI_tex2PatTbl_21;
                dstEmitter.UI_tex2PatTbl_22         = srcEmitter.UI_tex2PatTbl_22;
                dstEmitter.UI_tex2PatTbl_23         = srcEmitter.UI_tex2PatTbl_23;
                dstEmitter.UI_tex2PatTbl_24         = srcEmitter.UI_tex2PatTbl_24;
                dstEmitter.UI_tex2PatTbl_25         = srcEmitter.UI_tex2PatTbl_25;
                dstEmitter.UI_tex2PatTbl_26         = srcEmitter.UI_tex2PatTbl_26;
                dstEmitter.UI_tex2PatTbl_27         = srcEmitter.UI_tex2PatTbl_27;
                dstEmitter.UI_tex2PatTbl_28         = srcEmitter.UI_tex2PatTbl_28;
                dstEmitter.UI_tex2PatTbl_29         = srcEmitter.UI_tex2PatTbl_29;
                dstEmitter.UI_tex2PatTbl_30         = srcEmitter.UI_tex2PatTbl_30;
                dstEmitter.UI_tex2PatTbl_31         = srcEmitter.UI_tex2PatTbl_31;

                dstEmitter.textureTrimming = srcEmitter.textureTrimming;

                dstEmitter.DispParticle = srcEmitter.DispParticle;

                dstEmitter.dynamicsRandom      = srcEmitter.dynamicsRandom;
                dstEmitter.childDynamicsRandom = srcEmitter.childDynamicsRandom;

                dstEmitter.emitterVelDirAngle = srcEmitter.emitterVelDirAngle;

                dstEmitter.UI_hostioEmitterFlg = srcEmitter.UI_hostioEmitterFlg;

                dstEmitter.UI_transformTransRnd = srcEmitter.UI_transformTransRnd;
                dstEmitter.UI_UpdateEmitterMatrixByEmit = srcEmitter.UI_UpdateEmitterMatrixByEmit;

                dstEmitter.applyAlphaToRefraction      = srcEmitter.applyAlphaToRefraction;
                dstEmitter.childApplyAlphaToRefraction = srcEmitter.childApplyAlphaToRefraction;

                dstEmitter.EmitDistEnabled = srcEmitter.EmitDistEnabled;
                dstEmitter.EmitDistMargin  = srcEmitter.EmitDistMargin;
                dstEmitter.EmitDistMax     = srcEmitter.EmitDistMax;
                dstEmitter.EmitDistMin     = srcEmitter.EmitDistMin;
                dstEmitter.EmitDistUnit    = srcEmitter.EmitDistUnit;

                dstEmitter.UI_volumeSurfacePosRand = srcEmitter.UI_volumeSurfacePosRand;
                dstEmitter.volumeLatitude = srcEmitter.volumeLatitude;
                dstEmitter.volumeLatitudeEnabled = srcEmitter.volumeLatitudeEnabled;
                dstEmitter.xzDiffusionVel = srcEmitter.xzDiffusionVel;
                dstEmitter.initPosRand = srcEmitter.initPosRand;
                dstEmitter.stripeHistoryInterpolate = srcEmitter.stripeHistoryInterpolate;
                dstEmitter.UI_NegativeScaleRangeEnabled = srcEmitter.UI_NegativeScaleRangeEnabled;

                dstEmitter.userCallbackID = srcEmitter.userCallbackID;

                //-------------------------------------------------------------
                // TODO : Convert old data to new data model
                //-------------------------------------------------------------
                // Child never use shader.
                if ( srcEmitter.childShaderType==PrevVerDataModel.ShaderType.DistortionParticle )
                    dstEmitter.childShaderType = CurrVerDataModel.ShaderType.Particle;
                else
                    dstEmitter.childShaderType = (CurrVerDataModel.ShaderType)srcEmitter.childShaderType;

                {
                    // Convert texture UV anim mode
                    // Previous version:
                    // 0: none
                    // 1: scroll
                    // 2: scale
                    // 3: rotate
                    // 4: all of them
                    //
                    // New version (as a bitfield):
                    // 8: scroll
                    // 16: scale
                    // 32: rotate
                    switch ( srcEmitter.uvShiftAnimMode )
                    {
                        case 1: dstEmitter.uvShiftAnimMode = 8; break;
                        case 2: dstEmitter.uvShiftAnimMode = 16; break;
                        case 3: dstEmitter.uvShiftAnimMode = 32; break;
                        case 4: dstEmitter.uvShiftAnimMode = 8 + 16 + 32; break;
                        default: dstEmitter.uvShiftAnimMode = srcEmitter.uvShiftAnimMode; break;
                    }
                    switch ( srcEmitter.subTexUVShiftAnimMode )
                    {
                        case 1: dstEmitter.subTexUVShiftAnimMode = 8; break;
                        case 2: dstEmitter.subTexUVShiftAnimMode = 16; break;
                        case 3: dstEmitter.subTexUVShiftAnimMode = 32; break;
                        case 4: dstEmitter.subTexUVShiftAnimMode = 8 + 16 + 32; break;
                        default: dstEmitter.subTexUVShiftAnimMode = srcEmitter.subTexUVShiftAnimMode; break;
                    }
                    switch ( srcEmitter.tex2UVShiftAnimMode )
                    {
                        case 1: dstEmitter.tex2UVShiftAnimMode = 8; break;
                        case 2: dstEmitter.tex2UVShiftAnimMode = 16; break;
                        case 3: dstEmitter.tex2UVShiftAnimMode = 32; break;
                        case 4: dstEmitter.tex2UVShiftAnimMode = 8 + 16 + 32; break;
                        default: dstEmitter.tex2UVShiftAnimMode = srcEmitter.tex2UVShiftAnimMode; break;
                    }
                }

                dstEmitter.UI_texWrapU      = srcEmitter.UI_texWrapU;
                dstEmitter.UI_texWrapV      = srcEmitter.UI_texWrapV;
                dstEmitter.UI_subTexWrapU   = srcEmitter.UI_subTexWrapU;
                dstEmitter.UI_subTexWrapV   = srcEmitter.UI_subTexWrapV;
                dstEmitter.UI_tex2WrapU     = srcEmitter.UI_tex2WrapU;
                dstEmitter.UI_tex2WrapV     = srcEmitter.UI_tex2WrapV;
                dstEmitter.UI_childTexWrapU = srcEmitter.UI_childTexWrapU;
                dstEmitter.UI_childTexWrapV = srcEmitter.UI_childTexWrapV;

                // Set mirror once to mirror.
                if ( dstEmitter.UI_texWrapU==(int)CurrVerDataModel.TextureWrapMode.MirrorOnce )
                    dstEmitter.UI_texWrapU = (int)CurrVerDataModel.TextureWrapMode.Mirror;
                if ( dstEmitter.UI_texWrapV==(int)CurrVerDataModel.TextureWrapMode.MirrorOnce )
                    dstEmitter.UI_texWrapV = (int)CurrVerDataModel.TextureWrapMode.Mirror;

                if ( dstEmitter.UI_subTexWrapU==(int)CurrVerDataModel.TextureWrapMode.MirrorOnce )
                    dstEmitter.UI_subTexWrapU = (int)CurrVerDataModel.TextureWrapMode.Mirror;
                if ( dstEmitter.UI_subTexWrapV==(int)CurrVerDataModel.TextureWrapMode.MirrorOnce )
                    dstEmitter.UI_subTexWrapV = (int)CurrVerDataModel.TextureWrapMode.Mirror;

                if ( dstEmitter.UI_tex2WrapU==(int)CurrVerDataModel.TextureWrapMode.MirrorOnce )
                    dstEmitter.UI_tex2WrapU = (int)CurrVerDataModel.TextureWrapMode.Mirror;
                if ( dstEmitter.UI_tex2WrapV==(int)CurrVerDataModel.TextureWrapMode.MirrorOnce )
                    dstEmitter.UI_tex2WrapV = (int)CurrVerDataModel.TextureWrapMode.Mirror;

                if ( dstEmitter.UI_childTexWrapU==(int)CurrVerDataModel.TextureWrapMode.MirrorOnce )
                    dstEmitter.UI_childTexWrapU = (int)CurrVerDataModel.TextureWrapMode.Mirror;
                if ( dstEmitter.UI_childTexWrapV==(int)CurrVerDataModel.TextureWrapMode.MirrorOnce )
                    dstEmitter.UI_childTexWrapV = (int)CurrVerDataModel.TextureWrapMode.Mirror;

                // Emitter user data group
                {
                    PrevVerDataModel.EmitterUserData[] srcGroup = srcEmitter.userDataGroups;
                    CurrVerDataModel.EmitterUserData[] dstGroup = dstEmitter.userDataGroups;
                    for ( int i=0;i<srcGroup.Length;++i )
                    {
                        dstGroup[i].Data1 = srcGroup[i].Data1;
                        dstGroup[i].Data2 = srcGroup[i].Data2;

                        for ( int j=0;j<srcGroup[i].ParamsF.Length;++j )
                        {
                            dstGroup[i].ParamsF[j] = srcGroup[i].ParamsF[j];
                        }
                    }

                    // Set the data back.
                    dstEmitter.userDataGroups = dstGroup;
                }

                // Emitter user shader group
                {
                    dstEmitter.userShaderSetting = srcEmitter.userShaderSetting;

                    PrevVerDataModel.UserShaderParameter[] srcGroup = srcEmitter.userShaderParamGroups;
                    CurrVerDataModel.UserShaderParameter[] dstGroup = dstEmitter.userShaderParamGroups;
                    for ( int i=0;i<srcGroup.Length;++i )
                    {
                        dstGroup[i].ComposedBitFlags = srcGroup[i].ComposedBitFlags;
                        dstGroup[i].ComposedBytes    = srcGroup[i].ComposedBytes;

                        for ( int j=0;j<srcGroup[i].Params.Length;++j )
                            dstGroup[i].Params[j] = srcGroup[i].Params[j];
                    }

                    // Set the data back.
                    dstEmitter.userShaderParamGroups = dstGroup;
                }

                // Child user shader group
                {
                    dstEmitter.childUserShaderSetting = srcEmitter.childUserShaderSetting;

                    PrevVerDataModel.UserShaderParameter[] srcGroup = srcEmitter.childUserShaderParamGroups;
                    CurrVerDataModel.UserShaderParameter[] dstGroup = dstEmitter.childUserShaderParamGroups;
                    for ( int i=0;i<srcGroup.Length;++i )
                    {
                        dstGroup[i].ComposedBitFlags = srcGroup[i].ComposedBitFlags;
                        dstGroup[i].ComposedBytes    = srcGroup[i].ComposedBytes;

                        for ( int j=0;j<srcGroup[i].Params.Length;++j )
                            dstGroup[i].Params[j] = srcGroup[i].Params[j];
                    }

                    // Set the data back.
                    dstEmitter.childUserShaderParamGroups = dstGroup;
                }

                dstEmitter.UI_randomType = (CurrVerDataModel.EmitterRandomTypes)srcEmitter.UI_randomType;
                dstEmitter.UI_randomSeed = srcEmitter.UI_randomSeed;

                dstEmitter.stripeComputeType = (CurrVerDataModel.StripeComputeType)srcEmitter.stripeComputeType;

                dstEmitter.meshType        = (CurrVerDataModel.MeshType)srcEmitter.meshType;
                dstEmitter.UI_particleType = (CurrVerDataModel.BillboardType)srcEmitter.UI_particleType;
                dstEmitter.UI_stripeType   = (CurrVerDataModel.StripeType)srcEmitter.UI_stripeType;

                dstEmitter.childMeshType      = (CurrVerDataModel.MeshType)srcEmitter.childMeshType;
                dstEmitter.childBillboardType = (CurrVerDataModel.BillboardType)srcEmitter.childBillboardType;

                dstEmitter.TexCoordType = (CurrVerDataModel.StripeTexCoordTypes)srcEmitter.TexCoordType;
                dstEmitter.volumeLatitudeDir = (CurrVerDataModel.VolumeLatitudeDirection)srcEmitter.volumeLatitudeDir;

                dstEmitter.softParticleProcessingMethod      = (CurrVerDataModel.SoftParticleProcessingMethod)srcEmitter.softParticleProcessingMethod;
                dstEmitter.childSoftParticleProcessingMethod = (CurrVerDataModel.SoftParticleProcessingMethod)srcEmitter.childSoftParticleProcessingMethod;

                dstEmitter.UI_alphaDstType      = (CurrVerDataModel.AlphaDst)srcEmitter.UI_alphaDstType;
                dstEmitter.UI_childAlphaDstType = (CurrVerDataModel.AlphaDst)srcEmitter.UI_childAlphaDstType;

                // Convert alpha combiner
                {
                    bool bReplaceAlphaWithRed = false;
                    if ( dstEmitter.UI_alphaDstType==CurrVerDataModel.AlphaDst.ModulateTexAlphaR )
                    {
                        dstEmitter.UI_alphaDstType = CurrVerDataModel.AlphaDst.ModulateTex;
                        bReplaceAlphaWithRed = true;
                    }
                    else if ( dstEmitter.UI_alphaDstType==CurrVerDataModel.AlphaDst.SubtractFromTexAlphaR )
                    {
                        dstEmitter.UI_alphaDstType = CurrVerDataModel.AlphaDst.SubtractFromTex;
                        bReplaceAlphaWithRed = true;
                    }

                    if ( bReplaceAlphaWithRed==true )
                    {
                        if ( dstEmitter.combinerTextureAlphaUsage==CurrVerDataModel.CombinerAlphaUsageTypes.Color )
                            dstEmitter.combinerTextureAlphaUsage = CurrVerDataModel.CombinerAlphaUsageTypes.Red;

                        if ( dstEmitter.combinerSubTextureAlphaUsage==CurrVerDataModel.CombinerAlphaUsageTypes.Color )
                            dstEmitter.combinerSubTextureAlphaUsage = CurrVerDataModel.CombinerAlphaUsageTypes.Red;

                        if ( dstEmitter.combinerTexture2AlphaUsage==CurrVerDataModel.CombinerAlphaUsageTypes.Color )
                            dstEmitter.combinerTexture2AlphaUsage = CurrVerDataModel.CombinerAlphaUsageTypes.Red;
                    }

                    bReplaceAlphaWithRed = false;
                    if ( dstEmitter.UI_childAlphaDstType==CurrVerDataModel.AlphaDst.ModulateTexAlphaR )
                    {
                        dstEmitter.UI_childAlphaDstType = CurrVerDataModel.AlphaDst.ModulateTex;
                        bReplaceAlphaWithRed = true;
                    }
                    else if ( dstEmitter.UI_childAlphaDstType==CurrVerDataModel.AlphaDst.SubtractFromTexAlphaR )
                    {
                        dstEmitter.UI_childAlphaDstType = CurrVerDataModel.AlphaDst.SubtractFromTex;
                        bReplaceAlphaWithRed = true;
                    }

                    if ( bReplaceAlphaWithRed==true )
                    {
                        if ( dstEmitter.combinerTextureAlphaUsage==CurrVerDataModel.CombinerAlphaUsageTypes.Color )
                            dstEmitter.combinerTextureAlphaUsage = CurrVerDataModel.CombinerAlphaUsageTypes.Red;
                    }
                }

                dstEmitter.UI_color0_animType       = (CurrVerDataModel.ParticleAnimationTypes)srcEmitter.UI_color0_animType;
                dstEmitter.UI_color1_animType       = (CurrVerDataModel.ParticleAnimationTypes)srcEmitter.UI_color1_animType;
                dstEmitter.UI_particleAlphaAnimType = (CurrVerDataModel.ParticleAnimationTypes)srcEmitter.UI_particleAlphaAnimType;
                dstEmitter.UI_particleScaleAnimType = (CurrVerDataModel.ParticleAnimationTypes)srcEmitter.UI_particleScaleAnimType;

                dstEmitter.combinerPrimitiveAlphaBlend  = (CurrVerDataModel.CombinerBlendTypes)srcEmitter.combinerPrimitiveAlphaBlend;
                dstEmitter.combinerPrimitiveColorBlend  = (CurrVerDataModel.CombinerBlendTypes)srcEmitter.combinerPrimitiveColorBlend;
                dstEmitter.combinerSubTextureAlphaBlend = (CurrVerDataModel.CombinerBlendTypes)srcEmitter.combinerSubTextureAlphaBlend;
                dstEmitter.combinerSubTextureColorBlend = (CurrVerDataModel.CombinerBlendTypes)srcEmitter.combinerSubTextureColorBlend;
                dstEmitter.combinerTexture2AlphaBlend   = (CurrVerDataModel.CombinerBlendTypes)srcEmitter.combinerTexture2AlphaBlend;
                dstEmitter.combinerTexture2ColorBlend   = (CurrVerDataModel.CombinerBlendTypes)srcEmitter.combinerTexture2ColorBlend;
                dstEmitter.combinerPrimitiveColorUsage  = (CurrVerDataModel.CombinerColorUsageTypes)srcEmitter.combinerPrimitiveColorUsage;
                dstEmitter.combinerSubTextureColorUsage = (CurrVerDataModel.CombinerColorUsageTypes)srcEmitter.combinerSubTextureColorUsage;
                dstEmitter.combinerTextureColorUsage    = (CurrVerDataModel.CombinerColorUsageTypes)srcEmitter.combinerTextureColorUsage;
                dstEmitter.combinerTexture2ColorUsage   = (CurrVerDataModel.CombinerColorUsageTypes)srcEmitter.combinerTexture2ColorUsage;
                dstEmitter.combinerPrimitiveAlphaUsage  = (CurrVerDataModel.CombinerAlphaUsageTypes)srcEmitter.combinerPrimitiveAlphaUsage;
                dstEmitter.combinerTextureAlphaUsage    = (CurrVerDataModel.CombinerAlphaUsageTypes)srcEmitter.combinerTextureAlphaUsage;
                dstEmitter.combinerSubTextureAlphaUsage = (CurrVerDataModel.CombinerAlphaUsageTypes)srcEmitter.combinerSubTextureAlphaUsage;
                dstEmitter.combinerTexture2AlphaUsage   = (CurrVerDataModel.CombinerAlphaUsageTypes)srcEmitter.combinerTexture2AlphaUsage;
                dstEmitter.combinerShaderProjectPath    = srcEmitter.combinerShaderProjectPath;

                dstEmitter.childCombinerPrimitiveAlphaBlend = (CurrVerDataModel.CombinerBlendTypes)srcEmitter.childCombinerPrimitiveAlphaBlend;
                dstEmitter.childCombinerPrimitiveAlphaUsage = (CurrVerDataModel.CombinerAlphaUsageTypes)srcEmitter.childCombinerPrimitiveAlphaUsage;
                dstEmitter.childCombinerTextureAlphaUsage   = (CurrVerDataModel.CombinerAlphaUsageTypes)srcEmitter.childCombinerTextureAlphaUsage;
                dstEmitter.childCombinerPrimitiveColorBlend = (CurrVerDataModel.CombinerBlendTypes)srcEmitter.childCombinerPrimitiveColorBlend;
                dstEmitter.childCombinerPrimitiveColorUsage = (CurrVerDataModel.CombinerColorUsageTypes)srcEmitter.childCombinerPrimitiveColorUsage;
                dstEmitter.childCombinerTextureColorUsage   = (CurrVerDataModel.CombinerColorUsageTypes)srcEmitter.childCombinerTextureColorUsage;
                dstEmitter.childCombinerShaderProjectPath   = srcEmitter.childCombinerShaderProjectPath;

                dstEmitter.type = (CurrVerDataModel.EmitterType)srcEmitter.type;
                dstEmitter.volumeType = (CurrVerDataModel.VolumeType)srcEmitter.volumeType;
                dstEmitter.DisplaySide = (CurrVerDataModel.DisplaySideTypes)srcEmitter.DisplaySide;
                dstEmitter.stripeConnectType = (CurrVerDataModel.StripeConnectTypes)srcEmitter.stripeConnectType;
                dstEmitter.UI_blendType = (CurrVerDataModel.BlendType)srcEmitter.UI_blendType;
                dstEmitter.UI_rotType = (CurrVerDataModel.PtclRotType)srcEmitter.UI_rotType;
                dstEmitter.UI_followType = (CurrVerDataModel.FollowType)srcEmitter.UI_followType;
                dstEmitter.UI_textureAddressing = (CurrVerDataModel.TextureAddressing)srcEmitter.UI_textureAddressing;
                dstEmitter.zBufATestType = (CurrVerDataModel.ZBufATestType)srcEmitter.zBufATestType;
                dstEmitter.UI_texFilterMode = (CurrVerDataModel.FilterMode)srcEmitter.UI_texFilterMode;
                dstEmitter.UI_fadeOutType = (CurrVerDataModel.FadeOutType)srcEmitter.UI_fadeOutType;
                dstEmitter.UI_childBlendType = (CurrVerDataModel.BlendType)srcEmitter.UI_childBlendType;
                dstEmitter.UI_childRotType = (CurrVerDataModel.PtclRotType)srcEmitter.UI_childRotType;
                dstEmitter.UI_childTextureAddressing = (CurrVerDataModel.TextureAddressing)srcEmitter.UI_childTextureAddressing;
                dstEmitter.childZBufATestType = (CurrVerDataModel.ZBufATestType)srcEmitter.childZBufATestType;
                dstEmitter.UI_childTexFilterMode = (CurrVerDataModel.FilterMode)srcEmitter.UI_childTexFilterMode;
                dstEmitter.shaderType = (CurrVerDataModel.ShaderType)srcEmitter.shaderType;
                dstEmitter.UI_SubTexFilterMode = (CurrVerDataModel.FilterMode)srcEmitter.UI_SubTexFilterMode;
                dstEmitter.UI_subTextureAddressing = (CurrVerDataModel.TextureAddressing)srcEmitter.UI_subTextureAddressing;
                dstEmitter.UI_tex2FilterMode = (CurrVerDataModel.FilterMode)srcEmitter.UI_tex2FilterMode;
                dstEmitter.UI_texture2Addressing = (CurrVerDataModel.TextureAddressing)srcEmitter.UI_texture2Addressing;

                dstEmitter.childDisplaySide = (CurrVerDataModel.DisplaySideTypes)srcEmitter.childDisplaySide;

                dstEmitter.UI_childScaleTarget = new CurrVerDataModel.Vector2i( (int)srcEmitter.UI_childScaleTarget.X,
                                                                                (int)srcEmitter.UI_childScaleTarget.Y );
                dstEmitter.UI_scale1 = ConvertVector( srcEmitter.UI_scale1 );
                dstEmitter.UI_scale2Relative = ConvertVector( srcEmitter.UI_scale2Relative );
                dstEmitter.UI_scale3 = ConvertVector( srcEmitter.UI_scale3 );
                dstEmitter.UI_initRot = ConvertVector( srcEmitter.UI_initRot );
                dstEmitter.UI_initRotRand = ConvertVector( srcEmitter.UI_initRotRand );
                dstEmitter.UI_rotVel = ConvertVector( srcEmitter.UI_rotVel );
                dstEmitter.UI_rotVelRand = ConvertVector( srcEmitter.UI_rotVelRand );
                dstEmitter.UI_childInitRot = ConvertVector( srcEmitter.UI_childInitRot );
                dstEmitter.UI_childInitRotRand = ConvertVector( srcEmitter.UI_childInitRotRand );
                dstEmitter.UI_childRotVel = ConvertVector( srcEmitter.UI_childRotVel );
                dstEmitter.UI_childRotVelRand = ConvertVector( srcEmitter.UI_childRotVelRand );
                dstEmitter.UI_transformRot = ConvertVector( srcEmitter.UI_transformRot );
                dstEmitter.UI_transformRotRnd   = ConvertVector( srcEmitter.UI_transformRotRnd );
                dstEmitter.UI_childRotDirRand = ConvertVector( srcEmitter.UI_childRotDirRand );
                dstEmitter.UI_rotDirRand = ConvertVector( srcEmitter.UI_rotDirRand );

                //-------------------------------------------------------------
                // Add the converted emitter to the destination emitter list
                //-------------------------------------------------------------
                dstData.EmitterList.Add( dstEmitter );
            }

#endregion

            return dstData;
        }

#endregion

        #region Utility methods

        /// <summary>
        /// Convert vector from the previous to the current version.
        /// </summary>
        /// <param name="src">The source vector of the previous version.</param>
        /// <returns>The converted current version vector.</returns>
        private CurrVerDataModel.Vector1i ConvertVector( PrevVerDataModel.Vector1i src )
        {
            return new CurrVerDataModel.Vector1i( src.X );
        }


        /// <summary>
        /// Convert vector from the previous to the current version.
        /// </summary>
        /// <param name="src">The source vector of the previous version.</param>
        /// <returns>The converted current version vector.</returns>
        private CurrVerDataModel.Vector2i ConvertVector( PrevVerDataModel.Vector2i src )
        {
            return new CurrVerDataModel.Vector2i( src.X,
                                                  src.Y );
        }


        /// <summary>
        /// Convert vector from the previous to the current version.
        /// </summary>
        /// <param name="src">The source vector of the previous version.</param>
        /// <returns>The converted current version vector.</returns>
        private CurrVerDataModel.Vector3i ConvertVector( PrevVerDataModel.Vector3i src )
        {
            return new CurrVerDataModel.Vector3i( src.X,
                                                  src.Y,
                                                  src.Z );
        }


        /// <summary>
        /// Convert vector from the previous to the current version.
        /// </summary>
        /// <param name="src">The source vector of the previous version.</param>
        /// <returns>The converted current version vector.</returns>
        private CurrVerDataModel.Vector4i ConvertVector( PrevVerDataModel.Vector4i src )
        {
            return new CurrVerDataModel.Vector4i( src.X,
                                                  src.Y,
                                                  src.Z,
                                                  src.W );
        }


        /// <summary>
        /// Convert animation table list from the previous to the current version.
        /// </summary>
        /// <param name="src">The source animation table list of the previous version.</param>
        /// <param name="dst">The converted current version animation table list.</param>
        /// <returns>True on success.</returns>
        private bool ConvertAnimTableList( PrevVerSerializer.AnimTableListXml src,
                                           CurrVerSerializer.AnimTableListXml dst )
        {
            System.IO.MemoryStream stream = new System.IO.MemoryStream();

            // Write the source animation table list.
            using ( System.Xml.XmlWriter writer = System.Xml.XmlWriter.Create( stream ) )
            {
                writer.WriteStartDocument( true );
                writer.WriteStartElement( "animations" );

                src.WriteXml( writer );

                writer.WriteEndElement();
                writer.WriteEndDocument();
            }

            // Rewind the stream.
            stream.Position = 0;

            // Read with the destination animation table list.
            System.Xml.XmlReader reader = new System.Xml.XmlTextReader( stream );

            reader.MoveToElement();

            dst.ReadXml( reader );

            // Clean up.
            stream.Close();

            return true;
        }

        #endregion

        #region Member variables

        private Version m_prevVersion = new Version( 1, 6, 0, 0 );
        private Version m_currVersion = new Version( 1, 7, 0, 0 );

        #endregion
    }
}
