﻿// ========================================================================
// <copyright file="WorkSpaceDocument.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;

//using App.Command;
using App.IO;
//using App.PropertyEdit;
using App.Utility;

using NWCore.DataModel;

namespace App.Data
{
    /// <summary>
    /// Document class for work space.
    /// </summary>
    public class WorkSpaceDocument : BaseProjectPanelDocument
    {
        #region Constructors

        /// <summary>
        /// Constructor
        /// </summary>
        public WorkSpaceDocument() :
            base( res.Strings.WORK_SPACE_DEFAULT_NAME )
        {
        }

        #endregion

        #region Properties

        /// <summary>
        /// Object ID.
        /// </summary>
        public override GuiObjectID ObjectID
        {
            get { return GuiObjectID.WorkSpace; }
        }


        /// <summary>
        /// 名前
        /// </summary>
        public override string Name
        {
            get
            {
                return res.Strings.WORK_SPACE_DEFAULT_NAME;
            }
            set
            {
            }
        }


        /// <summary>
        /// オーナードキュメント。
        /// </summary>
        public override IDocument OwnerDocument
        {
            get { return ProjectManager.ActiveProject; }
        }


        /// <summary>
        /// data source path without data model
        /// </summary>
        public override string RelativeDataScrPath
        {
            get
            {
                return string.Empty;
            }
        }


        /// <summary>
        /// path of the data source
        /// </summary>
        public override string DataScrPath
        {
            get
            {
                if ( this.OwnerDocument==null )
                    return string.Empty;

                return this.OwnerDocument.DataScrPath;
            }
        }

        #endregion

        #region Utility methods

        /// <summary>
        /// Check if the given document can be a child of this document.
        /// E.q. Emitter can be emitter set's child, but cannot be a child
        /// of an effect project document.
        /// </summary>
        /// <param name="doc">The child document.</param>
        /// <returns>True if the given document is a valid child document type.</returns>
        public override bool CanAddAsChildDoc( IDocument doc )
        {
            if ( doc is EmitterSetDocument )
                return true;

            return false;
        }

        #endregion

        #region Drag & drop

        /// <summary>
        /// Move the specified child document to the location
        /// before another child document.
        /// </summary>
        /// <param name="doc">The child document to move.</param>
        /// <param name="beforeDoc">
        /// The child document which "doc" will be moved before,
        /// null to move "doc" to the last child document.
        /// </param>
        /// <returns>The document after moved.</returns>
        public override IDocument MoveChildDocument( IDocument doc,
                                                     IDocument beforeDoc )
        {
            if ( doc is EmitterSetDocument )
            {
                EffectProjectDocument project = this.OwnerDocument as EffectProjectDocument;
                if ( project!=null )
                    return project.MoveChildDocument( doc, beforeDoc );
            }

            return null;
        }

        #endregion
    }
}
