﻿// ========================================================================
// <copyright file="CommonSettingsDocument.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using App.Command;
using App.IO;
using App.PropertyEdit;
using NW4F.DataModel;

namespace App.Data
{
    /// <summary>
    /// パーティクル・セット用ドキュメント
    /// </summary>
    public sealed class InitialSettingsDocument : BaseProjectPanelDocumet
    {
        #region Memeber Variables

        private readonly IProjectDocument       m_projectDoc     = null;    // parent/owner
        private readonly InitialSettingsData     m_commonData    = null;

        #endregion

        #region Properties

        /// <summary>
        /// 名前
        /// </summary>
        public override string Name
        {
            get
            {
                return res.Strings.INIT_SETTING_DEFAULT_NAME;
            }
            set
            {
            }
        }

        /// <summary>
        /// オーナードキュメント。
        /// </summary>
        public override IDocument OwnerDocument
        {
            get { return this.m_projectDoc; }
        }

        /// <summary>
        /// Emitter that this child belongs to
        /// </summary>
        public IProjectDocument Project
        {
            get { return this.m_projectDoc; }
        }

        /// <summary>
        /// データモデル：プレビュー設定
        /// </summary>
        public InitialSettingsData CommonSettingsData
        {
            get { return this.m_commonData; }
        }

        /// <summary>
        /// data source path without data model
        /// </summary>
        public override string RelativeDataScrPath
        {
            get
            {
                return "InitialSettingsData";
            }
        }

        /// <summary>
        /// path of the data source
        /// </summary>
        public override string DataScrPath
        {
            get
            {
                return this.Project.DataScrPath
                       + ".InitialSettingsDocument";
            }
        }

        #endregion

        #region Constructors

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public InitialSettingsDocument(IProjectDocument projectDoc)
            : base(res.Strings.INIT_SETTING_DEFAULT_NAME)
        {
            this.Name = res.Strings.INIT_SETTING_DEFAULT_NAME;
            this.m_projectDoc = projectDoc;
            this.m_commonData = new InitialSettingsData();

            DocumentManager.NotifyDocumentCreated( this );
        }


        #endregion

        #region オブジェクト

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override GuiObjectID ObjectID
        {
            get { return GuiObjectID.InitSettings; }
        }

        #endregion

        #region Event handlers

        /// <summary>
        /// Notify this document that it was removed from its parent.
        /// </summary>
        public override void NotifyRemovedFromParent()
        {
            base.NotifyRemovedFromParent();
        }

        #endregion
    }
}
