﻿// ========================================================================
// <copyright file="CommonSettingsDocument.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
//using App.Command;
using App.IO;
//using App.PropertyEdit;
using NWCore.DataModel;

namespace App.Data
{
    /// <summary>
    /// パーティクル・セット用ドキュメント
    /// </summary>
    public sealed class InitSettingsDocument : BaseProjectPanelDocument
    {
        #region Memeber Variables

        private readonly IProjectDocument       m_projectDoc     = null;    // parent/owner
        private readonly InitSettingsData     m_initSettingsData    = null;

        #endregion

        #region Properties

        /// <summary>
        /// 名前
        /// </summary>
        public override string Name
        {
            get
            {
                return res.Strings.INIT_SETTING_DEFAULT_NAME;
            }
            set
            {
            }
        }

        /// <summary>
        /// オーナードキュメント。
        /// </summary>
        public override IDocument OwnerDocument
        {
            get { return this.m_projectDoc; }
        }

        /// <summary>
        /// Emitter that this child belongs to
        /// </summary>
        public IProjectDocument Project
        {
            get { return this.m_projectDoc; }
        }

        /// <summary>
        /// データモデル：プレビュー設定
        /// </summary>
        public InitSettingsData InitSettingsData
        {
            get { return this.m_initSettingsData; }
        }

        /// <summary>
        /// data source path without data model
        /// </summary>
        public override string RelativeDataScrPath
        {
            get
            {
                return "InitSettingsData";
            }
        }

        /// <summary>
        /// path of the data source
        /// </summary>
        public override string DataScrPath
        {
            get
            {
                return this.Project.DataScrPath
                       + ".InitSettingsDocument";
            }
        }

        #endregion

        #region Constructors

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public InitSettingsDocument(IProjectDocument projectDoc)
            : base(res.Strings.INIT_SETTING_DEFAULT_NAME)
        {
            this.Name = res.Strings.INIT_SETTING_DEFAULT_NAME;
            this.m_projectDoc = projectDoc;
            this.m_initSettingsData = new InitSettingsData();

            // Set the frame rate from config
            InitSettingFrameRate framerate;
            if ( Enum.TryParse<InitSettingFrameRate>(Config.Data.Option.ViewerFrameRate,
                                                     out framerate)==true )
            {
                m_initSettingsData.FrameRate = framerate;
            }

            // Set the resolution from config
            InitSettingResolution resolution;
            if ( Enum.TryParse<InitSettingResolution>(Config.Data.Option.ViewerResolution,
                                                      out resolution)==true )
            {
                m_initSettingsData.Resolution = resolution;
            }

            m_initSettingsData.WorldScaleRange = Config.Data.Option.ViewerWorldScale;
            m_initSettingsData.WorldScaleTime  = Config.Data.Option.ViewerTimeScale;
            m_initSettingsData.GridScale       = Config.Data.Option.ViewerGridScale;

            DocumentManager.NotifyDocumentCreated( this );
        }


        #endregion

        #region オブジェクト

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override GuiObjectID ObjectID
        {
            get { return GuiObjectID.InitSettings; }
        }

        #endregion

        #region Event handlers

        /// <summary>
        /// Notify this document that it was removed from its parent.
        /// </summary>
        public override void NotifyRemovedFromParent()
        {
            base.NotifyRemovedFromParent();
        }

        #endregion
    }
}
