﻿// ========================================================================
// <copyright file="ReadOnlyList.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;

namespace App.Data
{
    /// <summary>
    /// 読み取り専用リストクラス。
    /// </summary>
    public class ReadOnlyList<TType> : ReadOnlyCollection<TType>
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ReadOnlyList(IList<TType> list)
            : base(list)
        {
        }

        /// <summary>
        /// 要素内容を配列に変換。
        /// </summary>
        public TType[] ToArray()
        {
            TType[] array = new TType[this.Count];
            for (int i = 0; i < array.Length; i++)
            {
                array[i] = this[i];
            }
            return array;
        }
    }
}
