﻿// ========================================================================
// <copyright file="ArrayUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;

namespace App.Data
{
    /// <summary>
    /// 配列ユーティリティクラス。
    /// </summary>
    public static class ArrayUtility
    {
        /// <summary>
        /// 追加。
        /// </summary>
        public static void Add<TType>(ref TType[] array, TType target)
        {
            if (array == null)
            {
                array = new TType[1];
                array[0] = target;
            }
            else
            {
                Array.Resize(ref array, array.Length + 1);
                array[array.Length - 1] = target;
            }
        }

        /// <summary>
        /// 挿入。
        /// </summary>
        public static void Insert<TType>(ref TType[] array, int index, TType target)
        {
            if ((array == null) || (array.Length == 0))
            {
                if (index == 0)
                {
                    Add(ref array, target);
                }
                else
                {
                    throw new ArgumentOutOfRangeException("index");
                }
            }
            else
            {
                if ((index >= 0) && (index < array.Length))
                {
                    Array.Resize(ref array, array.Length + 1);
                    for (int i = array.Length - 1; i > index; i--) { array[i] = array[i - 1]; }
                    array[index] = target;
                }
                else
                {
                    throw new ArgumentOutOfRangeException("index");
                }
            }
        }

        /// <summary>
        /// 削除。
        /// </summary>
        public static bool Remove<TType>(ref TType[] array, TType target)
        {
            if (array == null) { return false; }

            int index = Array.IndexOf(array, target);
            if (index == -1) { return false; }

            int newLength = array.Length - 1;
            for (int i = index; i < newLength; i++) { array[i] = array[i + 1]; }
            Array.Resize(ref array, newLength);
            return true;
        }
    }
}
