﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare
  File:     eft_StreamOutDeclaration.vsh

  Copyright (C)2011-2013 Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
*---------------------------------------------------------------------------*/

#ifdef _USE_NN_VFX

uint invocationIndex;

//------------------------------------------------------------------------------
// nn::vfx
//------------------------------------------------------------------------------
layout( local_size_x = 32, local_size_y = 1, local_size_z = 1 ) in;
layout( EFT_BINDING(0) std140 ) buffer sysPosBuff
{
    vec4 sysPos[ 1 ];
};
layout( EFT_BINDING(1) std140 ) buffer sysVecBuff
{
    vec4 sysVec[ 1 ];
};
layout( EFT_BINDING(2) std140 ) buffer sysPosDeltaBuff
{
    vec4 sysPosDelta[ 1 ];
};
layout( EFT_BINDING(3) std140 ) buffer sysScaleBuff
{
    vec4 sysScale[ 1 ];
};
layout( EFT_BINDING(4) std140 ) buffer sysRandomBuff
{
    vec4 sysRandomAttr[ 1 ];
};
layout( EFT_BINDING(5) std140 ) buffer sysEmtMat0Buff
{
    vec4 sysEmtMat0Attr[ 1 ];
};
layout( EFT_BINDING(6) std140 ) buffer sysEmtMat1Buff
{
    vec4 sysEmtMat1Attr[ 1 ];
};
layout( EFT_BINDING(7) std140 ) buffer sysEmtMat2Buff
{
    vec4 sysEmtMat2Attr[ 1 ];
};


/*
layout( std140 ) uniform VariationConstantsCs
{
    bool bitFlagWorldGrabityEnabled;
    bool bitFlagFieldRandom;
    bool bitFlagFieldRandomFe1;
    bool bitFlagFieldPosadd;
    bool bitFlagFieldMagnet;
    bool bitFlagFieldConvergence;
    bool bitFlagFieldSpin;
    bool bitFlagFieldCollision;
    bool bitFlagFieldCurlnoise;
    bool bitFlagEmitterFollowAll;
    bool bitFlagEmitterFollowPos;
    bool bitFlagEmitterFollowNone;
};*/

//-----------------------------
// 追従設定により決定された Emitter のRTマトリクス
//-----------------------------
vec4 sysEmitterRT[ 3 ];

// パーティクル
float sysPtclLife;
float sysPtclTime;
float sysPtclRandomX;
float sysPtclRandomY;
float sysPtclRandomZ;
float sysPtclRandomW;

#else

//------------------------------------------------------------------------------
// nw::eft2
//------------------------------------------------------------------------------
in  vec4    sysInPos;           // ストリームアウト入力 位置
in  vec4    sysInVec;           // ストリームアウト入力 速度

#endif

float sysPtclDynamicsRand;      // 運動量ランダム値

//---------------------------------------------------
// エミッタRTマトリクスを生成します。
// 生成されたマトリクスは、sysEmitterRT[3]に出力されます。
//---------------------------------------------------
void MakeEmitterRTMatrix_StreamOut()
{
#ifdef _USE_NW_EFT
    // eft2側
    if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_ALL ) )
    {
        sysEmitterRT[ 0 ] = sysEmitterRTMatrix[ 0 ];
        sysEmitterRT[ 1 ] = sysEmitterRTMatrix[ 1 ];
        sysEmitterRT[ 2 ] = sysEmitterRTMatrix[ 2 ];
    }

    if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_POS ) )
    {
        sysEmitterRT[ 0 ] = vec4( sysEmtRTMat0Attr.xyz, sysEmitterMatrix[ 0 ].w );
        sysEmitterRT[ 1 ] = vec4( sysEmtRTMat1Attr.xyz, sysEmitterMatrix[ 1 ].w );
        sysEmitterRT[ 2 ] = vec4( sysEmtRTMat2Attr.xyz, sysEmitterMatrix[ 2 ].w );
    }

    if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_NONE ) )
    {
        sysEmitterRT[ 0 ] = sysEmtRTMat0Attr;
        sysEmitterRT[ 1 ] = sysEmtRTMat1Attr;
        sysEmitterRT[ 2 ] = sysEmtRTMat2Attr;
    }

#else

    if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_ALL ) )
    {
        sysEmitterRT[ 0 ] = sysEmitterRTMatrix[ 0 ];
        sysEmitterRT[ 1 ] = sysEmitterRTMatrix[ 1 ];
        sysEmitterRT[ 2 ] = sysEmitterRTMatrix[ 2 ];
    }
    else
    {
        vec3 basisX = vec3( sysEmtMat0Attr[ invocationIndex ].x, sysEmtMat1Attr[ invocationIndex ].x, sysEmtMat2Attr[ invocationIndex ].x );
        vec3 basisY = vec3( sysEmtMat0Attr[ invocationIndex ].y, sysEmtMat1Attr[ invocationIndex ].y, sysEmtMat2Attr[ invocationIndex ].y );
        vec3 basisZ = vec3( sysEmtMat0Attr[ invocationIndex ].z, sysEmtMat1Attr[ invocationIndex ].z, sysEmtMat2Attr[ invocationIndex ].z );

        float emScaleX = length( basisX );
        float emScaleY = length( basisY );
        float emScaleZ = length( basisZ );

        if ( emScaleX > 0.0 )
        {
            float inv = 1.0 / emScaleX;
            sysEmitterRT[ 0 ].x = sysEmtMat0Attr[ invocationIndex ].x * inv;
            sysEmitterRT[ 1 ].x = sysEmtMat1Attr[ invocationIndex ].x * inv;
            sysEmitterRT[ 2 ].x = sysEmtMat2Attr[ invocationIndex ].x * inv;
        }
        else
        {
            sysEmitterRT[ 0 ].x = sysEmitterRT[ 1 ].x = sysEmitterRT[ 2 ].x = 0.0;
        }

        if ( emScaleY > 0.0 )
        {
            float inv = 1.0 / emScaleY;
            sysEmitterRT[ 0 ].y = sysEmtMat0Attr[ invocationIndex ].y * inv;
            sysEmitterRT[ 1 ].y = sysEmtMat1Attr[ invocationIndex ].y * inv;
            sysEmitterRT[ 2 ].y = sysEmtMat2Attr[ invocationIndex ].y * inv;
        }
        else
        {
            sysEmitterRT[ 0 ].y = sysEmitterRT[ 1 ].y = sysEmitterRT[ 2 ].y = 0.0;
        }

        if ( emScaleZ > 0.0 )
        {
            float inv = 1.0 / emScaleZ;
            sysEmitterRT[ 0 ].z = sysEmtMat0Attr[ invocationIndex ].z * inv;
            sysEmitterRT[ 1 ].z = sysEmtMat1Attr[ invocationIndex ].z * inv;
            sysEmitterRT[ 2 ].z = sysEmtMat2Attr[ invocationIndex ].z * inv;
        }
        else
        {
            sysEmitterRT[ 0 ].z = sysEmitterRT[ 1 ].z = sysEmitterRT[ 2 ].z = 0.0;
        }

        if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_POS ) )
        {
            sysEmitterRT[ 0 ].w = sysEmitterMatrix[ 0 ].w;
            sysEmitterRT[ 1 ].w = sysEmitterMatrix[ 1 ].w;
            sysEmitterRT[ 2 ].w = sysEmitterMatrix[ 2 ].w;
        }
        else
        {
            sysEmitterRT[ 0 ].w = sysEmtMat0Attr[ invocationIndex ].w;
            sysEmitterRT[ 1 ].w = sysEmtMat1Attr[ invocationIndex ].w;
            sysEmitterRT[ 2 ].w = sysEmtMat2Attr[ invocationIndex ].w;
        }
    }
#endif
}

//------------------------------------------------------------------------------
// 追従設定によるエミッタマトリクス反映
//------------------------------------------------------------------------------
vec3 ApplyEmitterMatrix_StreamOut( vec3 v )
{
    vec3 ret;
    vec4 temp = vec4( v, 1.0 );

    if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_ALL ) )
    {
        ret.x = dot( sysEmitterMatrix[ 0 ], temp );
        ret.y = dot( sysEmitterMatrix[ 1 ], temp );
        ret.z = dot( sysEmitterMatrix[ 2 ], temp );
    }

    if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_POS ) )
    {
#ifdef _USE_NN_VFX
        vec4 m0 = vec4( sysEmtMat0Attr[ invocationIndex ].xyz, sysEmitterMatrix[ 0 ].w );
        vec4 m1 = vec4( sysEmtMat1Attr[ invocationIndex ].xyz, sysEmitterMatrix[ 1 ].w );
        vec4 m2 = vec4( sysEmtMat2Attr[ invocationIndex ].xyz, sysEmitterMatrix[ 2 ].w );
#else
        vec4 m0 = vec4( sysEmtMat0Attr.xyz, sysEmitterMatrix[ 0 ].w );
        vec4 m1 = vec4( sysEmtMat1Attr.xyz, sysEmitterMatrix[ 1 ].w );
        vec4 m2 = vec4( sysEmtMat2Attr.xyz, sysEmitterMatrix[ 2 ].w );
#endif
        ret.x = dot( m0, temp );
        ret.y = dot( m1, temp );
        ret.z = dot( m2, temp );
    }

    if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_NONE ) )
    {
#ifdef _USE_NN_VFX
        ret.x = dot( sysEmtMat0Attr[ invocationIndex ], temp );
        ret.y = dot( sysEmtMat1Attr[ invocationIndex ], temp );
        ret.z = dot( sysEmtMat2Attr[ invocationIndex ], temp );
#else
        ret.x = dot( sysEmtMat0Attr, temp );
        ret.y = dot( sysEmtMat1Attr, temp );
        ret.z = dot( sysEmtMat2Attr, temp );
#endif
    }

    return ret;
}

//---------------------------------------------------
// 引数vにエミッタRTマトリクスの逆行列を適用します。
//---------------------------------------------------
vec3 ApplyEmitterRotateInvMatrix_StreamOut( vec3 v )
{
    // 回転行列なので、転置をとれば逆行列になる。
    vec4 ret;

    if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_ALL ) )
    {
        mat4    tempMat;
        tempMat[ 0 ] = vec4( sysEmitterMatrix[ 0 ].xyz, 0.0 );
        tempMat[ 1 ] = vec4( sysEmitterMatrix[ 1 ].xyz, 0.0 );
        tempMat[ 2 ] = vec4( sysEmitterMatrix[ 2 ].xyz, 0.0 );
        tempMat[ 3 ] = vec4( 0.0, 0.0, 0.0, 1.0 );
        ret = vec4( v, 1.0 ) * transpose( tempMat );
    }
    else
    {
        mat4    tempMat;
        tempMat[ 0 ] = vec4( sysEmitterRT[ 0 ].xyz, 0.0 );
        tempMat[ 1 ] = vec4( sysEmitterRT[ 1 ].xyz, 0.0 );
        tempMat[ 2 ] = vec4( sysEmitterRT[ 2 ].xyz, 0.0 );
        tempMat[ 3 ] = vec4( 0.0, 0.0, 0.0, 1.0 );
        ret = vec4( v, 1.0 ) * transpose( tempMat );
    }
    return ret.xyz;
}

//------------------------------------------------------------------------------
// StreamOut用、エミッタローカル位置を求めるユーティリティ関数
//------------------------------------------------------------------------------
vec3 GetEmitterLocalPosForSO()
{
    if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_NONE ) )
    {
        vec3 emitterPos;
        emitterPos.x = sysEmitterMatrix[ 0 ].w;
        emitterPos.y = sysEmitterMatrix[ 1 ].w;
        emitterPos.z = sysEmitterMatrix[ 2 ].w;

        mat4 tempMat;
#ifdef _USE_NN_VFX
        tempMat[ 0 ] = sysEmtMat0Attr[ invocationIndex ];
        tempMat[ 1 ] = sysEmtMat1Attr[ invocationIndex ];
        tempMat[ 2 ] = sysEmtMat2Attr[ invocationIndex ];
#else
        tempMat[ 0 ] = sysEmtMat0Attr;
        tempMat[ 1 ] = sysEmtMat1Attr;
        tempMat[ 2 ] = sysEmtMat2Attr;
#endif

        tempMat[ 3 ] = vec4( 0.0, 0.0, 0.0, 1.0 );
        return ( vec4( emitterPos, 1 ) * inverse( tempMat ) ).xyz;
    }
    return vec3( 0 );
}

//---------------------------------------------------
// ワールド位置に変換
// ※StreamOut シェーダでは _EMITTER_FOLLOW_TYPE_ALL などの #define がされていないため、
// ビットフラグで分岐を行っています。
// パフォーマンス上の問題がありますので、これ以外の場所では使用しないこと。
//---------------------------------------------------
vec3 TransformToWorldPos_StreamOut( vec3 pos )
{
    if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_ALL ) )
    {
        return ( vec4( pos, 1.0 ) * sysEmitterMatrix ).xyz;
    }
    else if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_POS ) )
    {
        mat4 tempMat;
#ifdef _USE_NN_VFX
        tempMat[ 0 ] = vec4( sysEmtMat0Attr[ invocationIndex ].xyz, sysEmitterMatrix[ 0 ].w );
        tempMat[ 1 ] = vec4( sysEmtMat1Attr[ invocationIndex ].xyz, sysEmitterMatrix[ 1 ].w );
        tempMat[ 2 ] = vec4( sysEmtMat2Attr[ invocationIndex ].xyz, sysEmitterMatrix[ 2 ].w );
        tempMat[ 3 ] = vec4( 0.0, 0.0, 0.0, 1.0 );
#else
        tempMat[ 0 ] = vec4( sysEmtMat0Attr.xyz, sysEmitterMatrix[ 0 ].w );
        tempMat[ 1 ] = vec4( sysEmtMat1Attr.xyz, sysEmitterMatrix[ 1 ].w );
        tempMat[ 2 ] = vec4( sysEmtMat2Attr.xyz, sysEmitterMatrix[ 2 ].w );
        tempMat[ 3 ] = vec4( 0.0, 0.0, 0.0, 1.0 );
#endif
        return ( vec4( pos, 1.0 ) * tempMat ).xyz;
    }
    else if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_NONE ) )
    {
        mat4 tempMat;
#ifdef _USE_NN_VFX
        tempMat[ 0 ] = sysEmtMat0Attr[ invocationIndex ];
        tempMat[ 1 ] = sysEmtMat1Attr[ invocationIndex ];
        tempMat[ 2 ] = sysEmtMat2Attr[ invocationIndex ];
#else
        tempMat[ 0 ] = sysEmtMat0Attr;
        tempMat[ 1 ] = sysEmtMat1Attr;
        tempMat[ 2 ] = sysEmtMat2Attr;
#endif
        tempMat[ 3 ] = vec4( 0.0, 0.0, 0.0, 1.0 );
        return ( vec4( pos, 1.0 ) * tempMat ).xyz;
    }
    return pos;
}

//---------------------------------------------------
// ワールド位置に変換（GPU+SOシェーダのみで使用すること）
// ※StreamOut シェーダでは _EMITTER_FOLLOW_TYPE_ALL などの #define がされていないため、
// ビットフラグで分岐を行っています。
// パフォーマンス上の問題がありますので、これ以外の場所では使用しないこと。
//---------------------------------------------------
vec3 TransformToLocalVec_StreamOut( vec3 vec )
{
    if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_ALL ) )
    {
        mat4 tempMat;
        tempMat[ 0 ] = vec4( sysEmitterMatrix[ 0 ].xyz, 0.0f );
        tempMat[ 1 ] = vec4( sysEmitterMatrix[ 1 ].xyz, 0.0f );
        tempMat[ 2 ] = vec4( sysEmitterMatrix[ 2 ].xyz, 0.0f );
        tempMat[ 3 ] = vec4( 0.0, 0.0, 0.0, 1.0 );
        return ( vec4( vec, 1.0 ) * inverse( tempMat ) ).xyz;
    }
    else if( CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_POS ) || CHECK_BIT_FLAG_1( BIT_FLAG_EMITTER_FOLLOW_NONE ) )
    {
        mat4 tempMat;
#ifdef _USE_NN_VFX
        tempMat[ 0 ] = vec4( sysEmtMat0Attr[ invocationIndex ].xyz, 0.0f );
        tempMat[ 1 ] = vec4( sysEmtMat1Attr[ invocationIndex ].xyz, 0.0f );
        tempMat[ 2 ] = vec4( sysEmtMat2Attr[ invocationIndex ].xyz, 0.0f );
#else
        tempMat[ 0 ] = vec4( sysEmtMat0Attr.xyz, 0.0f );
        tempMat[ 1 ] = vec4( sysEmtMat1Attr.xyz, 0.0f );
        tempMat[ 2 ] = vec4( sysEmtMat2Attr.xyz, 0.0f );
#endif
        tempMat[ 3 ] = vec4( 0.0, 0.0, 0.0, 1.0 );
        return ( vec4( vec, 1.0 ) * inverse( tempMat ) ).xyz;
    }
    return vec;
}

//------------------------------------------------------------------------------
// x時点での乱数の積算値を取得
//------------------------------------------------------------------------------
float RandFunc( float x )
{
    float _2pi = 3.141592 * 2.0;
    float rCycle = rnd0.w;

#if 1
    // ★配列実装版（波の個数が可変）
#define NUM_OF_WAVES 4
#define NUM_OF_RANDS 4

    // 振幅の固定幅
    float ampBase[ NUM_OF_WAVES ];
    if( rnd3.y == 1.0 )
    {
        ampBase[ 0 ] = rnd2.x;
        ampBase[ 1 ] = rnd2.y;
        ampBase[ 2 ] = rnd2.z;
        ampBase[ 3 ] = rnd2.w;
    }
    else
    {
        vec4 baseParam = vec4( 4.0, 3.0, 2.0, 1.5 );
        ampBase[ 0 ] = baseParam.x;
        ampBase[ 1 ] = baseParam.y;
        ampBase[ 2 ] = baseParam.z;
        ampBase[ 3 ] = baseParam.w;
    }

    // ★振幅のランダム幅
    float ampDelta[ NUM_OF_WAVES ];
    // ランダム幅は無しに。
    ampDelta[ 0 ] = 0;
    ampDelta[ 1 ] = 0;
    ampDelta[ 2 ] = 0;
    ampDelta[ 3 ] = 0;

    float amp[ NUM_OF_WAVES ];
    for( int i = 0; i<NUM_OF_WAVES; ++i )
    {
        amp[ i ] = ampBase[ i ];
    }

    // 周期
    float tRate[ NUM_OF_WAVES ];
    if( rnd3.y == 1 )
    {
        tRate[ 0 ] = rnd1.x;
        tRate[ 1 ] = rnd1.y;
        tRate[ 2 ] = rnd1.z;
        tRate[ 3 ] = rnd1.w;
    }
    else
    {
        vec4 baseRate = vec4( 0.6, 0.42, 0.23, 0.15 );
        tRate[ 0 ] = baseRate.x;
        tRate[ 1 ] = baseRate.y;
        tRate[ 2 ] = baseRate.z;
        tRate[ 3 ] = baseRate.w;
    }

    float cycle[ NUM_OF_WAVES ];
    for( int i = 0; i<NUM_OF_WAVES; ++i )
    {
        cycle[ i ] = tRate[ i ] * rCycle;
    }

    // 位相:
    float phase[ NUM_OF_WAVES ];
    for( int i = 0; i<NUM_OF_WAVES; ++i )
    {
        phase[ i ] = ( x / ( cycle[ i ] ) );
    }

    // 基本となる波形
    float baseWave[ NUM_OF_WAVES ];
    for( int i = 0; i<NUM_OF_WAVES; ++i )
    {
        baseWave[ i ] = sin( phase[ i ] * _2pi ) * amp[ i ];
    }

    float aggregate = 0;
    for( int i = 0; i<NUM_OF_WAVES; ++i )
    {
        aggregate += baseWave[ i ];
    }

    return aggregate;

#undef NUM_OF_WAVES
#undef NUM_OF_RANDS

#else
    // ★Vec4実装版（それほど速度は向上しない？）

    // 乱数
    vec4 val = vec4( sysPtclRandomX, sysPtclRandomY, sysPtclRandomZ, sysPtclRandomW );
    if( rnd3.x == 1.0 && rnd3.y == 1.0 ) { val = rnd4; }

    // 振幅
    vec4 ampBase = rnd2;
    if( rnd3.y == 0 ) { ampBase = vec4( 4.0, 3.0, 2.0, 1.5 ); }

    // 周期比率
    vec4 tRate = rnd1;
    if( rnd3.y == 0 ) { tRate = vec4( 0.6, 0.42, 0.23, 0.15 ); }

    // 周期
    vec4 cycle = rnd1 * rCycle;

    // 位相
    vec4 phase = vec4( x / cycle.x, x / cycle.y, x / cycle.z, x / cycle.w ) * _2pi;

    // 波形を合成
    vec4 baseWave;
    baseWave.x = sin( phase.x );
    baseWave.y = sin( phase.y );
    baseWave.z = sin( phase.z );
    baseWave.w = sin( phase.w );
    baseWave *= ampBase;

    return dot( vec4( 1.0 ), baseWave );
    //return dot( vec4(1.0), baseWave.x + baseWave.y + baseWave.z + baseWave.w );
#endif
}

//------------------------------------------------------------------------------
// x時点での乱数の積算値を取得
//------------------------------------------------------------------------------
float _GetRandSum( float x )
{
    return RandFunc( x );
}

//------------------------------------------------------------------------------
// [x1, x2]の区間の乱数の積算を取得
//------------------------------------------------------------------------------
float GetRandSum( float x1, float x2 )
{
    return _GetRandSum( x2 ) - _GetRandSum( x1 );
}

//------------------------------------------------------------------------------
// 現在の疑似乱数を取得
//------------------------------------------------------------------------------
float GetRand( float seed, float time, float deltaS, float deltaV )
{
    float x = seed + time;
    if( deltaS == 0 )
    {
        return ( _GetRandSum( x + deltaV + deltaS ) - _GetRandSum( x ) );
    }
    else
    {
        return ( _GetRandSum( x + deltaV + deltaS ) - _GetRandSum( x ) )
            - ( _GetRandSum( seed + deltaS ) - _GetRandSum( seed ) );
    }
}
