﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare
  File:     eft_ParticleDeclaration.glsl

  Copyright (C)2011-2013 Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#extension GL_ARB_texture_cube_map_array : enable

#define M_PI 3.14159265358979323846264  // 円周率

#define OPT_VARIABLE_NAME_OPTIMIZE      // 変数名最適化（バイナリサイズ切り詰め）

//------------------------------------------------------------------------------
// ビュー関連定数バッファ
//------------------------------------------------------------------------------
#ifdef OPT_VARIABLE_NAME_OPTIMIZE
// 名前の短縮形（バイナリサイズ削減）
#define viewMat     VWM
#define projMat     PJM
#define vpMat       VPM
#define bldMat      BLM
#define eyeVec      EVC
#define eyePos      EPS
#define viewParam   VWP
#endif

layout( std140, binding = UNIFORM_BLOCK_LAYOUT_VIEW ) uniform sysViewUniformBlock
{
        mat4                    viewMat;                        //!< view        マトリクス
        mat4                    projMat;                        //!< proj        マトリクス
        mat4                    vpMat;                          //!< view * proj マトリクス
        mat4                    bldMat;                         //!< ビルボードマトリクス
        vec4                    eyeVec;                         //!< 視線ベクトル
        vec4                    eyePos;                         //!< 視線位置
        vec4                    viewParam;                      //!< near / far / near * far / far - near /
        vec4                    viewParam2;                     //!< baseFovy / currentFovy / zOffset (Avoid Z-Fighting)
};

#define sysViewMatrix           viewMat                     // view matrix
#define sysProjectionMatrix     projMat                     // projection matrix
#define sysViewProjectionMatrix vpMat                       // view * projection matrix
#define sysEyeVector            eyeVec                      // eye vector
#define sysEyePosition          eyePos                      // eye position
#define sysScreenNear           viewParam.x                 // screen near
#define sysScreenFar            viewParam.y                 // screen far
#define sysScreenFarMultNearFar viewParam.z                 // screen near * far
#define sysScreenSubFarNear     viewParam.w                 // screen far  - near
#define sysProjctionMatrix      sysProjectionMatrix         // [ deprecated: Please use sysProjectionMatrix. ] projection matrix
#define sysViewProjctionMatrix  sysViewProjectionMatrix     // [ deprecated: Please use sysViewProjectionMatrix. ] view * projection matrix
#define sysBaseFovy             viewParam2.x                // base fovy
#define sysCurrentFovy          viewParam2.y                // current fovy
#define sysZOffsetForZFighting  viewParam2.z                // zOffset (Avoid Z-Fighting)

//------------------------------------------------------------------------------
// エミッタ静的情報定数バッファ
//------------------------------------------------------------------------------
#ifdef OPT_VARIABLE_NAME_OPTIMIZE
// 名前の短縮形（バイナリサイズ削減）
// この辺りの変数群は短縮が効果的（配列を持つため、出現頻度が高い。）
#define color0Anim A
#define color1Anim B
#define alpha0Anim C
#define alpha1Anim D
#define scaleAnim  E
#define shaderAnim F
#define texPatAnim0 G
#define texPatAnim1 H
#define texPatAnim2 I
#define texShiftAnim0 J
#define texShiftAnim1 K
#define texShiftAnim2 L
// 配列を持たない（二文字以上）
#define dummy0 D0
#define dummy1 D1
#define dummy2 D2
#define ubFlag FL
#define animKeyNum0 AK0
#define animKeyNum1 AK1
#define animLoopParam0 AL0
#define animLoopParam1 AL1
#define animLoopParam2 AL2
#define ubGrav UG
#define ubVec  UV
#define ubCenter UC
#define fluc   FC
#define shaderCoef SCO
#define ubCol0 UC0
#define alphaFunc0 AF0
#define alphaFunc1 AF1
#define alphaFunc2 AF2
#define addVecToScale VTS
#define ubRot0 UR0
#define ubRot1 UR1
#define ubRot2 UR2
#define ubRot3 UR3
#define ubCamScaleLimit CSL
#endif      // OPT_VARIABLE_NAME_OPTIMIZE


//------------------------------------------------
// vec2 8キーアニメーション 定数バッファ
//------------------------------------------------
struct Anim8KeyParam
{
    vec4                v[8];           //!< 値( x, y, z, time )
};

//------------------------------------------------
//  テクスチャ座標アニメーション
//------------------------------------------------
struct ResTexUvShiftAnim
{
    vec4                pm0;                //!< スクロール加算値/初期値
    vec4                pm1;                //!< スクロール初期値ランダム/スケール加算値
    vec4                pm2;                //!< スケール初期値/スケール初期値ランダム
    vec4                pm3;                //!< 回転 加算値/初期値ランダム/初期値ランダム
    vec4                pm4;                //!< 回転 加算値/初期値ランダム/初期値ランダム
};

//------------------------------------------------
//  テクスチャパタンアニメーション
//------------------------------------------------
struct ResTexPtnAnim
{
    vec4                pm;                 //!< テーブル数/周期
    ivec4               t[8];               //!< テーブル
};

//------------------------------------------------
//  揺らぎ
//------------------------------------------------
struct FluctuationData
{
    vec4 pm0;                               //!< 振幅X / 振幅Y / 周期X / 周期Y
    vec4 pm1;                               //!< 周期ランダムX / 周期ランダムY / 初期位相X / 初期位相Y
};


layout( std140, binding = UNIFORM_BLOCK_LAYOUT_EMITTER_STATIC ) uniform sysEmitterStaticUniformBlock
{
    vec4                dummy0;             // ダミー//
    vec4                dummy1;             // ダミー//
    vec4                dummy2;             // ダミー//
    vec4                dummy3;             // ダミー//
    vec4                dummy4;             // ダミー//
    ivec4               ubFlag;             // 各種フラグ
    ivec4               animKeyNum0;        // アニメーションキー数( color0 / alpha0 / color1 / alpha1 )
    ivec4               animKeyNum1;        // アニメーションキー数( scale /  /  /  )
    vec4                animLoopParam0;     // 8キーアニメーション：ループ( c0LoopRate    / a0LoopRate      / c1LoopRate   / a1LoopRate )
    vec4                animLoopParam1;     // 8キーアニメーション：ループ( scaleLoopRate / c0InitRandom    / a0InitRandom / c1InitRandom )
    vec4                animLoopParam2;     // 8キーアニメーション：ループ( a1InitRandom  / scaleInitRandom / / )
    vec4                ubGrav;             // 重力( x / y / z / scale )
    vec4                ubVec;              // 速度( airRegist /  /  /  )
    vec4                ubCenter;           // センター( x / y / offset / dummy )
    FluctuationData     fluc;               // 揺らぎ
    vec4                shaderCoef;         // シェーダ係数( 係数0 / 係数1 /  /  )
    ResTexPtnAnim       texPatAnim0;        // テクスチャパタンアニメーション0
    ResTexPtnAnim       texPatAnim1;        // テクスチャパタンアニメーション1
    ResTexPtnAnim       texPatAnim2;        // テクスチャパタンアニメーション2
    ResTexUvShiftAnim   texShiftAnim0;      // テクスチャ座標アニメーション0
    ResTexUvShiftAnim   texShiftAnim1;      // テクスチャ座標アニメーション1
    ResTexUvShiftAnim   texShiftAnim2;      // テクスチャ座標アニメーション2
    vec4                ubCol0;             // カラースケール( colorScale /  /  /  )
    Anim8KeyParam       color0Anim;         // カラーアニメーション
    Anim8KeyParam       alpha0Anim;         // アルファアニメーション
    Anim8KeyParam       color1Anim;         // カラーアニメーション
    Anim8KeyParam       alpha1Anim;         // アルファアニメーション
    vec4                alphaFunc0;         // アルファ機能0( softEdge0 / softEdge1 / fresnel0 / fresnel1 )
    vec4                alphaFunc1;         // アルファ機能1( nearDist0 / nearDist1 / farDist0 / farDist1 )
    vec4                alphaFunc2;         // アルファ機能1( decalDist0 / decalDist1 / alphaThreshold / empty )
    vec4                addVecToScale;      // 速度スケール加算( addParam / / / )
    Anim8KeyParam       scaleAnim;          // スケールアニメーション
    Anim8KeyParam       shaderAnim;         // シェーダアニメーション
    vec4                ubRot0;             // 初期回転( xyz /  )
    vec4                ubRot1;             // 初期ランダム回転( xyz /  )
    vec4                ubRot2;             // 回転速度( xyz / rotRegist )
    vec4                ubRot3;             // 回転ランダム速度( xyz /  )
    vec4                ubCamScaleLimit;    // カメラ前でのスケールを制限( Near / Far /  )
};




//------------------------------------------------------------------------------
// ビットフラグ
//------------------------------------------------------------------------------
// ビットフラグ チェック
#define CHECK_BIT_FLAG( bit )                   ( ( ubFlag.x & ( bit ) ) == ( bit ) )
#define CHECK_BIT_FLAG_1( bit )                 ( ( ubFlag.y & ( bit ) ) == ( bit ) )
#define GET_BIT_FLAG( bit )                     ( abs( sign( ubFlag.x & ( bit ) ) ) )
#define GET_BIT_FLAG_1( bit )                   ( abs( sign( ubFlag.y & ( bit ) ) ) )
#define GET_BIT_FLAG_2( bit )                   ( abs( sign( ubFlag.z & ( bit ) ) ) )
#define GET_BIT_FLAG_3( bit )                   ( abs( sign( ubFlag.w & ( bit ) ) ) )

#define GET_CUSTOM_FIELD_FLAG()                 ( ubFlag.w )
#define CHECK_CUSTOM_FIELD_FLAG( bit )          ( ( GET_CUSTOM_FIELD_FLAG() & ( bit ) ) == ( bit ) )

#define GET_FLAG_EQUAL( value, test )           ( 1 - abs( sign( ( value ) - ( test ) ) ) )
#define GET_FLAG_GREATER_EQ( value, test )      ( step( ( test ), ( value ) ) )
#define GET_FLAG_RANDOM_HALF( value )           ( sign( floor( ( value ) * 2 ) ) )

// 頂点シェーダビットフラグ[0]
#define BIT_FLAG_FLUCTUATION_TYPE_SIN           1
#define BIT_FLAG_FLUCTUATION_TYPE_SAW_TOOTH     2
#define BIT_FLAG_FLUCTUATION_TYPE_RECT          4
#define EFT_WORLD_GRAVITY_ENABLED               8
#define BIT_FLAG_TEX0_PTN_LIFE_FIT              16
#define BIT_FLAG_TEX0_PTN_LIFE_CLAMP            32
#define BIT_FLAG_TEX0_PTN_LIFE_LOOP             64
#define BIT_FLAG_TEX0_PTN_LIFE_RANDOM           128
#define BIT_FLAG_TEX1_PTN_LIFE_FIT              256
#define BIT_FLAG_TEX1_PTN_LIFE_CLAMP            512
#define BIT_FLAG_TEX1_PTN_LIFE_LOOP             1024
#define BIT_FLAG_TEX1_PTN_LIFE_RANDOM           2048
#define BIT_FLAG_TEX2_PTN_LIFE_FIT              4096
#define BIT_FLAG_TEX2_PTN_LIFE_CLAMP            8192
#define BIT_FLAG_TEX2_PTN_LIFE_LOOP             16384
#define BIT_FLAG_TEX2_PTN_LIFE_RANDOM           32768
#define BIT_FLAG_ROTATE_DIR_RANDOM_X            65536
#define BIT_FLAG_ROTATE_DIR_RANDOM_Y            131072
#define BIT_FLAG_ROTATE_DIR_RANDOM_Z            262144
#define BIT_FLAG_TEX0_INV_RANDOM_U              524288
#define BIT_FLAG_TEX0_INV_RANDOM_V              1048576
#define BIT_FLAG_TEX1_INV_RANDOM_U              2097152
#define BIT_FLAG_TEX1_INV_RANDOM_V              4194304
#define BIT_FLAG_TEX2_INV_RANDOM_U              8388608
#define BIT_FLAG_TEX2_INV_RANDOM_V              16777216
#define BIT_FLAG_TEX0_PTN_LOOP_RANDOM           33554432
#define BIT_FLAG_TEX1_PTN_LOOP_RANDOM           67108864
#define BIT_FLAG_TEX2_PTN_LOOP_RANDOM           134217728
#define BIT_FLAG_PRIMITIVE_SCALE_Y_TO_Z         268435456
#define BIT_FLAG_OFFSET_TYPE_DEPTH              536870912
#define BIT_FLAG_OFFSET_TYPE_CAMERA             1073741824

// 頂点シェーダビットフラグ[1]
#define BIT_FLAG_TEX_ANIM_FIXED_RANDOM          1
#define BIT_FLAG_FIELD_RANDOM                   2
#define BIT_FLAG_FIELD_POSADD                   4
#define BIT_FLAG_FIELD_MAGNET                   8
#define BIT_FLAG_FIELD_CONVERGENCE              16
#define BIT_FLAG_FIELD_SPIN                     32
#define BIT_FLAG_FIELD_COLLISION                64
#define BIT_FLAG_FIELD_CURLNOISE                128
#define BIT_FLAG_FIELD_RANDOM_FE1               256
#define BIT_FLAG_EMITTER_FOLLOW_ALL             512
#define BIT_FLAG_EMITTER_FOLLOW_POS             1024
#define BIT_FLAG_EMITTER_FOLLOW_NONE            2048




//------------------------------------------------------------------------------
// エミッタ動的情報定数バッファ
//------------------------------------------------------------------------------
#ifdef OPT_VARIABLE_NAME_OPTIMIZE
#define emitterColor0   EC0
#define emitterColor1   EC1
#define emitterParam0   EP0
#define emitterParam1   EP1
#define emitterMatrix   EMX
#define emitterMatrixRT EMR
#endif


layout( std140, binding = UNIFORM_BLOCK_LAYOUT_EMITTER_DYNAMIC ) uniform sysEmitterDynamicUniformBlock
{
    vec4                emitterColor0;      // エミッタカラー0
    vec4                emitterColor1;      // エミッタカラー1
    vec4                emitterParam0;      // エミッタパラメータ( time / emitterScaleX / emitterScaleY / )
    vec4                emitterParam1;      // エミッタパラメータ( fade alpha / emitterParticleScaleX / emitterParticleScaleY / )
    mat4                emitterMatrix;      // エミッタマトリクスSRT
    mat4                emitterMatrixRT;    // エミッタマトリクスRT
};


// エミッタ情報
#define sysEmitterTime          emitterParam0.x             // emitter time
#define sysEmitterParticleCount int( emitterParam0.y )      // emitter fade alpha
#define sysEmitterFadeAlpha     emitterParam1.x             // emitter fade alpha
#define sysEmitterColor0        emitterColor0               // emitter color0
#define sysEmitterColor1        emitterColor1               // emitter color1
#define sysEmitterMatrix        emitterMatrix               // emitter matrix SRT
#define sysEmitterRTMatrix      emitterMatrixRT             // emitter matrix RT
#define sysSavingFrameRate      emitterParam0.z             // saving frame rate
#if COMPUTE_SHADER
#define sysFrameRate            emitterParam0.z             // frame rate
#else
#define sysFrameRate            emitterParam0.w             // frame rate
#endif
#define sysEmitterParticleScaleX emitterParam1.y            // emitter particle scale x
#define sysEmitterParticleScaleY emitterParam1.z            // emitter particle scale y
#define sysEmitterParticleScaleZ emitterParam1.w            // emitter particle scale y
#define sysEmitterParticleScaleXYZ emitterParam1.yzw        // emitter particle scale xyz




//------------------------------------------------------------------------------
//  フィールド静的定数バッファ
//------------------------------------------------------------------------------
layout( std140, binding = UNIFORM_BLOCK_LAYOUT_EMITTER_FIELD ) uniform sysEmitterFieldUniformBlock
{
    // GPUノイズ
    vec4 rnd0;      //!< ランダム幅XYZ / ランダム適用間隔
    vec4 rnd1;      //!< ランダム周期比率（ 成分0 / 1 / 2 / 3 ）
    vec4 rnd2;      //!< 合成重み（固定）（ 成分0 / 1 / 2 / 3 ）
    vec4 rnd3;      //!< 位相の統一 / 詳細設定有効 /   / 空気抵抗の有無
    vec4 rnd4;      //!< 位相の変化速度 / 位相の分布 / z / w
    vec4 rnf0;      //!< ランダムフィールド ランダム幅XYZ / ランダム適用間隔
    vec4 pAdd;      //!< 位置に加算 加算値XYZ / ワールド座標系で処理するかどうか
    vec4 mgn0;      //!< 磁力 位置XYZ / 磁力
    vec4 mgn1;      //!< 磁力 エミッタ追従 / 対象座標軸XYZ / /
    vec4 cnv0;      //!< 収束 位置XYZ / 収束力
    vec4 cnv1;      //!< 収束 エミッタ追従 / / /
    vec4 spin;      //!< スピン 回転速度 / 拡散速度 / 軸 /
    vec4 coll;      //!< シンプルコリジョン タイプ / 反射率 / 摩擦 / 反射座標
    vec4 cur0;      //!< カールノイズ パワーXYZ / スケール
    vec4 cur1;      //!< カールノイズ スピードXYZ / オフセット
    vec4 cur2;      //!< カールノイズ ノイズのオフセットランダム / ワールド系で適用 /
    vec4 ctm0;      //!< カスタムフィールド パラメータ0
    vec4 ctm1;      //!< カスタムフィールド パラメータ1
};


//------------------------------------------------------------------------------
// テクスチャサンプラ
//------------------------------------------------------------------------------
#ifdef _TEX_0_SURFACE_ANIM
layout( binding = 0 ) uniform sampler2DArray sysTextureSampler0;    // 0枚目テクスチャアレイサンプラ―
#else
layout( binding = 0 ) uniform sampler2D      sysTextureSampler0;    // 0枚目テクスチャサンプラ―
#endif
#ifdef _TEX_1_SURFACE_ANIM
layout( binding = 1 ) uniform sampler2DArray sysTextureSampler1;    // 1枚目テクスチャアレイサンプラ―
#else
layout( binding = 1 ) uniform sampler2D      sysTextureSampler1;    // 1枚目テクスチャサンプラ―
#endif
#ifdef _TEX_2_SURFACE_ANIM
layout( binding = 2 ) uniform sampler2DArray sysTextureSampler2;    // 2枚目テクスチャアレイサンプラ―
#else
layout( binding = 2 ) uniform sampler2D      sysTextureSampler2;    // 2枚目テクスチャサンプラ―
#endif

layout( binding = 3 ) uniform sampler2D sysFrameBufferTexture;          // フレームバッファテクスチャサンプラ―
layout( binding = 4 ) uniform sampler2D sysDepthBufferTexture;          // デプスバッファテクスチャサンプラ―
#ifdef _TARGET_VK
// Index 5 is already used in UNIFORM_BLOCK_LAYOUT_VIEW.
layout( binding = 15 ) uniform sampler3D sysCurlNoiseTextureArray;       // カールノイズテクスチャアレイサンプラ―
#else
layout( binding = 5 ) uniform sampler3D sysCurlNoiseTextureArray;       // カールノイズテクスチャアレイサンプラ―
#endif



//------------------------------------------------------------------------------
// カスタムシェーダ向け 定数バッファ
//------------------------------------------------------------------------------

// カスタムシェーダ内が定数バッファを利用する場合の構造体宣言マクロ
//layout( std140, binding = SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_0 ) uniform sysCustomShaderUniformBlock0
//layout( std140, binding = SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_1 ) uniform sysCustomShaderUniformBlock1
//layout( std140, binding = SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_2 ) uniform sysCustomShaderUniformBlock2
//layout( std140, binding = SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_3 ) uniform sysCustomShaderUniformBlock3

//------------------------------------------------
// カスタムシェーダ用 定数バッファ
// EffectMaker側で設定されたパラメータを以下の定義で参照できます。
// RenderStateSetコールバック未記述時にランタイムからUBOが自動的に設定されます。
//------------------------------------------------
layout( binding = UNIFORM_BLOCK_LAYOUT_RESERVED_PARAM ) uniform sysCustomShaderReservedUniformBlockParam
{
    vec4    sysCustomShaderReservedUniformBlockParam0;
    vec4    sysCustomShaderReservedUniformBlockParam1;
    vec4    sysCustomShaderReservedUniformBlockParam2;
    vec4    sysCustomShaderReservedUniformBlockParam3;
    vec4    sysCustomShaderReservedUniformBlockParam4;
    vec4    sysCustomShaderReservedUniformBlockParam5;
    vec4    sysCustomShaderReservedUniformBlockParam6;
    vec4    sysCustomShaderReservedUniformBlockParam7;
    vec4    sysCustomShaderReservedUniformBlockParam8;
    vec4    sysCustomShaderReservedUniformBlockParam9;
    vec4    sysCustomShaderReservedUniformBlockParam10;
    vec4    sysCustomShaderReservedUniformBlockParam11;
    vec4    sysCustomShaderReservedUniformBlockParam12;
    vec4    sysCustomShaderReservedUniformBlockParam13;
    vec4    sysCustomShaderReservedUniformBlockParam14;
    vec4    sysCustomShaderReservedUniformBlockParam15;
};

//------------------------------------------------
// カスタムシェーダ定数バッファ
//------------------------------------------------
#define SYS_CUSTOM_SHADER_PARAM_0     sysCustomShaderReservedUniformBlockParam0.x
#define SYS_CUSTOM_SHADER_PARAM_1     sysCustomShaderReservedUniformBlockParam0.y
#define SYS_CUSTOM_SHADER_PARAM_2     sysCustomShaderReservedUniformBlockParam0.z
#define SYS_CUSTOM_SHADER_PARAM_3     sysCustomShaderReservedUniformBlockParam0.w
#define SYS_CUSTOM_SHADER_PARAM_4     sysCustomShaderReservedUniformBlockParam1.x
#define SYS_CUSTOM_SHADER_PARAM_5     sysCustomShaderReservedUniformBlockParam1.y
#define SYS_CUSTOM_SHADER_PARAM_6     sysCustomShaderReservedUniformBlockParam1.z
#define SYS_CUSTOM_SHADER_PARAM_7     sysCustomShaderReservedUniformBlockParam1.w
#define SYS_CUSTOM_SHADER_PARAM_8     sysCustomShaderReservedUniformBlockParam2.x
#define SYS_CUSTOM_SHADER_PARAM_9     sysCustomShaderReservedUniformBlockParam2.y
#define SYS_CUSTOM_SHADER_PARAM_10    sysCustomShaderReservedUniformBlockParam2.z
#define SYS_CUSTOM_SHADER_PARAM_11    sysCustomShaderReservedUniformBlockParam2.w
#define SYS_CUSTOM_SHADER_PARAM_12    sysCustomShaderReservedUniformBlockParam3.x
#define SYS_CUSTOM_SHADER_PARAM_13    sysCustomShaderReservedUniformBlockParam3.y
#define SYS_CUSTOM_SHADER_PARAM_14    sysCustomShaderReservedUniformBlockParam3.z
#define SYS_CUSTOM_SHADER_PARAM_15    sysCustomShaderReservedUniformBlockParam3.w
#define SYS_CUSTOM_SHADER_PARAM_16    sysCustomShaderReservedUniformBlockParam4.x
#define SYS_CUSTOM_SHADER_PARAM_17    sysCustomShaderReservedUniformBlockParam4.y
#define SYS_CUSTOM_SHADER_PARAM_18    sysCustomShaderReservedUniformBlockParam4.z
#define SYS_CUSTOM_SHADER_PARAM_19    sysCustomShaderReservedUniformBlockParam4.w
#define SYS_CUSTOM_SHADER_PARAM_20    sysCustomShaderReservedUniformBlockParam5.x
#define SYS_CUSTOM_SHADER_PARAM_21    sysCustomShaderReservedUniformBlockParam5.y
#define SYS_CUSTOM_SHADER_PARAM_22    sysCustomShaderReservedUniformBlockParam5.z
#define SYS_CUSTOM_SHADER_PARAM_23    sysCustomShaderReservedUniformBlockParam5.w
#define SYS_CUSTOM_SHADER_PARAM_24    sysCustomShaderReservedUniformBlockParam6.x
#define SYS_CUSTOM_SHADER_PARAM_25    sysCustomShaderReservedUniformBlockParam6.y
#define SYS_CUSTOM_SHADER_PARAM_26    sysCustomShaderReservedUniformBlockParam6.z
#define SYS_CUSTOM_SHADER_PARAM_27    sysCustomShaderReservedUniformBlockParam6.w
#define SYS_CUSTOM_SHADER_PARAM_28    sysCustomShaderReservedUniformBlockParam7.x
#define SYS_CUSTOM_SHADER_PARAM_29    sysCustomShaderReservedUniformBlockParam7.y
#define SYS_CUSTOM_SHADER_PARAM_30    sysCustomShaderReservedUniformBlockParam7.z
#define SYS_CUSTOM_SHADER_PARAM_31    sysCustomShaderReservedUniformBlockParam7.w







//------------------------------------------------------------------------------
// エミッタプラグイン用定数バッファ
//------------------------------------------------------------------------------
layout( binding = UNIFORM_BLOCK_LAYOUT_EMITTER_PLUGIN ) uniform sysEmitterPluginUniformBlock
{
    vec4    sysEmitterPluginUniformBlockParam0;
    vec4    sysEmitterPluginUniformBlockParam1;
    vec4    sysEmitterPluginUniformBlockParam2;
    vec4    sysEmitterPluginUniformBlockParam3;
    vec4    sysEmitterPluginUniformBlockParam4;
    vec4    sysEmitterPluginUniformBlockParam5;
    vec4    sysEmitterPluginUniformBlockParam6;
    vec4    sysEmitterPluginUniformBlockParam7;
    vec4    sysEmitterPluginUniformBlockParam8;
    vec4    sysEmitterPluginUniformBlockParam9;
    vec4    sysEmitterPluginUniformBlockParam10;
    vec4    sysEmitterPluginUniformBlockParam11;
    vec4    sysEmitterPluginUniformBlockParam12;
    vec4    sysEmitterPluginUniformBlockParam13;
    vec4    sysEmitterPluginUniformBlockParam14;
    vec4    sysEmitterPluginUniformBlockParam15;
};

#define SYS_EMITTER_PLUGIN_PARAM_0     sysEmitterPluginUniformBlockParam0.x
#define SYS_EMITTER_PLUGIN_PARAM_1     sysEmitterPluginUniformBlockParam0.y
#define SYS_EMITTER_PLUGIN_PARAM_2     sysEmitterPluginUniformBlockParam0.z
#define SYS_EMITTER_PLUGIN_PARAM_3     sysEmitterPluginUniformBlockParam0.w
#define SYS_EMITTER_PLUGIN_PARAM_4     sysEmitterPluginUniformBlockParam1.x
#define SYS_EMITTER_PLUGIN_PARAM_5     sysEmitterPluginUniformBlockParam1.y
#define SYS_EMITTER_PLUGIN_PARAM_6     sysEmitterPluginUniformBlockParam1.z
#define SYS_EMITTER_PLUGIN_PARAM_7     sysEmitterPluginUniformBlockParam1.w
#define SYS_EMITTER_PLUGIN_PARAM_8     sysEmitterPluginUniformBlockParam2.x
#define SYS_EMITTER_PLUGIN_PARAM_9     sysEmitterPluginUniformBlockParam2.y
#define SYS_EMITTER_PLUGIN_PARAM_10    sysEmitterPluginUniformBlockParam2.z
#define SYS_EMITTER_PLUGIN_PARAM_11    sysEmitterPluginUniformBlockParam2.w
#define SYS_EMITTER_PLUGIN_PARAM_12    sysEmitterPluginUniformBlockParam3.x
#define SYS_EMITTER_PLUGIN_PARAM_13    sysEmitterPluginUniformBlockParam3.y
#define SYS_EMITTER_PLUGIN_PARAM_14    sysEmitterPluginUniformBlockParam3.z
#define SYS_EMITTER_PLUGIN_PARAM_15    sysEmitterPluginUniformBlockParam3.w
#define SYS_EMITTER_PLUGIN_PARAM_16    sysEmitterPluginUniformBlockParam4.x
#define SYS_EMITTER_PLUGIN_PARAM_17    sysEmitterPluginUniformBlockParam4.y
#define SYS_EMITTER_PLUGIN_PARAM_18    sysEmitterPluginUniformBlockParam4.z
#define SYS_EMITTER_PLUGIN_PARAM_19    sysEmitterPluginUniformBlockParam4.w
#define SYS_EMITTER_PLUGIN_PARAM_20    sysEmitterPluginUniformBlockParam5.x
#define SYS_EMITTER_PLUGIN_PARAM_21    sysEmitterPluginUniformBlockParam5.y
#define SYS_EMITTER_PLUGIN_PARAM_22    sysEmitterPluginUniformBlockParam5.z
#define SYS_EMITTER_PLUGIN_PARAM_23    sysEmitterPluginUniformBlockParam5.w
#define SYS_EMITTER_PLUGIN_PARAM_24    sysEmitterPluginUniformBlockParam6.x
#define SYS_EMITTER_PLUGIN_PARAM_25    sysEmitterPluginUniformBlockParam6.y
#define SYS_EMITTER_PLUGIN_PARAM_26    sysEmitterPluginUniformBlockParam6.z
#define SYS_EMITTER_PLUGIN_PARAM_27    sysEmitterPluginUniformBlockParam6.w
#define SYS_EMITTER_PLUGIN_PARAM_28    sysEmitterPluginUniformBlockParam7.x
#define SYS_EMITTER_PLUGIN_PARAM_29    sysEmitterPluginUniformBlockParam7.y
#define SYS_EMITTER_PLUGIN_PARAM_30    sysEmitterPluginUniformBlockParam7.z
#define SYS_EMITTER_PLUGIN_PARAM_31    sysEmitterPluginUniformBlockParam7.w






//------------------------------------------------------------------------------
// カスタムテクスチャサンプラ
//------------------------------------------------------------------------------

// ユーザーが利用できるカスタムテクスチャサンプラID
#define SYS_CUSTOM_SHADER_TEXTURE_SAMPLER_ID_0     6             //!< カスタムシェーダ用 テクスチャサンプラID 0
#define SYS_CUSTOM_SHADER_TEXTURE_SAMPLER_ID_1     7             //!< カスタムシェーダ用 テクスチャサンプラID 1
#define SYS_CUSTOM_SHADER_TEXTURE_SAMPLER_ID_2     8             //!< カスタムシェーダ用 テクスチャサンプラID 2
#define SYS_CUSTOM_SHADER_TEXTURE_SAMPLER_ID_3     9             //!< カスタムシェーダ用 テクスチャサンプラID 3
#define SYS_CUSTOM_SHADER_TEXTURE_SAMPLER_ID_4    10             //!< カスタムシェーダ用 テクスチャサンプラID 4
#define SYS_CUSTOM_SHADER_TEXTURE_SAMPLER_ID_5    11             //!< カスタムシェーダ用 テクスチャサンプラID 5
#define SYS_CUSTOM_SHADER_TEXTURE_SAMPLER_ID_6    12             //!< カスタムシェーダ用 テクスチャサンプラID 6
#define SYS_CUSTOM_SHADER_TEXTURE_SAMPLER_ID_7    13             //!< カスタムシェーダ用 テクスチャサンプラID 7
#define SYS_CUSTOM_SHADER_TEXTURE_SAMPLER_ID_8    14             //!< カスタムシェーダ用 テクスチャサンプラID 8
#define SYS_CUSTOM_SHADER_TEXTURE_SAMPLER_ID_9    15             //!< カスタムシェーダ用 テクスチャサンプラID 9


#if 0
/* カスタムシェーダ内では、以下のサンプラが利用できます。*/
layout( binding = x ) uniform sampler2D sysCustomShaderTextureSampler0;               // カスタムテクスチャサンプラ0( nw::eft2::EFT_CUSTOM_TEXTURE_0 )
layout( binding = x ) uniform sampler2D sysCustomShaderTextureSampler1;               // カスタムテクスチャサンプラ1( nw::eft2::EFT_CUSTOM_TEXTURE_1 )
layout( binding = x ) uniform sampler2D sysCustomShaderTextureSampler2;               // カスタムテクスチャサンプラ2( nw::eft2::EFT_CUSTOM_TEXTURE_2 )
layout( binding = x ) uniform sampler2D sysCustomShaderTextureSampler3;               // カスタムテクスチャサンプラ3( nw::eft2::EFT_CUSTOM_TEXTURE_3 )
layout( binding = x ) uniform sampler2DArray sysCustomShaderTextureArraySampler0;     // カスタムテクスチャサンプラ0( 2DArray )
layout( binding = x ) uniform sampler2DArray sysCustomShaderTextureArraySampler1;     // カスタムテクスチャサンプラ1( 2DArray )
layout( binding = x ) uniform sampler2DArray sysCustomShaderTextureArraySampler2;     // カスタムテクスチャサンプラ2( 2DArray )
layout( binding = x ) uniform sampler2DArray sysCustomShaderTextureArraySampler3;     // カスタムテクスチャサンプラ3( 2DArray )
layout( binding = x ) uniform sampler3D sysCustomShaderTexture3DSampler0;             // カスタムテクスチャサンプラ0( nw::eft2::EFT_CUSTOM_TEXTURE_0 )
layout( binding = x ) uniform sampler3D sysCustomShaderTexture3DSampler1;             // カスタムテクスチャサンプラ1( nw::eft2::EFT_CUSTOM_TEXTURE_1 )
layout( binding = x ) uniform sampler3D sysCustomShaderTexture3DSampler2;             // カスタムテクスチャサンプラ2( nw::eft2::EFT_CUSTOM_TEXTURE_2 )
layout( binding = x ) uniform sampler3D sysCustomShaderTexture3DSampler3;             // カスタムテクスチャサンプラ3( nw::eft2::EFT_CUSTOM_TEXTURE_3 )
layout( binding = x ) uniform samplerCube sysCustomShaderCubeSampler0;                // カスタムテクスチャサンプラ0( Cube )
layout( binding = x ) uniform samplerCube sysCustomShaderCubeSampler1;                // カスタムテクスチャサンプラ1( Cube )
layout( binding = x ) uniform samplerCube sysCustomShaderCubeSampler2;                // カスタムテクスチャサンプラ2( Cube )
layout( binding = x ) uniform samplerCube sysCustomShaderCubeSampler3;                // カスタムテクスチャサンプラ3( Cube )
layout( binding = x ) uniform samplerCubeArray sysCustomShaderCubeArraySampler0;      // カスタムテクスチャサンプラ0( CubeArray )
layout( binding = x ) uniform samplerCubeArray sysCustomShaderCubeArraySampler1;      // カスタムテクスチャサンプラ1( CubeArray )
layout( binding = x ) uniform samplerCubeArray sysCustomShaderCubeArraySampler2;      // カスタムテクスチャサンプラ2( CubeArray )
layout( binding = x ) uniform samplerCubeArray sysCustomShaderCubeArraySampler3;      // カスタムテクスチャサンプラ3( CubeArray )
layout( binding = x ) uniform sampler2DShadow sysCustomShaderShadowSampler0;          // カスタムテクスチャサンプラ0( Shadow )
layout( binding = x ) uniform sampler2DShadow sysCustomShaderShadowSampler1;          // カスタムテクスチャサンプラ1( Shadow )
layout( binding = x ) uniform sampler2DShadow sysCustomShaderShadowSampler2;          // カスタムテクスチャサンプラ2( Shadow )
layout( binding = x ) uniform sampler2DShadow sysCustomShaderShadowSampler3;          // カスタムテクスチャサンプラ3( Shadow )
layout( binding = x ) uniform sampler2DArrayShadow sysCustomShaderShadowArraySampler0;// カスタムテクスチャサンプラ0( ShadowArray )
layout( binding = x ) uniform sampler2DArrayShadow sysCustomShaderShadowArraySampler1;// カスタムテクスチャサンプラ1( ShadowArray )
layout( binding = x ) uniform sampler2DArrayShadow sysCustomShaderShadowArraySampler2;// カスタムテクスチャサンプラ2( ShadowArray )
layout( binding = x ) uniform sampler2DArrayShadow sysCustomShaderShadowArraySampler3;// カスタムテクスチャサンプラ3( ShadowArray )
#endif



//---------------------------------------------------
// フレネル係数を計算する
//---------------------------------------------------
float CalcFresnelRate( vec3 eyeVec, vec3 worldNormal )
{
    #define fresnelAlphaMin         alphaFunc0.z   // フレネル最小値
    #define fresnelAlphaMax         alphaFunc0.w   // フレネル最小値

    vec3  worldDir = normalize( eyeVec );
    float rotDiff  = abs( dot( worldNormal, worldDir.xyz ) );
    float fresnel = smoothstep( fresnelAlphaMin, fresnelAlphaMax, rotDiff );
    return fresnel;
}



//------------------------------------------------
// 互換性保持
//------------------------------------------------
#define UNIFORM_BLOCK_LAYOUT_CUSTOM_SHADER_ID_0   SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_0
#define UNIFORM_BLOCK_LAYOUT_CUSTOM_SHADER_ID_1   SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_1
#define UNIFORM_BLOCK_LAYOUT_CUSTOM_SHADER_ID_2   SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_2
#define UNIFORM_BLOCK_LAYOUT_CUSTOM_SHADER_ID_3   SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_3

#define nearZ               sysScreenNear
#define farZ                sysScreenFar
#define multNearFarZ        sysScreenFarMultNearFar
#define subFarNearZ         sysScreenSubFarNear

#define TexUvShiftAnimUbo   ResTexUvShiftAnim
#define TexPtnAnimUbo       ResTexPtnAnim
