﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare
  File:     eft_ParticleDeclaration.fsh

  Copyright (C)2011-2012 Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

//------------------------------------------------------------------------------
// 定義
//------------------------------------------------------------------------------
// ピクセルシェーダであることの定義
#define FRAGMENT_SHADER

//------------------------------------------------------------------------------
// 入力
//------------------------------------------------------------------------------
#ifdef _USE_NN_VFX
EFT_LOCATION_LAYOUT(0) in vec4     sysColor0Vary;                              // カラー0
EFT_LOCATION_LAYOUT(1) in vec4     sysColor1Vary;                              // カラー1
EFT_LOCATION_LAYOUT(2) in vec4     sysTexCoord01Vary;                          // テクスチャ座標0-1
EFT_LOCATION_LAYOUT(3) in vec2     sysTexCoord2Vary;                           // テクスチャ座標2
EFT_LOCATION_LAYOUT(4) in vec4     sysFragCoordVary;                           // スクリーン座標参照用
EFT_LOCATION_LAYOUT(5) in vec4     sysFragParamVary;                           // 各種パラメータ( MasterAlpha, LifeRatio, CombinerAnime0.x, empty )
EFT_LOCATION_LAYOUT(6) in vec4     sysFragParamVary2;                          // 各種パラメータ( LifeRatio2, CombinerAnime0.y, CombinerAnime0.z, empty )
EFT_LOCATION_LAYOUT(7) in vec4     sysPrimitiveColorVary;                      // プリミティブカラー
EFT_LOCATION_LAYOUT(8) in vec3     sysWorldPositionVary;                       // ワールド座標
EFT_LOCATION_LAYOUT(9) in vec3     sysWorldNormalVary;                         // ワールド法線
EFT_LOCATION_LAYOUT(10) in vec3     sysWorldTangentVary;                        // ワールド接線
EFT_LOCATION_LAYOUT(11) in vec3     sysWorldBinormalVary;                       // ワールド従法線
EFT_LOCATION_LAYOUT(12) in vec3     sysEyeVecVary;                              // 視線ベクトル
EFT_LOCATION_LAYOUT(13) in vec4     sysFragRandomVary;                          // 粒の持つ乱数値
#else
in vec4     sysColor0Vary;                              // カラー0
in vec4     sysColor1Vary;                              // カラー1
in vec4     sysTexCoord01Vary;                          // テクスチャ座標0-1
in vec2     sysTexCoord2Vary;                           // テクスチャ座標2
in vec4     sysFragCoordVary;                           // スクリーン座標参照用
in vec4     sysFragParamVary;                           // 各種パラメータ( MasterAlpha, CombinerAnime0.x, empty, empty )
in vec4     sysFragParamVary2;                          // 各種パラメータ( LifeRatio2, CombinerAnime0.y, CombinerAnime0.z, empty )
in vec4     sysPrimitiveColorVary;                      // プリミティブカラー
in vec3     sysWorldPositionVary;                       // ワールド座標
in vec3     sysWorldNormalVary;                         // ワールド法線
in vec3     sysWorldTangentVary;                        // ワールド接線
in vec3     sysWorldBinormalVary;                       // ワールド従法線
in vec3     sysEyeVecVary;                              // 視線ベクトル
in vec4     sysFragRandomVary;                          // 粒の持つ乱数値
#endif

#define     sysInColor0         sysColor0Vary           // カラー0
#define     sysInColor1         sysColor1Vary           // カラー1
#define     sysInTexCoord0      sysTexCoord01Vary.xy    // UV0
#define     sysInTexCoord1      sysTexCoord01Vary.zw    // UV1
#define     sysInTexCoord2      sysTexCoord2Vary        // UV2
#define     sysMasterAlpha      sysFragParamVary.x      // マスターアルファ
#define     sysShaderAnim       sysFragParamVary.y      // シェーダアニメーションX
#define     sysShaderAnimY      sysFragParamVary2.y     // シェーダアニメーションY
#define     sysShaderAnimZ      sysFragParamVary2.z     // シェーダアニメーションZ
#define     sysLifeRatio        sysFragParamVary2.x     // 現在の寿命の割合(0.0-1.0)
#define     sysParticleRandom   sysFragRandomVary;      // 粒の持つ乱数値

//------------------------------------------------------------------------------
// カラー出力先
// システムは最終カラーをここに書き込みます。
// 書き込み先を変えたい場合は、カスタムピクセルシェーダーにて、
// OUTPUT_COLOR を #undef し再定義して下さい。
//------------------------------------------------------------------------------
#ifdef _REVERT_SDK_3_1_0_FIX
#define OUTPUT_COLOR gl_FragData[0]
#else
layout(location = 0) out vec4 sysOutputColor0;
#define OUTPUT_COLOR sysOutputColor0
#endif

//------------------------------------------------------------------------------
// 使用するミップマップテクスチャの打ち切りレベル
// 打ち切りレベルを変えたい場合は、カスタムピクセルシェーダーにて、
// MIPMAPLEVEL_LIMIT を #undef し再定義して下さい。
//------------------------------------------------------------------------------
#define MIPMAPLEVEL_LIMIT 2

//------------------------------------------------------------------------------
// 互換性保持
//------------------------------------------------------------------------------

// 頂点シェーダ から送られてくる値
#define v_outColor0             sysColor0Vary
#define v_outColor1             sysColor1Vary
#define v_outTexCoord           sysTexCoord01Vary
#define v_outTexCoord2          sysTexCoord2Vary
#define v_outPrimitiveColor     sysPrimitiveColorVary
#define v_outWorldPosition      sysWorldPositionVary
#define v_outWorldNormal        sysWorldNormalVary
#define v_outWorldTangent       sysWorldTangentVary
#define v_outWorldBinormal      sysWorldBinormalVary
#define v_outEyeVec             sysEyeVecVary
#define v_outTexCoord0X         v_outTexCoord.x
#define v_outTexCoord0Y         v_outTexCoord.y
#define v_outTexCoord1X         v_outTexCoord.z
#define v_outTexCoord1Y         v_outTexCoord.w

//#define v_outTexSurfaceAnim
//#define v_outDepthTexCoordProj
//#define v_outFrameTexCoordProj
//#define v_outSphereTexCoord
//#define v_outProjectionTexSRT0CoordProj
//#define v_outProjectionTexSRT1CoordProj
//#define v_outPos

#define s_firstTexture          sysTextureSampler0
#define s_secondTexture         sysTextureSampler1
#define s_frameBufferTexture    sysFrameBufferTexture
#define frameBufferTexture      sysFrameBufferTexture
#define s_depthBufferTexture    sysDepthBufferTexture
#define v_outFrameTexCoordProj  sysFragCoordVary
#define textureSampler0         sysTextureSampler0
#define textureSampler1         sysTextureSampler1
#define textureSampler2         sysTextureSampler2

#ifdef CUSTOM_SHADER_NONE
#define USR_FRAGMENT_SETTING_NONE
#endif
#ifdef CUSTOM_SHADER_INDEX_1
#define USR_FRAGMENT_SETTING_1
#endif
#ifdef CUSTOM_SHADER_INDEX_2
#define USR_FRAGMENT_SETTING_2
#endif
#ifdef CUSTOM_SHADER_INDEX_3
#define USR_FRAGMENT_SETTING_3
#endif
#ifdef CUSTOM_SHADER_INDEX_4
#define USR_FRAGMENT_SETTING_4
#endif
#ifdef CUSTOM_SHADER_INDEX_5
#define USR_FRAGMENT_SETTING_5
#endif
#ifdef CUSTOM_SHADER_INDEX_6
#define USR_FRAGMENT_SETTING_6
#endif
#ifdef CUSTOM_SHADER_INDEX_7
#define USR_FRAGMENT_SETTING_7
#endif
#ifdef CUSTOM_SHADER_INDEX_8
#define USR_FRAGMENT_SETTING_8
#endif
#ifdef CUSTOM_SHADER_FLAG_0
#define USR_FRAGMENT_FLAG_0
#endif
#ifdef CUSTOM_SHADER_FLAG_1
#define USR_FRAGMENT_FLAG_1
#endif
#ifdef CUSTOM_SHADER_FLAG_2
#define USR_FRAGMENT_FLAG_2
#endif
#ifdef CUSTOM_SHADER_FLAG_3
#define USR_FRAGMENT_FLAG_3
#endif
#ifdef CUSTOM_SHADER_FLAG_4
#define USR_FRAGMENT_FLAG_4
#endif
#ifdef CUSTOM_SHADER_FLAG_5
#define USR_FRAGMENT_FLAG_5
#endif
#ifdef CUSTOM_SHADER_FLAG_6
#define USR_FRAGMENT_FLAG_6
#endif
#ifdef CUSTOM_SHADER_FLAG_7
#define USR_FRAGMENT_FLAG_7
#endif
#ifdef CUSTOM_SHADER_FLAG_8
#define USR_FRAGMENT_FLAG_8
#endif
#ifdef CUSTOM_SHADER_FLAG_9
#define USR_FRAGMENT_FLAG_9
#endif
#ifdef CUSTOM_SHADER_FLAG_10
#define USR_FRAGMENT_FLAG_10
#endif
#ifdef CUSTOM_SHADER_FLAG_11
#define USR_FRAGMENT_FLAG_11
#endif
#ifdef CUSTOM_SHADER_FLAG_12
#define USR_FRAGMENT_FLAG_12
#endif
#ifdef CUSTOM_SHADER_FLAG_13
#define USR_FRAGMENT_FLAG_13
#endif
#ifdef CUSTOM_SHADER_FLAG_14
#define USR_FRAGMENT_FLAG_14
#endif
#ifdef CUSTOM_SHADER_FLAG_15
#define USR_FRAGMENT_FLAG_15
#endif
#ifdef CUSTOM_SHADER_FLAG_16
#define USR_FRAGMENT_FLAG_16
#endif
#ifdef CUSTOM_SHADER_FLAG_17
#define USR_FRAGMENT_FLAG_17
#endif
#ifdef CUSTOM_SHADER_FLAG_18
#define USR_FRAGMENT_FLAG_18
#endif
#ifdef CUSTOM_SHADER_FLAG_19
#define USR_FRAGMENT_FLAG_19
#endif
#ifdef CUSTOM_SHADER_FLAG_20
#define USR_FRAGMENT_FLAG_20
#endif
#ifdef CUSTOM_SHADER_FLAG_21
#define USR_FRAGMENT_FLAG_21
#endif
#ifdef CUSTOM_SHADER_FLAG_22
#define USR_FRAGMENT_FLAG_22
#endif
#ifdef CUSTOM_SHADER_FLAG_23
#define USR_FRAGMENT_FLAG_23
#endif
#ifdef CUSTOM_SHADER_FLAG_24
#define USR_FRAGMENT_FLAG_24
#endif
#ifdef CUSTOM_SHADER_FLAG_25
#define USR_FRAGMENT_FLAG_25
#endif
#ifdef CUSTOM_SHADER_FLAG_26
#define USR_FRAGMENT_FLAG_26
#endif
#ifdef CUSTOM_SHADER_FLAG_27
#define USR_FRAGMENT_FLAG_27
#endif
#ifdef CUSTOM_SHADER_FLAG_28
#define USR_FRAGMENT_FLAG_28
#endif
#ifdef CUSTOM_SHADER_FLAG_29
#define USR_FRAGMENT_FLAG_29
#endif
#ifdef CUSTOM_SHADER_FLAG_30
#define USR_FRAGMENT_FLAG_30
#endif
#ifdef CUSTOM_SHADER_FLAG_31
#define USR_FRAGMENT_FLAG_31
#endif
