﻿/*---------------------------------------------------------------------------*
 Copyright (C) 2013 Nintendo Co., Ltd.  All rights reserved.

 These coded instructions, statements, and computer programs contain
 proprietary information of Nintendo of America Inc. and/or Nintendo
 Company Ltd., and are protected by Federal copyright law.  They may
 not be disclosed to third parties or copied or duplicated in any form,
 in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/




//------------------------------------------------------------------------------
// テクスチャ0 カラーを取得する( カスタマイズ可能 )
//------------------------------------------------------------------------------
#ifndef USE_USR_GET_TEXTURE_COLOR
vec4 GetTexture0Color( vec2 texCoord )
{
    vec4 color = texture2D( sysTextureSampler0, texCoord );

#ifdef _TEX0_ALPHA_INPUT_ONE
    color.a = 1.0;
#endif
#ifdef _TEX0_ALPHA_INPUT_RED
    color.a = color.r;
#endif
#ifdef _TEX0_COLOR_INPUT_ONE
    color.rgb = vec3( 1 );
#endif

    return color;
}
#endif




//------------------------------------------------------------------------------
// テクスチャ1 カラーを取得する( カスタマイズ可能 )
//------------------------------------------------------------------------------
#ifndef USE_USR_GET_TEXTURE1_COLOR
vec4 GetTexture1Color( vec2 texCoord )
{
    vec4 color = texture2D( sysTextureSampler1, texCoord );

#ifdef _TEX1_ALPHA_INPUT_RED
    color.a = color.r;
#endif
#ifdef _TEX1_COLOR_INPUT_ONE
    color.rgb = vec3( 1 );
#endif
#ifdef _TEX1_ALPHA_INPUT_ONE
    color.a = 1.0;
#endif

    return color;
}
#endif





//------------------------------------------------------------------------------
// テクスチャ2 カラーを取得する( カスタマイズ可能 )
//------------------------------------------------------------------------------
#ifndef USE_USR_GET_TEXTURE2_COLOR
vec4 GetTexture2Color( vec2 texCoord )
{
    vec4 color = texture2D( sysTextureSampler2, texCoord );

#ifdef _TEX2_ALPHA_INPUT_ONE
    color.a = 1.0;
#endif
#ifdef _TEX2_ALPHA_INPUT_RED
    color.a = color.r;
#endif
#ifdef _TEX2_COLOR_INPUT_ONE
    color.rgb = vec3( 1 );
#endif

    return color;
}
#endif




//---------------------------------------------------
// プリミティブ頂点カラーを取得する( カスタマイズ可能 )
//---------------------------------------------------
#ifdef _PRIMITIVE
vec3 GetPrimitiveColor()
{
#ifdef _PRIMITIVE_COLOR_INPUT_SRC
    return sysPrimitiveColorVary.xyz;
#endif
#ifdef _PRIMITIVE_COLOR_INPUT_ONE
    return vec3( 1.0, 1.0, 1.0 );
#endif
}
#endif



//---------------------------------------------------
// プリミティブ頂点アルファを取得する( カスタマイズ可能 )
//---------------------------------------------------
#ifdef _PRIMITIVE
float GetPrimitiveAlpha()
{
#ifdef _PRIMITIVE_ALPHA_INPUT_A
    return sysPrimitiveColorVary.w;
#endif
#ifdef _PRIMITIVE_ALPHA_INPUT_RED
    return sysPrimitiveColorVary.x;
#endif
#ifdef _PRIMITIVE_ALPHA_INPUT_ONE
    return 1.0;
#endif
}
#endif



//---------------------------------------------------
// プリミティブカラーをブレンドする( カスタマイズ可能 )
//---------------------------------------------------
#ifdef _PRIMITIVE
vec3 BlendPrimitiveColor( vec3 outputColor, vec3 primitiveColor )
{
    vec3 retColor;
#ifdef _PRIMITIVE_COLOR_BLEND_MOD
    retColor   = outputColor * primitiveColor;
#endif
#ifdef _PRIMITIVE_COLOR_BLEND_ADD
    retColor   = outputColor + primitiveColor;
#endif
#ifdef _PRIMITIVE_COLOR_BLEND_SUB
    retColor   = outputColor - primitiveColor;
#endif
    return retColor;
}
#endif



//---------------------------------------------------
// プリミティブアルファをブレンドする( カスタマイズ可能 )
//---------------------------------------------------
vec4 BlendPrimitiveAlpha( vec4 texture, float primitiveAlpha )
{
    float retAlpha = texture.a;
#ifdef _PRIMITIVE_ALPHA_BLEND_MOD
    retAlpha   = retAlpha * primitiveAlpha;
#endif
#ifdef _PRIMITIVE_ALPHA_BLEND_ADD
    retAlpha   = retAlpha + primitiveAlpha;
#endif
#ifdef _PRIMITIVE_ALPHA_BLEND_SUB
    retAlpha   = retAlpha - primitiveAlpha;
#endif
    texture.a = retAlpha;
    return texture;
}




//---------------------------------------------------
// フレームバッファテクスチャカラーを取得する( カスタマイズ可能 )
//---------------------------------------------------
vec4 GetFrameBufferTextureColor( vec4 projection )
{
    return texture2DProj( sysFrameBufferTexture, projection );
}





//---------------------------------------------------
// デプス値を取得する( カスタマイズ可能 )
//---------------------------------------------------
#ifndef USE_USR_GET_DEPTH_VALUE
float GetDepthValue( vec4 position )
{
    float depth = position.z / position.w;
    depth = - ( sysScreenFarMultNearFar ) / ( depth * ( sysScreenSubFarNear ) - sysScreenFar );
    return depth;
}
#endif




//---------------------------------------------------
// デプステクスチャからデプス値を取得する( カスタマイズ可能 )
//---------------------------------------------------
#ifndef USE_USR_GET_DEPTH_VALUE_FROM_TEXTURE
float GetDepthValueFromTexture( vec4 projection )
{
    float depth = texture2DProj( sysDepthBufferTexture, projection ).r;
    depth = - ( sysScreenFarMultNearFar ) / ( depth * ( sysScreenSubFarNear ) - sysScreenFar );
    return depth;
}
#endif




//---------------------------------------------
// 最終出力カラー調整
//---------------------------------------------
#ifndef USE_USR_FINAL_ADJUSTMENT_FRAGMENT_COLOR
void FinalAdjustmentFragmentColor(){}
#endif




//------------------------------------------------------------------------------
// カラー計算式処理を行う
//------------------------------------------------------------------------------
vec3 GetFragmentColor( vec3 texture, vec3 vcolor0, vec3 vcolor1 )
{
#ifdef _COLOR_PROCESS_COLOR
    return vcolor0;
#endif
#ifdef _COLOR_PROCESS_TEXTURE
    return texture * vcolor0;
#endif
#ifdef _COLOR_PROCESS_TEXTURE_INTERPOLATE
    return mix( vcolor1, vcolor0, texture );
#endif
#ifdef _COLOR_PROCESS_TEXTURE_ADD
    return texture * vcolor0 + vcolor1;
#endif
}




//------------------------------------------------------------------------------
// アルファ計算式処理を行う
//------------------------------------------------------------------------------
float GetFragmentAlpha( float texture, float alpha0, float alpha1 )
{
#ifdef _ALPHA_PROCESS_MOD
    return texture * alpha0;
#endif
#ifdef _ALPHA_PROCESS_SUB
    return ( texture - ( 1.0 - alpha0 ) ) * 2.0;
#endif
#ifdef _ALPHA_PROCESS_MOD_A0_A1
    return texture * alpha0 * alpha1;
#endif
#ifdef _ALPHA_PROCESS_SUB_A0_MOD_A1
    return ( texture - alpha0 ) * alpha1;
#endif
#ifdef _ALPHA_PROCESS_DIST_FILED
    float ret = ( texture - alpha0 ) * 4.0;
    return clamp( ret, 0.0, 1.0 ) * alpha1;
#endif
}




//------------------------------------------------------------------------------
// テクスチャ1をブレンドする( カスタマイズ可能 )
//------------------------------------------------------------------------------
#ifndef USE_USR_BLEND_TEXTURE1_COLOR
vec4 BlendTexture1Color( vec4 texture0, vec4 texture1 )
{
    vec4 ret;

#ifdef _TEXTURE1_COLOR_BLEND_MOD
    ret.rgb = texture0.rgb * texture1.rgb;
#endif
#ifdef _TEXTURE1_COLOR_BLEND_ADD
    ret.rgb = texture0.rgb + texture1.rgb;
#endif
#ifdef _TEXTURE1_COLOR_BLEND_SUB
    ret.rgb = texture0.rgb - texture1.rgb;
#endif

#ifdef _TEXTURE1_ALPHA_BLEND_MOD
    ret.a   = texture0.a * texture1.a;
#endif
#ifdef _TEXTURE1_ALPHA_BLEND_ADD
    ret.a   = texture0.a + texture1.a;
#endif
#ifdef _TEXTURE1_ALPHA_BLEND_SUB
    ret.a   = texture0.a - texture1.a;
#endif
    return ret;
}
#endif




//------------------------------------------------------------------------------
// テクスチャ2をブレンドする( カスタマイズ可能 )
//------------------------------------------------------------------------------
#ifndef USE_USR_BLEND_TEXTURE2_COLOR
vec4 BlendTexture2Color( vec4 texture0, vec4 texture2 )
{
    vec4 ret;

#ifdef _TEXTURE2_COLOR_BLEND_MOD
    ret.rgb = texture0.rgb * texture2.rgb;
#endif
#ifdef _TEXTURE2_COLOR_BLEND_ADD
    ret.rgb = texture0.rgb + texture2.rgb;
#endif
#ifdef _TEXTURE2_COLOR_BLEND_SUB
    ret.rgb = texture0.rgb - texture2.rgb;
#endif

#ifdef _TEXTURE2_ALPHA_BLEND_MOD
    ret.a   = texture0.a * texture2.a;
#endif
#ifdef _TEXTURE2_ALPHA_BLEND_ADD
    ret.a   = texture0.a + texture2.a;
#endif
#ifdef _TEXTURE2_ALPHA_BLEND_SUB
    ret.a   = texture0.a - texture2.a;
#endif
    return ret;
}
#endif




//------------------------------------------------------------------------------
// 通常シェーダ
//------------------------------------------------------------------------------
#ifdef _SHADER_TYPE_NORMAL
void main()
{
    vec4 texture0 = vec4( 1 );

    // テクスチャ0を処理
#ifdef _TEXTURE0_ENABLE
    texture0 = GetTexture0Color( sysInTexCoord0 );
#endif

    // テクスチャ1を処理
#ifdef _TEXTURE1_ENABLE
    vec4 texture1 = GetTexture1Color( sysInTexCoord1 );
    texture0 = BlendTexture1Color( texture0, texture1 );
#endif

    // テクスチャ2を処理
#ifdef _TEXTURE2_ENABLE
    vec4 texture2 = GetTexture2Color( sysInTexCoord2 );
    texture0 = BlendTexture2Color( texture0, texture2 );
#endif

#ifdef _COLOR_PROCESS_COLOR
    OUTPUT_COLOR.rgb = sysColor0Vary.rgb;
#endif
#ifdef _COLOR_PROCESS_TEXTURE
    OUTPUT_COLOR.rgb = texture0.rgb * sysColor0Vary.rgb;
#endif
#ifdef _COLOR_PROCESS_TEXTURE_INTERPOLATE
    OUTPUT_COLOR.rgb = mix( sysColor1Vary.rgb, sysColor0Vary.rgb, texture0.rgb );
#endif
#ifdef _COLOR_PROCESS_TEXTURE_ADD
    OUTPUT_COLOR.rgb = texture0.rgb * sysColor0Vary.rgb + sysColor1Vary.rgb;
#endif


#ifdef _PRIMITIVE
    // プリミティブカラー反映
    OUTPUT_COLOR.rgb = BlendPrimitiveColor( OUTPUT_COLOR.rgb, GetPrimitiveColor() );

    // プリミティブ利用時は頂点アルファをブレンド
    texture0 = BlendPrimitiveAlpha( texture0, GetPrimitiveAlpha() );
#endif

    // テクスチャアルファとパーティクルアルファを乗算
#ifdef _ALPHA_PROCESS_MOD
    OUTPUT_COLOR.a = texture0.a * sysColor0Vary.a;
#endif
#ifdef _ALPHA_PROCESS_SUB
    OUTPUT_COLOR.a = ( texture0.a - ( 1.0 - sysColor0Vary.a ) ) * 2.0;
#endif
#ifdef _ALPHA_PROCESS_MOD_A0_A1
    OUTPUT_COLOR.a = texture0.a * sysColor0Vary.a * sysColor1Vary.a;
#endif
#ifdef _ALPHA_PROCESS_SUB_A0_MOD_A1
    OUTPUT_COLOR.a = ( texture0.a - sysColor0Vary.a ) * sysColor1Vary.a;
#endif
#ifdef _ALPHA_PROCESS_DIST_FILED
    float ret = ( texture0.a - sysColor0Vary.a ) * 4.0;
    OUTPUT_COLOR.a = clamp( ret, 0.0, 1.0 ) * sysColor1Vary.a;
#endif

    OUTPUT_COLOR.a *= sysFlagParamVary.x;
}
#endif




//------------------------------------------------------------------------------
// 屈折シェーダ
//------------------------------------------------------------------------------
#ifdef _SHADER_TYPE_REFRACT
void main()
{
    // テクスチャ0(屈折係数)を処理
#ifdef _TEXTURE0_ENABLE
    vec4 texture0 = GetTexture0Color( sysInTexCoord0 );
    texture0.xy = texture0.xy * 2.0 - 1.0;
    texture0.xy *= 25;  // 係数合わせ
#else
    vec4 texture0 = vec4( 0.5 );
#endif

    // 屈折係数を乗算する
    texture0.x *= shaderCoef.x * sysShaderAnim;
#ifdef TARGET_WINDOWS
    texture0.y *= -shaderCoef.y * sysShaderAnim;
#endif
#ifdef TARGET_CAFE
    texture0.y *= shaderCoef.y * sysShaderAnim;
#endif


#ifdef _TEXTURE1_ENABLE
    vec4 texture1 = GetTexture1Color( sysInTexCoord1 );
#endif
#ifdef _TEXTURE2_ENABLE
    vec4 texture2 = GetTexture2Color( sysInTexCoord2 );
#endif

#if defined( _TEXTURE1_ENABLE ) && defined( _REFRACT_APPLY_ALPHA )
    texture0.xy *= texture1.w;
#endif
#if defined( _TEXTURE2_ENABLE ) && defined( _REFRACT_APPLY_ALPHA )
    texture0.xy *= texture2.w;
#endif

    // フレームバッファテクスチャカラーを取得する
    vec4 screenCrd;
    texture0.z = 0.0;
    texture0.w = 0.0;
    screenCrd   = sysFlagCoordVary + texture0;
    texture0    = GetFrameBufferTextureColor( screenCrd );
    texture0.a  = 1.0;

    // テクスチャ1を処理
#ifdef _TEXTURE1_ENABLE
    texture0 = BlendTexture1Color( texture0, texture1 );
#endif

    // テクスチャ2を処理
#ifdef _TEXTURE2_ENABLE
    texture0 = BlendTexture2Color( texture0, texture2 );
#endif

    // テクスチャカラーとパーティクルカラーをブレンド
    OUTPUT_COLOR.rgb = GetFragmentColor( texture0.rgb, sysColor0Vary.rgb, sysColor1Vary.rgb );

#ifdef _PRIMITIVE
    // プリミティブカラー反映
    OUTPUT_COLOR.rgb = BlendPrimitiveColor( OUTPUT_COLOR.rgb, GetPrimitiveColor() );

    // プリミティブ利用時は頂点アルファをブレンド
    texture0 = BlendPrimitiveAlpha( texture0, GetPrimitiveAlpha() );
#endif

    // テクスチャアルファとパーティクルアルファを乗算
    OUTPUT_COLOR.a = GetFragmentAlpha( texture0.a, sysColor0Vary.a, sysColor1Vary.a );

    OUTPUT_COLOR.a *= sysFlagParamVary.x;
}
#endif




//------------------------------------------------------------------------------
// 歪みシェーダ
//------------------------------------------------------------------------------
#ifdef _SHADER_TYPE_DISTORTION
void main()
{
    // 歪み係数
    float ratioX = shaderCoef.x * sysShaderAnim;
    float ratioY = shaderCoef.y * sysShaderAnim;

    // テクスチャ0(歪み係数)を処理
#ifdef _TEXTURE0_ENABLE
    vec4 texture0 = GetTexture0Color( sysInTexCoord0 ) * 2.0 - 1.0;
    //texture0 *= sysFlagCoordVary.w;
#else
    vec4 texture0 = vec4( 0.5 );
#endif

    // 歪みテクスチャ座標を求める
    vec2 distCoord;
    distCoord.x = sysInTexCoord1.x + texture0.x * ratioX;
    distCoord.y = sysInTexCoord1.y + texture0.w * ratioY;

    // テクスチャ1を処理
#ifdef _TEXTURE1_ENABLE
    texture0 = GetTexture1Color( distCoord );
#endif

    // テクスチャ2を処理
#ifdef _TEXTURE2_ENABLE
    vec4 texture2 = GetTexture2Color( sysInTexCoord2 );
    texture0 = BlendTexture2Color( texture0, texture2 );
#endif

    // テクスチャカラーとパーティクルカラーをブレンド
    OUTPUT_COLOR.rgb = GetFragmentColor( texture0.rgb, sysColor0Vary.rgb, sysColor1Vary.rgb );

#ifdef _PRIMITIVE
    // プリミティブカラー反映
    OUTPUT_COLOR.rgb = BlendPrimitiveColor( OUTPUT_COLOR.rgb, GetPrimitiveColor() );

    // プリミティブ利用時は頂点アルファをブレンド
    texture0 = BlendPrimitiveAlpha( texture0, GetPrimitiveAlpha() );
#endif

    // テクスチャアルファとパーティクルアルファを乗算
    OUTPUT_COLOR.a = GetFragmentAlpha( texture0.a, sysColor0Vary.a, sysColor1Vary.a );

    OUTPUT_COLOR.a *= sysFlagParamVary.x;
}
#endif

