﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.DataModel
{
    /// <summary>
    /// フィールドタイプ.
    /// </summary>
    public enum FieldTypes
    {
        /// <summary>新ランダム.</summary>
        Random,

        /// <summary>磁力.</summary>
        Magnet,

        /// <summary>スピン.</summary>
        Spin,

        /// <summary>収束.</summary>
        Converge,

        /// <summary>位置に加算.</summary>
        AddLocation,

        /// <summary>シンプルコリジョン.</summary>
        Collision,

        /// <summary>カールノイズ.</summary>
        CurlNoise,

        /// <summary>ランダム</summary>
        RandomFe1,

        /// <summary>カスタムフィールド</summary>
        CustomField,
    }

    /// <summary>
    /// シェーダタイプ.
    /// </summary>
    public enum ShaderTypes
    {
        /// <summary>スペック依存宣言(PC用)</summary>
        SpecDeclarationGenericShader,

        /// <summary>スペック依存宣言(実機用)</summary>
        SpecDeclarationTargetShader,

        /// <summary>eft_ParticleDeclaration.glsl</summary>
        ParticleDeclarationShader,

        /// <summary>eft_ParticleDeclaration.vsh</summary>
        ParticleDeclarationVertexShader,

        /// <summary>eft_ParticleDeclaration.fsh</summary>
        ParticleDeclarationFragmentShader,

        /// <summary>eft_StreamOutDeclaration.vsh</summary>
        StreamOutDeclarationVertexShader,

        /// <summary>eft_Particle.vsh</summary>
        ParticleVertexShader,

        /// <summary>eft_Particle.gsh</summary>
        ParticleFragmentShader,

        /// <summary>eft_StreamOut.vsh</summary>
        StreamOutVertexShader,

        /// <summary>共通バーテックスシェーダ</summary>
        GeneralVertexShader,

        /// <summary>共通フラグメントシェーダ</summary>
        GeneralFragmentShader,

        /// <summary>共通コンピュートシェーダ</summary>
        GeneralComputeShader,

        /// <summary>カスタムバーテックスシェーダ</summary>
        CustomVertexShader,

        /// <summary>カスタムフラグメントシェーダ</summary>
        CustomFragmentShader,

        /// <summary>Reserved vertex shader.</summary>
        ReservedVertexShader,

        /// <summary>Reserved fragment shader.</summary>
        ReservedFragmentShader,

        /// <summary>Shader generated from effect combiner.</summary>
        EffectCombinerShader,
    }
}
