﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// ユーザーページに対応するデータモデルです.
    /// </summary>
    [Serializable]
    public class UserPageData : DataModelBase
    {
        /// <summary>The content user data model.</summary>
        private UserDataBase content = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public UserPageData()
            : base()
        {
            this.PostConstruct();
        }

        /// <summary>
        /// ページ内コンテンツデータ.
        /// </summary>
        public UserDataBase ContentsData
        {
            get { return this.GetDataModelFromField(ref this.content, true); }
            set { this.SetDataModelToField(ref this.content, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as UserPageData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ContentsData = srcDataModel.ContentsData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ContentsData", this.ContentsData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ContentsData = this.ReadElement(context, "ContentsData", this.ContentsData);

            return success;
        }
    }
}
