﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Xml.Serialization;

using EffectMaker.Foundation.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// ビューア上で描画のOn/Offが切り替え可能なデータモデルのベースクラスです。
    /// </summary>
    [Serializable]
    public abstract class DisplayableDataBase : WorkspaceNodeDataBase
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public DisplayableDataBase() :
            base()
        {
            this.Displayed = true;
        }

        /// <summary>
        /// 描画のOn/Offを取得または設定します。
        /// </summary>
        [XmlIgnore]
        public bool Displayed { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as DisplayableDataBase;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Displayed = srcDataModel.Displayed;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // This class has nothing to serialize.
            return base.WriteXml(context);
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // This class has nothing to serialize.
            return base.ReadXml(context);
        }
    }
}
