﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.DataModel.Attributes
{
    /// <summary>
    /// Custom attribute for specifying the data model type for the next version.
    /// </summary>
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = false)]
    public class NextVersionDataModelAttribute : System.Attribute
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="type">The data model type of the next version.</param>
        public NextVersionDataModelAttribute(Type type)
        {
            this.Type = type;
        }

        /// <summary>
        /// Get the data model type of the next version.
        /// </summary>
        public Type Type { get; private set; }
    }
}
