﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/放出タブデータです。
    /// </summary>
    [Serializable]
    public class EmitterEmissionData : DataModelBase
    {
        /// <summary>
        /// 放出設定グループデータを取得または設定します。
        /// </summary>
        private EmitterEmissionTimingData emitterEmissionTimingData = null;

        /// <summary>
        /// 初速設定グループデータを取得または設定します。
        /// </summary>
        private EmitterEmissionVelocityData emitterEmissionVelocityData = null;

        /// <summary>
        /// その他運動設定グループデータを取得または設定します。
        /// </summary>
        private EmitterEmissionGravityData emitterEmissionGravityData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmissionData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// 放出設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("644c5d36-5153-42fb-9d1b-5a3ac123f063")]
        public EmitterEmissionTimingData EmitterEmissionTimingData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmissionTimingData, false); }
            set { this.SetDataModelToField(ref this.emitterEmissionTimingData, value); }
        }

        /// <summary>
        /// 初速設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2a7a6bf4-cb34-42d1-8e96-51f1c4f271cc")]
        public EmitterEmissionVelocityData EmitterEmissionVelocityData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmissionVelocityData, false); }
            set { this.SetDataModelToField(ref this.emitterEmissionVelocityData, value); }
        }

        /// <summary>
        /// その他運動設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3941d33e-b559-4e02-b1bf-d8eeac5edb9a")]
        public EmitterEmissionGravityData EmitterEmissionGravityData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmissionGravityData, false); }
            set { this.SetDataModelToField(ref this.emitterEmissionGravityData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterEmissionData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterEmissionTimingData = srcDataModel.EmitterEmissionTimingData;
            this.EmitterEmissionVelocityData = srcDataModel.EmitterEmissionVelocityData;
            this.EmitterEmissionGravityData = srcDataModel.EmitterEmissionGravityData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterEmissionTimingData", this.EmitterEmissionTimingData);
            this.WriteElement(context, "EmitterEmissionVelocityData", this.EmitterEmissionVelocityData);
            this.WriteElement(context, "EmitterEmissionGravityData", this.EmitterEmissionGravityData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterEmissionTimingData = this.ReadElement(context, "EmitterEmissionTimingData", this.EmitterEmissionTimingData);
            this.EmitterEmissionVelocityData = this.ReadElement(context, "EmitterEmissionVelocityData", this.EmitterEmissionVelocityData);
            this.EmitterEmissionGravityData = this.ReadElement(context, "EmitterEmissionGravityData", this.EmitterEmissionGravityData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterEmissionData(PrevVersion.EmitterEmissionData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterEmissionData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterEmissionData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterEmissionTimingData = srcDataModel.EmitterEmissionTimingData;
            this.EmitterEmissionVelocityData = srcDataModel.EmitterEmissionVelocityData;
            this.EmitterEmissionGravityData = srcDataModel.EmitterEmissionGravityData;

            return true;
        }
    }
}
