﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/コンバイナタブデータです。
    /// </summary>
    [Serializable]
    public class EmitterCombinerData : DataModelBase
    {
        /// <summary>
        /// カラー・アルファコンバイナグループデータを取得または設定します。
        /// </summary>
        private EmitterCombinerEquationData emitterCombinerEquationData = null;

        /// <summary>
        /// パーティクルシェーダグループデータを取得または設定します。
        /// </summary>
        private EmitterCombinerShaderData emitterCombinerShaderData = null;

        /// <summary>
        /// シェーダコンバイナツールグループデータを取得または設定します。
        /// </summary>
        private EmitterCombinerEditorData emitterCombinerEditorData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCombinerData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// カラー・アルファコンバイナグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f38a8132-6877-466e-b36f-b7fe18c199f4")]
        public EmitterCombinerEquationData EmitterCombinerEquationData
        {
            get { return this.GetDataModelFromField(ref this.emitterCombinerEquationData, false); }
            set { this.SetDataModelToField(ref this.emitterCombinerEquationData, value); }
        }

        /// <summary>
        /// パーティクルシェーダグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f7958ff3-3af4-43af-9aae-c9c5f70e6db6")]
        public EmitterCombinerShaderData EmitterCombinerShaderData
        {
            get { return this.GetDataModelFromField(ref this.emitterCombinerShaderData, false); }
            set { this.SetDataModelToField(ref this.emitterCombinerShaderData, value); }
        }

        /// <summary>
        /// シェーダコンバイナツールグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8b48e1f6-560b-4223-8025-f99421ada89d")]
        public EmitterCombinerEditorData EmitterCombinerEditorData
        {
            get { return this.GetDataModelFromField(ref this.emitterCombinerEditorData, false); }
            set { this.SetDataModelToField(ref this.emitterCombinerEditorData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterCombinerData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterCombinerEquationData = srcDataModel.EmitterCombinerEquationData;
            this.EmitterCombinerShaderData = srcDataModel.EmitterCombinerShaderData;
            this.EmitterCombinerEditorData = srcDataModel.EmitterCombinerEditorData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterCombinerEquationData", this.EmitterCombinerEquationData);
            this.WriteElement(context, "EmitterCombinerShaderData", this.EmitterCombinerShaderData);
            this.WriteElement(context, "EmitterCombinerEditorData", this.EmitterCombinerEditorData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterCombinerEquationData = this.ReadElement(context, "EmitterCombinerEquationData", this.EmitterCombinerEquationData);
            this.EmitterCombinerShaderData = this.ReadElement(context, "EmitterCombinerShaderData", this.EmitterCombinerShaderData);
            this.EmitterCombinerEditorData = this.ReadElement(context, "EmitterCombinerEditorData", this.EmitterCombinerEditorData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterCombinerData(PrevVersion.EmitterCombinerData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterCombinerData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterCombinerData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterCombinerEquationData = srcDataModel.EmitterCombinerEquationData;
            this.EmitterCombinerShaderData = srcDataModel.EmitterCombinerShaderData;
            this.EmitterCombinerEditorData = srcDataModel.EmitterCombinerEditorData;

            return true;
        }
    }
}
