﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_7;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// プレビューノード/基本設定タブです。
    /// </summary>
    [Serializable]
    public class PreviewBasicSettingData : DataModelBase
    {
        /// <summary>
        /// ファイル管理グループです。
        /// </summary>
        private PreviewBasicFileData previewBasicFileData = null;

        /// <summary>
        /// プレビューの読み込みです。
        /// </summary>
        private PreviewBasicLoadData previewBasicLoadData = null;

        /// <summary>
        /// 再生管理データです。
        /// </summary>
        private PreviewBasicPlaybackData previewBasicPlaybackData = null;

        /// <summary>
        /// プレビューの保存です。
        /// </summary>
        private PreviewBasicSaveData previewBasicSaveData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewBasicSettingData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// ファイル管理グループです。
        /// </summary>
        [DataModelPropertyGuid("a03cd85c-d6d2-4c98-a470-dd7c77b50d86")]
        public PreviewBasicFileData PreviewBasicFileData
        {
            get { return this.GetDataModelFromField(ref this.previewBasicFileData, false); }
            set { this.SetDataModelToField(ref this.previewBasicFileData, value); }
        }

        /// <summary>
        /// プレビューの読み込みです。
        /// </summary>
        [DataModelPropertyGuid("5da967ce-391e-4640-9e6a-bf3717875aac")]
        public PreviewBasicLoadData PreviewBasicLoadData
        {
            get { return this.GetDataModelFromField(ref this.previewBasicLoadData, false); }
            set { this.SetDataModelToField(ref this.previewBasicLoadData, value); }
        }

        /// <summary>
        /// 再生管理データです。
        /// </summary>
        [DataModelPropertyGuid("d95c5a9c-d18d-4649-8fb1-bb6bb165d1a1")]
        public PreviewBasicPlaybackData PreviewBasicPlaybackData
        {
            get { return this.GetDataModelFromField(ref this.previewBasicPlaybackData, false); }
            set { this.SetDataModelToField(ref this.previewBasicPlaybackData, value); }
        }

        /// <summary>
        /// プレビューの保存です。
        /// </summary>
        [DataModelPropertyGuid("c07a21e7-d116-4ce6-bb6e-4bac3e4bdeea")]
        public PreviewBasicSaveData PreviewBasicSaveData
        {
            get { return this.GetDataModelFromField(ref this.previewBasicSaveData, false); }
            set { this.SetDataModelToField(ref this.previewBasicSaveData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewBasicSettingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.PreviewBasicFileData = srcDataModel.PreviewBasicFileData;
            this.PreviewBasicLoadData = srcDataModel.PreviewBasicLoadData;
            this.PreviewBasicPlaybackData = srcDataModel.PreviewBasicPlaybackData;
            this.PreviewBasicSaveData = srcDataModel.PreviewBasicSaveData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "PreviewBasicFileData", this.PreviewBasicFileData);
            this.WriteElement(context, "PreviewBasicLoadData", this.PreviewBasicLoadData);
            this.WriteElement(context, "PreviewBasicPlaybackData", this.PreviewBasicPlaybackData);
            this.WriteElement(context, "PreviewBasicSaveData", this.PreviewBasicSaveData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.PreviewBasicFileData = this.ReadElement(context, "PreviewBasicFileData", this.PreviewBasicFileData);
            this.PreviewBasicLoadData = this.ReadElement(context, "PreviewBasicLoadData", this.PreviewBasicLoadData);
            this.PreviewBasicPlaybackData = this.ReadElement(context, "PreviewBasicPlaybackData", this.PreviewBasicPlaybackData);
            this.PreviewBasicSaveData = this.ReadElement(context, "PreviewBasicSaveData", this.PreviewBasicSaveData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.PreviewBasicSettingData(PrevVersion.PreviewBasicSettingData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.PreviewBasicSettingData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.PreviewBasicSettingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.PreviewBasicFileData = srcDataModel.PreviewBasicFileData;
            this.PreviewBasicLoadData = srcDataModel.PreviewBasicLoadData;
            this.PreviewBasicPlaybackData = srcDataModel.PreviewBasicPlaybackData;
            this.PreviewBasicSaveData = srcDataModel.PreviewBasicSaveData;

            return true;
        }
    }
}
