﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_7;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// カスタムフィールドの数値データです。
    /// </summary>
    [Serializable]
    public class CustomFieldValueData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CustomFieldValueData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// 0番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("66a7c568-0fa3-418a-8d02-27cb600eb199")]
        public float Value0 { get; set; }

        /// <summary>
        /// 1番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("9279025b-672b-403a-8da5-6cf6f3dca92f")]
        public float Value1 { get; set; }

        /// <summary>
        /// 2番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("741d5102-aec9-433d-82f9-0e5726a4036b")]
        public float Value2 { get; set; }

        /// <summary>
        /// 3番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("39d57b4b-8a69-4e1b-9156-bc929b290168")]
        public float Value3 { get; set; }

        /// <summary>
        /// 4番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("8646f988-1abd-447e-9f78-0158841a7e9b")]
        public float Value4 { get; set; }

        /// <summary>
        /// 5番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("d530c18e-c38a-473e-a89f-6a6e3f6f33c9")]
        public float Value5 { get; set; }

        /// <summary>
        /// 6番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("2fd12a4d-cc62-4fb0-acca-9ff47119182b")]
        public float Value6 { get; set; }

        /// <summary>
        /// 7番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("3e45b428-c5bd-47fc-9030-aa35d93755ea")]
        public float Value7 { get; set; }

        /// <summary>
        /// 8番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("d452f141-34bc-440c-af7d-447c21c0c1ba")]
        public float Value8 { get; set; }

        /// <summary>
        /// 9番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("7141d073-f5f8-4b38-9754-e9ba9475eac8")]
        public float Value9 { get; set; }

        /// <summary>
        /// 10番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("ef329004-4a5a-4772-bcb3-81ab70e5a69d")]
        public float Value10 { get; set; }

        /// <summary>
        /// 11番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("60a5da44-a37f-434b-b3c5-63656801356d")]
        public float Value11 { get; set; }

        /// <summary>
        /// 12番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("4df93d43-cf67-453e-98b1-acfc8cd70b0c")]
        public float Value12 { get; set; }

        /// <summary>
        /// 13番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("f0201f28-c4ea-4a68-9424-b362d63a8ea7")]
        public float Value13 { get; set; }

        /// <summary>
        /// 14番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("80eb5984-4a57-4cb8-a73c-522c78927e26")]
        public float Value14 { get; set; }

        /// <summary>
        /// 15番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("afa6e591-b820-4b3a-869e-5a6b4d1ebd80")]
        public float Value15 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.CustomFieldValueData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Value0 = srcDataModel.Value0;
            this.Value1 = srcDataModel.Value1;
            this.Value2 = srcDataModel.Value2;
            this.Value3 = srcDataModel.Value3;
            this.Value4 = srcDataModel.Value4;
            this.Value5 = srcDataModel.Value5;
            this.Value6 = srcDataModel.Value6;
            this.Value7 = srcDataModel.Value7;
            this.Value8 = srcDataModel.Value8;
            this.Value9 = srcDataModel.Value9;
            this.Value10 = srcDataModel.Value10;
            this.Value11 = srcDataModel.Value11;
            this.Value12 = srcDataModel.Value12;
            this.Value13 = srcDataModel.Value13;
            this.Value14 = srcDataModel.Value14;
            this.Value15 = srcDataModel.Value15;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Value0", this.Value0);
            this.WriteElement(context, "Value1", this.Value1);
            this.WriteElement(context, "Value2", this.Value2);
            this.WriteElement(context, "Value3", this.Value3);
            this.WriteElement(context, "Value4", this.Value4);
            this.WriteElement(context, "Value5", this.Value5);
            this.WriteElement(context, "Value6", this.Value6);
            this.WriteElement(context, "Value7", this.Value7);
            this.WriteElement(context, "Value8", this.Value8);
            this.WriteElement(context, "Value9", this.Value9);
            this.WriteElement(context, "Value10", this.Value10);
            this.WriteElement(context, "Value11", this.Value11);
            this.WriteElement(context, "Value12", this.Value12);
            this.WriteElement(context, "Value13", this.Value13);
            this.WriteElement(context, "Value14", this.Value14);
            this.WriteElement(context, "Value15", this.Value15);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Value0 = this.ReadElement(context, "Value0", this.Value0);
            this.Value1 = this.ReadElement(context, "Value1", this.Value1);
            this.Value2 = this.ReadElement(context, "Value2", this.Value2);
            this.Value3 = this.ReadElement(context, "Value3", this.Value3);
            this.Value4 = this.ReadElement(context, "Value4", this.Value4);
            this.Value5 = this.ReadElement(context, "Value5", this.Value5);
            this.Value6 = this.ReadElement(context, "Value6", this.Value6);
            this.Value7 = this.ReadElement(context, "Value7", this.Value7);
            this.Value8 = this.ReadElement(context, "Value8", this.Value8);
            this.Value9 = this.ReadElement(context, "Value9", this.Value9);
            this.Value10 = this.ReadElement(context, "Value10", this.Value10);
            this.Value11 = this.ReadElement(context, "Value11", this.Value11);
            this.Value12 = this.ReadElement(context, "Value12", this.Value12);
            this.Value13 = this.ReadElement(context, "Value13", this.Value13);
            this.Value14 = this.ReadElement(context, "Value14", this.Value14);
            this.Value15 = this.ReadElement(context, "Value15", this.Value15);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.CustomFieldValueData(PrevVersion.CustomFieldValueData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.CustomFieldValueData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.CustomFieldValueData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Value0 = srcDataModel.Value0;
            this.Value1 = srcDataModel.Value1;
            this.Value2 = srcDataModel.Value2;
            this.Value3 = srcDataModel.Value3;
            this.Value4 = srcDataModel.Value4;
            this.Value5 = srcDataModel.Value5;
            this.Value6 = srcDataModel.Value6;
            this.Value7 = srcDataModel.Value7;
            this.Value8 = srcDataModel.Value8;
            this.Value9 = srcDataModel.Value9;
            this.Value10 = srcDataModel.Value10;
            this.Value11 = srcDataModel.Value11;
            this.Value12 = srcDataModel.Value12;
            this.Value13 = srcDataModel.Value13;
            this.Value14 = srcDataModel.Value14;
            this.Value15 = srcDataModel.Value15;

            return true;
        }
    }
}
