﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_7;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタに設定する拡張パラメータを保持するデータモデルです。
    /// </summary>
    [Serializable]
    public class EmitterExtParams : DataModelBase
    {
        /// <summary>
        /// ユーザー定義に基づくエミッタ拡張パラメータのインスタンスです。
        /// </summary>
        private EmitterExtParamsSettingData emitterExtParamsSettingData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterExtParams() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// ユーザー定義に基づくエミッタ拡張パラメータのインスタンスです。
        /// </summary>
        [DataModelPropertyGuid("0ba41758-6b4b-4751-a153-4bb8d2ad19bb")]
        public EmitterExtParamsSettingData EmitterExtParamsSettingData
        {
            get { return this.GetDataModelFromField(ref this.emitterExtParamsSettingData, true); }
            set { this.SetDataModelToField(ref this.emitterExtParamsSettingData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterExtParams;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterExtParamsSettingData = srcDataModel.EmitterExtParamsSettingData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterExtParamsSettingData", this.EmitterExtParamsSettingData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            var backup_EmitterExtParamsSettingData = this.EmitterExtParamsSettingData;
            this.EmitterExtParamsSettingData = this.ReadElement<EmitterExtParamsSettingData>(context, "EmitterExtParamsSettingData", null) ?? backup_EmitterExtParamsSettingData;

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterExtParams(PrevVersion.EmitterExtParams src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterExtParams();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterExtParams;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterExtParamsSettingData = srcDataModel.EmitterExtParamsSettingData;

            return true;
        }
    }
}
