﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_6;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ワークスペースシリアライズ用データです。
    /// </summary>
    [Serializable]
    public class WorkspaceStorageData : DataModelBase
    {
        /// <summary>
        /// エミッタセットリストです。
        /// </summary>
        private List<EmitterSetReferenceData> emitterSetList = null;

        /// <summary>
        /// ビューアデータです。
        /// </summary>
        private ViewerData viewerData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public WorkspaceStorageData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// エミッタセットリストです。
        /// </summary>
        [DataModelPropertyGuid("596ffa08-42c2-471d-829e-2abaeec20007")]
        public List<EmitterSetReferenceData> EmitterSetList
        {
            get { return this.GetDataModelListFromField(ref this.emitterSetList); }
            set { this.SetDataModelListToField(ref this.emitterSetList, value); }
        }

        /// <summary>
        /// ビューアデータです。
        /// </summary>
        [DataModelPropertyGuid("a872a5a3-3d0e-4077-a269-8a7d63b0ee04")]
        public ViewerData ViewerData
        {
            get { return this.GetDataModelFromField(ref this.viewerData, false); }
            set { this.SetDataModelToField(ref this.viewerData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.WorkspaceStorageData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterSetList = srcDataModel.EmitterSetList;
            this.ViewerData = srcDataModel.ViewerData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteEnumerableElement(context, "EmitterSetList", this.EmitterSetList);
            this.WriteElement(context, "ViewerData", this.ViewerData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterSetList = this.ReadListElement(context, "EmitterSetList", this.EmitterSetList);
            this.ViewerData = this.ReadElement(context, "ViewerData", this.ViewerData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.WorkspaceStorageData(PrevVersion.WorkspaceStorageData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.WorkspaceStorageData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.WorkspaceStorageData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterSetList = srcDataModel.EmitterSetList.Select(dm => (CurrVersion.EmitterSetReferenceData)dm).ToList();
            this.ViewerData = srcDataModel.ViewerData;

            return true;
        }
    }
}
