﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.ObjectModel;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_6;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// オフセット行列データ.
    /// </summary>
    [Serializable]
    public class PreviewMatrixOffsetMatrixData : DataModelBase
    {
        /// <summary>
        /// スケール.
        /// </summary>
        private Vector3f offsetScale = null;

        /// <summary>
        /// 座標.
        /// </summary>
        private Vector3f offsetPosition = null;

        /// <summary>
        /// 回転X, Y, Z
        /// </summary>
        private Vector3f offsetRotation = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewMatrixOffsetMatrixData() :
            base()
        {
            this.OffsetScale = new Vector3f(1.0f, 1.0f, 1.0f);
            this.OffsetPosition = new Vector3f(0.0f, 0.0f, 0.0f);
            this.EmitterBillboardType = 0;
            this.OffsetRotation = new Vector3f(0.0f, 0.0f, 0.0f);

            this.PostConstruct();
        }

        /// <summary>
        /// スケール.
        /// </summary>
        [DataModelPropertyGuid("7d04f4d3-fbe9-464b-9006-94cbe27f3db4")]
        public Vector3f OffsetScale
        {
            get { return this.GetObjectFromField(ref this.offsetScale, false); }
            set { this.SetISettableToField(ref this.offsetScale, value); }
        }

        /// <summary>
        /// 座標.
        /// </summary>
        [DataModelPropertyGuid("59d7cccb-beaf-4ae2-a0a3-5699d0332d5f")]
        public Vector3f OffsetPosition
        {
            get { return this.GetObjectFromField(ref this.offsetPosition, false); }
            set { this.SetISettableToField(ref this.offsetPosition, value); }
        }

        /// <summary>
        /// エミッタビルボードの種類.
        /// </summary>
        [DataModelPropertyGuid("72343577-9f8a-448a-beb9-6eb81a71ad35")]
        public int EmitterBillboardType { get; set; }

        /// <summary>
        /// 回転X, Y, Z
        /// </summary>
        [DataModelPropertyGuid("78934dfe-6b0c-4bbb-8b3d-9291b6aed0b7")]
        public Vector3f OffsetRotation
        {
            get { return this.GetObjectFromField(ref this.offsetRotation, false); }
            set { this.SetISettableToField(ref this.offsetRotation, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewMatrixOffsetMatrixData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.OffsetScale = srcDataModel.OffsetScale;
            this.OffsetPosition = srcDataModel.OffsetPosition;
            this.EmitterBillboardType = srcDataModel.EmitterBillboardType;
            this.OffsetRotation = srcDataModel.OffsetRotation;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "OffsetScale", this.OffsetScale);
            this.WriteElement(context, "OffsetPosition", this.OffsetPosition);
            this.WriteElement(context, "EmitterBillboardType", this.EmitterBillboardType);
            this.WriteElement(context, "OffsetRotation", this.OffsetRotation);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.OffsetScale = this.ReadElement(context, "OffsetScale", this.OffsetScale);
            this.OffsetPosition = this.ReadElement(context, "OffsetPosition", this.OffsetPosition);
            this.EmitterBillboardType = this.ReadElement(context, "EmitterBillboardType", this.EmitterBillboardType);
            this.OffsetRotation = this.ReadElement(context, "OffsetRotation", this.OffsetRotation);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.PreviewMatrixOffsetMatrixData(PrevVersion.PreviewMatrixOffsetMatrixData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.PreviewMatrixOffsetMatrixData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.PreviewMatrixOffsetMatrixData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.OffsetScale = srcDataModel.OffsetScale;
            this.OffsetPosition = srcDataModel.OffsetPosition;
            this.EmitterBillboardType = srcDataModel.EmitterBillboardType;
            this.OffsetRotation = srcDataModel.OffsetRotation;

            return true;
        }
    }
}
