﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_6;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/テクスチャタブデータです。
    /// </summary>
    [Serializable]
    public class EmitterTextureGroupData : DataModelBase
    {
        /// <summary>
        /// テクスチャ0サブタブデータを取得または設定します。
        /// </summary>
        private EmitterTextureData texture0 = null;

        /// <summary>
        /// テクスチャ1サブタブデータを取得または設定します。
        /// </summary>
        private EmitterTextureData texture1 = null;

        /// <summary>
        /// テクスチャ2サブタブデータを取得または設定します。
        /// </summary>
        private EmitterTextureData texture2 = null;

        /// <summary>
        /// 共通設定サブタブデータを取得または設定します。
        /// </summary>
        private EmitterTextureCommonSettingsData commonSettings = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterTextureGroupData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// テクスチャ0サブタブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("48a87496-8290-44ca-9497-235cf63b2443")]
        public EmitterTextureData Texture0
        {
            get { return this.GetDataModelFromField(ref this.texture0, false); }
            set { this.SetDataModelToField(ref this.texture0, value); }
        }

        /// <summary>
        /// テクスチャ1サブタブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("34ea0d57-c02f-454d-b9e0-5b42bb3bc0ac")]
        public EmitterTextureData Texture1
        {
            get { return this.GetDataModelFromField(ref this.texture1, false); }
            set { this.SetDataModelToField(ref this.texture1, value); }
        }

        /// <summary>
        /// テクスチャ2サブタブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("050c90de-884a-4741-bc8c-1e2a6a479334")]
        public EmitterTextureData Texture2
        {
            get { return this.GetDataModelFromField(ref this.texture2, false); }
            set { this.SetDataModelToField(ref this.texture2, value); }
        }

        /// <summary>
        /// 共通設定サブタブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2188a8e3-0985-4250-af8f-d50b867a924a")]
        public EmitterTextureCommonSettingsData CommonSettings
        {
            get { return this.GetDataModelFromField(ref this.commonSettings, false); }
            set { this.SetDataModelToField(ref this.commonSettings, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterTextureGroupData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Texture0 = srcDataModel.Texture0;
            this.Texture1 = srcDataModel.Texture1;
            this.Texture2 = srcDataModel.Texture2;
            this.CommonSettings = srcDataModel.CommonSettings;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Texture0", this.Texture0);
            this.WriteElement(context, "Texture1", this.Texture1);
            this.WriteElement(context, "Texture2", this.Texture2);
            this.WriteElement(context, "CommonSettings", this.CommonSettings);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Texture0 = this.ReadElement(context, "Texture0", this.Texture0);
            this.Texture1 = this.ReadElement(context, "Texture1", this.Texture1);
            this.Texture2 = this.ReadElement(context, "Texture2", this.Texture2);
            this.CommonSettings = this.ReadElement(context, "CommonSettings", this.CommonSettings);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterTextureGroupData(PrevVersion.EmitterTextureGroupData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterTextureGroupData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterTextureGroupData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Texture0 = srcDataModel.Texture0;
            this.Texture1 = srcDataModel.Texture1;
            this.Texture2 = srcDataModel.Texture2;
            this.CommonSettings = srcDataModel.CommonSettings;

            return true;
        }
    }
}
