﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_6;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/回転タブ/回転設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterRotationBasicData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterRotationBasicData() :
            base()
        {
            this.RotationType = 4;
            this.RotationAttenuation = 1.0f;
            this.EnableRotationAxisX = false;
            this.EnableRotationAxisY = false;
            this.EnableRotationAxisZ = false;

            this.PostConstruct();
        }

        /// <summary>
        /// 回転順序を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a88ffd8a-1b31-4911-855b-5df33c50093d")]
        public int RotationType { get; set; }

        /// <summary>
        /// 回転速度減衰率を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("687a7828-de71-4ef5-9b32-411c99068d24")]
        public float RotationAttenuation { get; set; }

        /// <summary>
        /// 回転軸X軸のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c071fc6c-5537-4a58-a948-97a63c88ec70")]
        public bool EnableRotationAxisX { get; set; }

        /// <summary>
        /// 回転軸Y軸のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b3ff1b03-9219-4276-8953-4fb986cdac70")]
        public bool EnableRotationAxisY { get; set; }

        /// <summary>
        /// 回転軸Z軸のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9f044a34-4d60-49f7-a4e4-dedc024c09dd")]
        public bool EnableRotationAxisZ { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterRotationBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.RotationType = srcDataModel.RotationType;
            this.RotationAttenuation = srcDataModel.RotationAttenuation;
            this.EnableRotationAxisX = srcDataModel.EnableRotationAxisX;
            this.EnableRotationAxisY = srcDataModel.EnableRotationAxisY;
            this.EnableRotationAxisZ = srcDataModel.EnableRotationAxisZ;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "RotationType", this.RotationType);
            this.WriteElement(context, "RotationAttenuation", this.RotationAttenuation);
            this.WriteElement(context, "EnableRotationAxisX", this.EnableRotationAxisX);
            this.WriteElement(context, "EnableRotationAxisY", this.EnableRotationAxisY);
            this.WriteElement(context, "EnableRotationAxisZ", this.EnableRotationAxisZ);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.RotationType = this.ReadElement(context, "RotationType", this.RotationType);
            this.RotationAttenuation = this.ReadElement(context, "RotationAttenuation", this.RotationAttenuation);
            this.EnableRotationAxisX = this.ReadElement(context, "EnableRotationAxisX", this.EnableRotationAxisX);
            this.EnableRotationAxisY = this.ReadElement(context, "EnableRotationAxisY", this.EnableRotationAxisY);
            this.EnableRotationAxisZ = this.ReadElement(context, "EnableRotationAxisZ", this.EnableRotationAxisZ);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterRotationBasicData(PrevVersion.EmitterRotationBasicData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterRotationBasicData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterRotationBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.RotationType = srcDataModel.RotationType;
            this.RotationAttenuation = srcDataModel.RotationAttenuation;
            this.EnableRotationAxisX = srcDataModel.EnableRotationAxisX;
            this.EnableRotationAxisY = srcDataModel.EnableRotationAxisY;
            this.EnableRotationAxisZ = srcDataModel.EnableRotationAxisZ;

            return true;
        }
    }
}
