﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Collections;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_6;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノードデータです。
    /// </summary>
    [Serializable]
    public class EmitterData : DisplayableDataBase
    {
        /// <summary>
        /// 基本設定タブデータを取得または設定します。
        /// </summary>
        private EmitterBasicSettingData emitterBasicSettingData = null;

        /// <summary>
        /// 放出タブデータを取得または設定します。
        /// </summary>
        private EmitterEmissionData emitterEmissionData = null;

        /// <summary>
        /// エミッタタブデータを取得または設定します。
        /// </summary>
        private EmitterEmitterData emitterEmitterData = null;

        /// <summary>
        /// パーティクルタブデータを取得または設定します。
        /// </summary>
        private EmitterParticleData emitterParticleData = null;

        /// <summary>
        /// コンバイナタブデータを取得または設定します。
        /// </summary>
        private EmitterCombinerData emitterCombinerData = null;

        /// <summary>
        /// テクスチャタブデータを取得または設定します。
        /// </summary>
        private EmitterTextureGroupData textures = null;

        /// <summary>
        /// カラータブデータを取得または設定します。
        /// </summary>
        private EmitterColorGroupData emitterColorData = null;

        /// <summary>
        /// スケールタブデータを取得または設定します。
        /// </summary>
        private EmitterScaleData emitterScaleData = null;

        /// <summary>
        /// 回転タブデータを取得または設定します。
        /// </summary>
        private EmitterRotationData emitterRotationData = null;

        /// <summary>
        /// エミッタリストです
        /// </summary>
        private List<EmitterData> emitterList = null;

        /// <summary>
        /// フィールドリストです.
        /// </summary>
        private List<FieldDataBase> fieldList = null;

        /// <summary>
        /// ユーザーデータリストです.
        /// </summary>
        private List<UserPageData> userDataList = null;

        /// <summary>
        /// ストライプデータです.
        /// </summary>
        private StripeData stripeData = null;

        /// <summary>
        /// カスタムシェーダーです
        /// </summary>
        private EmitterCustomShaderData emitterCustomShaderData = null;

        /// <summary>
        /// カスタムアクションノードデータを取得または設定します。
        /// </summary>
        private CustomActionData customActionData = null;

        /// <summary>
        /// ストライプノードデータを取得または設定します。
        /// </summary>
        private ReservedShaderNodeData reservedShader = null;

        /// <summary>
        /// エミッタ拡張パラメータノードデータを取得または設定します。
        /// </summary>
        private EmitterExtParams emitterExtParams = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterData() :
            base()
        {
            this.Name = string.Empty;

            this.PostConstruct();
        }

        /// <summary>
        /// エミッタ名を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2d4eb3ba-cee7-4748-8696-fe3bafe9c92a")]
        public string Name { get; set; }

        /// <summary>
        /// Enumerate the file path of the textures the emitter uses.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e8a631f6-4dbe-4caa-84a3-895bca13de8c")]
        public IEnumerable<string> TexturePaths
        {
            get
            {
                string path = this.Textures.Texture0.EmitterTextureFileData.FilePath;
                if (string.IsNullOrEmpty(path) == false)
                {
                    yield return path;
                }

                path = this.Textures.Texture1.EmitterTextureFileData.FilePath;
                if (string.IsNullOrEmpty(path) == false)
                {
                    yield return path;
                }

                path = this.Textures.Texture2.EmitterTextureFileData.FilePath;
                if (string.IsNullOrEmpty(path) == false)
                {
                    yield return path;
                }
            }
        }

        /// <summary>
        /// Enumerate the file path of the primitive the emitter uses.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("3ba29d76-de31-4a4c-8ccd-6e96c045391b")]
        public IEnumerable<string> PrimitivePaths
        {
            get
            {
                string path = this.EmitterParticleData.EmitterParticleShapeData.PrimitiveFilePath;
                if (string.IsNullOrEmpty(path) == false && this.EmitterParticleData.EmitterParticleShapeData.ShapeType != 0)
                {
                    yield return path;
                }

                path = this.EmitterEmitterData.EmitterEmitterShapeData.PrimitiveFilePath;
                if (string.IsNullOrEmpty(path) == false && this.EmitterEmitterData.EmitterEmitterShapeData.EmitterType == 15)
                {
                    yield return path;
                }
            }
        }

        /// <summary>
        /// Get the index of the custom shader the emitter uses.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("c14a98d9-afad-4650-8b5a-d75ef1a03a95")]
        public int CustomShaderIndex
        {
            get
            {
                return this.EmitterCustomShaderData.SelectedSettingIndex;
            }
        }

        /// <summary>
        /// 基本設定タブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9cea8a5b-1e28-4d86-8cdd-ad7ee5cf6988")]
        public EmitterBasicSettingData EmitterBasicSettingData
        {
            get { return this.GetDataModelFromField(ref this.emitterBasicSettingData, false); }
            set { this.SetDataModelToField(ref this.emitterBasicSettingData, value); }
        }

        /// <summary>
        /// 放出タブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4a5e8356-d75d-4364-9eb6-e0b1cb7de6af")]
        public EmitterEmissionData EmitterEmissionData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmissionData, false); }
            set { this.SetDataModelToField(ref this.emitterEmissionData, value); }
        }

        /// <summary>
        /// エミッタタブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("23df82b8-3b85-4848-ba0c-a9d72d86bc71")]
        public EmitterEmitterData EmitterEmitterData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmitterData, false); }
            set { this.SetDataModelToField(ref this.emitterEmitterData, value); }
        }

        /// <summary>
        /// パーティクルタブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("6ac7e463-f934-46e2-83e4-3afb64fe6fe8")]
        public EmitterParticleData EmitterParticleData
        {
            get { return this.GetDataModelFromField(ref this.emitterParticleData, false); }
            set { this.SetDataModelToField(ref this.emitterParticleData, value); }
        }

        /// <summary>
        /// コンバイナタブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8f364c8d-21da-4ddf-a7c8-c81a5b8d7980")]
        public EmitterCombinerData EmitterCombinerData
        {
            get { return this.GetDataModelFromField(ref this.emitterCombinerData, false); }
            set { this.SetDataModelToField(ref this.emitterCombinerData, value); }
        }

        /// <summary>
        /// テクスチャタブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0fc151b6-644a-4c23-8a6e-fd6ea1bed196")]
        public EmitterTextureGroupData Textures
        {
            get { return this.GetDataModelFromField(ref this.textures, false); }
            set { this.SetDataModelToField(ref this.textures, value); }
        }

        /// <summary>
        /// カラータブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("98ebb26e-d6c8-43c6-85d4-2392b9e528e6")]
        public EmitterColorGroupData EmitterColorData
        {
            get { return this.GetDataModelFromField(ref this.emitterColorData, false); }
            set { this.SetDataModelToField(ref this.emitterColorData, value); }
        }

        /// <summary>
        /// スケールタブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("37cb7fc7-b116-471d-962f-356775e4a42f")]
        public EmitterScaleData EmitterScaleData
        {
            get { return this.GetDataModelFromField(ref this.emitterScaleData, false); }
            set { this.SetDataModelToField(ref this.emitterScaleData, value); }
        }

        /// <summary>
        /// 回転タブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4b2d534d-9371-433b-a4bc-e202efd90b75")]
        public EmitterRotationData EmitterRotationData
        {
            get { return this.GetDataModelFromField(ref this.emitterRotationData, false); }
            set { this.SetDataModelToField(ref this.emitterRotationData, value); }
        }

        /// <summary>
        /// Get all the emitters by performing a recursive search through all the child emitters.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("a97ef49d-27dd-4f24-898e-ce1f06d07571")]
        public IEnumerable<EmitterData> AllChildEmitters
        {
            get
            {
                foreach (EmitterData item in this.EmitterList)
                {
                    yield return item;

                    foreach (EmitterData child in item.AllChildEmitters)
                    {
                        yield return child;
                    }
                }
            }
        }

        /// <summary>
        /// バイナリコンバートが有効なエミッタを再帰的に辿ったリストを取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("b53a20db-9db1-4ef2-a3b2-29a8b1d4802b")]
        public IEnumerable<EmitterData> AllActiveChildEmitters
        {
            get
            {
                foreach (EmitterData item in this.ActiveEmitterList)
                {
                    yield return item;

                    foreach (EmitterData child in item.AllActiveChildEmitters)
                    {
                        yield return child;
                    }
                }
            }
        }

        /// <summary>
        /// エミッタリストです
        /// </summary>
        [DataModelPropertyGuid("692d03e8-4727-435b-944f-73c8ca273cdb")]
        public List<EmitterData> EmitterList
        {
            get { return this.GetDataModelListFromField(ref this.emitterList); }
            set { this.SetDataModelListToField(ref this.emitterList, value); }
        }

        /// <summary>
        /// バイナリコンバートが有効なエミッタのリストを取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("1285e330-2915-4681-be2d-c1c814abf94f")]
        public IEnumerable<EmitterData> ActiveEmitterList
        {
            get
            {
                foreach (EmitterData item in this.EmitterList)
                {
                    if (item.EnableConvert == false)
                    {
                        continue;
                    }

                    yield return item;
                }
            }
        }

        /// <summary>
        /// フィールドリストです.
        /// </summary>
        [DataModelPropertyGuid("1f8c72df-e171-4bb4-99fa-038fe632c6ee")]
        public List<FieldDataBase> FieldList
        {
            get { return this.GetDataModelListFromField(ref this.fieldList); }
            set { this.SetDataModelListToField(ref this.fieldList, value); }
        }

        /// <summary>
        /// バイナリコンバートが有効なフィールドのリストを取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("5b83601a-5d32-476c-84cb-9ae09e1c07e0")]
        public IEnumerable<FieldDataBase> ActiveFieldList
        {
            get
            {
                foreach (FieldDataBase item in this.FieldList)
                {
                    if (item.EnableConvert == false)
                    {
                        continue;
                    }

                    yield return item;
                }
            }
        }

        /// <summary>
        /// ユーザーデータリストです.
        /// </summary>
        [DataModelPropertyGuid("dfb11720-db97-4b98-8ae1-3f30196575c0")]
        public List<UserPageData> UserDataList
        {
            get { return this.GetDataModelListFromField(ref this.userDataList); }
            set { this.SetDataModelListToField(ref this.userDataList, value); }
        }

        /// <summary>
        /// ストライプデータです.
        /// </summary>
        [DataModelPropertyGuid("32bbeca7-a2ce-42af-ab2d-09d485a230e3")]
        public StripeData StripeData
        {
            get { return this.GetDataModelFromField(ref this.stripeData, true); }
            set { this.SetDataModelToField(ref this.stripeData, value); }
        }

        /// <summary>
        /// カスタムシェーダーです
        /// </summary>
        [DataModelPropertyGuid("713597d3-8ab2-4f10-9df6-05c344a1b594")]
        public EmitterCustomShaderData EmitterCustomShaderData
        {
            get { return this.GetDataModelFromField(ref this.emitterCustomShaderData, false); }
            set { this.SetDataModelToField(ref this.emitterCustomShaderData, value); }
        }

        /// <summary>
        /// カスタムアクションノードデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3165a827-8785-4f7e-9f87-51e9dd450f7a")]
        public CustomActionData CustomActionData
        {
            get { return this.GetDataModelFromField(ref this.customActionData, true); }
            set { this.SetDataModelToField(ref this.customActionData, value); }
        }

        /// <summary>
        /// ストライプノードデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("db6b5f18-7ac5-4829-9b75-676ac87d538b")]
        public ReservedShaderNodeData ReservedShader
        {
            get { return this.GetDataModelFromField(ref this.reservedShader, true); }
            set { this.SetDataModelToField(ref this.reservedShader, value); }
        }

        /// <summary>
        /// バイナリコンバートが有効なReservedShaderを取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("5422149a-1c2c-4d4e-a5d0-bc8edeb11d36")]
        public ReservedShaderNodeData ActiveReservedShader
        {
            get
            {
                if (this.ReservedShader == null)
                {
                    return null;
                }

                if (this.ReservedShader.EnableConvert == false)
                {
                    return null;
                }

                return this.ReservedShader;
            }
        }

        /// <summary>
        /// Get the action custom action index.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("fd57aec3-9ecf-4d9c-b3dc-25f97635eb84")]
        public int SelectedCustomActionIndex
        {
            get
            {
                if (this.CustomActionData == null)
                {
                    return -1;
                }
                else
                {
                    return this.CustomActionData.SelectedSettingIndex;
                }
            }
        }

        /// <summary>
        /// Get the selected custom action data.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("cbe4243a-377e-4e22-ad44-ae452c7267b4")]
        public CustomActionSettingData SelectedCustomActionData
        {
            get
            {
                if (this.CustomActionData == null)
                {
                    return null;
                }
                else
                {
                    return this.CustomActionData.SelectedSettingData;
                }
            }
        }

        /// <summary>
        /// エミッタ拡張パラメータノードデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f2660733-077b-43c7-a566-a31b6c323863")]
        public EmitterExtParams EmitterExtParams
        {
            get { return this.GetDataModelFromField(ref this.emitterExtParams, true); }
            set { this.SetDataModelToField(ref this.emitterExtParams, value); }
        }

        /// <summary>
        /// Enumerate the file path of all the textures as value and their emitter name as key.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("9e01edf6-4636-4ac4-ac39-f6e763fbdd8a")]
        public IEnumerable<StringPair> EmitterNameAndTexturePaths
        {
            get
            {
                string path = this.Textures.Texture0.EmitterTextureFileData.FilePath;
                if (string.IsNullOrEmpty(path) == false)
                {
                    yield return new StringPair(this.Name, path);
                }

                path = this.Textures.Texture1.EmitterTextureFileData.FilePath;
                if (string.IsNullOrEmpty(path) == false)
                {
                    yield return new StringPair(this.Name, path);
                }

                path = this.Textures.Texture2.EmitterTextureFileData.FilePath;
                if (string.IsNullOrEmpty(path) == false)
                {
                    yield return new StringPair(this.Name, path);
                }
            }
        }

        /// <summary>
        /// Enumerate the file path of all the primitives as value and their emitter name as key.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("df3954f4-6313-4ee1-ad2f-575285672ae3")]
        public IEnumerable<StringPair> EmitterNameAndPrimitivePaths
        {
            get
            {
                string path = this.EmitterParticleData.EmitterParticleShapeData.PrimitiveFilePath;
                if (string.IsNullOrEmpty(path) == false && this.EmitterParticleData.EmitterParticleShapeData.ShapeType != 0)
                {
                    yield return new StringPair(this.Name, path);
                }

            }
        }

        /// <summary>
        /// 独自バイナリを利用するプリミティブのファイルパスと、そのエミッタ名のリスト
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e18e4cf9-c994-4280-b770-2047c000f1e7")]
        public IEnumerable<StringPair> EmitterNameAndOriginalPrimitivePaths
        {
            get
            {
                string path = this.EmitterEmitterData.EmitterEmitterShapeData.PrimitiveFilePath;
                if (string.IsNullOrEmpty(path) == false && this.EmitterEmitterData.EmitterEmitterShapeData.EmitterType == 15)
                {
                    yield return new StringPair(this.Name, path);
                }
            }
        }

        /// <summary>
        /// Enumerate the file path of all the primitives as value and their emitter name as key.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("425aa8e1-d7d7-4138-9d43-c96b09d7329f")]
        public IEnumerable<StringPair> EmitterNameAndTrimmingTexturePaths
        {
            get
            {
                string path = this.Textures.Texture0.EmitterTextureFileData.FilePath;
                if (string.IsNullOrEmpty(path) == false && this.EmitterParticleData.EmitterParticleShapeData.ShapeType == 0 && this.emitterParticleData.EmitterParticleShapeData.EnableTrimming == true)
                {
                    yield return new StringPair(this.Name, path);
                }
            }
        }

        /// <summary>
        /// 設定されているエミッタ時間アニメのリストです。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("bdec19c8-3bdb-44b2-8e8f-6a2d70486f81")]
        public IEnumerable<EmitterAnimationCommonData> ActiveEmitterAnimationList
        {
            get
            {
                if (this.EmitterScaleData.EmitterScaleBasicData.BasicScaleAnimation.EnableAnimation)
                {
                    yield return this.EmitterScaleData.EmitterScaleBasicData.BasicScaleAnimation;
                }

                var emitterTransform = this.EmitterEmitterData.EmitterEmitterTransformData;

                if (emitterTransform.EmitterScaleAnimation.EnableAnimation)
                {
                    yield return emitterTransform.EmitterScaleAnimation;
                }

                if (emitterTransform.EmitterRotationAnimation.EnableAnimation)
                {
                    yield return emitterTransform.EmitterRotationAnimation;
                }

                if (emitterTransform.EmitterPositionAnimation.EnableAnimation)
                {
                    yield return emitterTransform.EmitterPositionAnimation;
                }

                var emitterEmissionTiming = this.EmitterEmissionData.EmitterEmissionTimingData;

                if (emitterEmissionTiming.EmitTimeRateAnimation.EnableAnimation)
                {
                    yield return emitterEmissionTiming.EmitTimeRateAnimation;
                }

                var emitterEmissionVelocity = this.EmitterEmissionData.EmitterEmissionVelocityData;

                if (emitterEmissionVelocity.OmnidirectionalVelocityAnimation.EnableAnimation)
                {
                    yield return emitterEmissionVelocity.OmnidirectionalVelocityAnimation;
                }

                if (emitterEmissionVelocity.OrientedDirectionVelocityAnimation.EnableAnimation)
                {
                    yield return emitterEmissionVelocity.OrientedDirectionVelocityAnimation;
                }

                var emitterEmissionGravity = this.EmitterEmissionData.EmitterEmissionGravityData;

                if (emitterEmissionGravity.GravityAnimation.EnableAnimation)
                {
                    yield return emitterEmissionGravity.GravityAnimation;
                }

                var emitterParticleLife = this.EmitterParticleData.EmitterParticleLifeData;

                if (emitterParticleLife.LifeAnimation.EnableAnimation)
                {
                    yield return emitterParticleLife.LifeAnimation;
                }

                var emitterColor = this.EmitterColorData.EmitterColor;

                if (emitterColor.Color0BehaviorType == 2)
                {
                    yield return emitterColor.Color0Animation;
                }

                if (emitterColor.Color1BehaviorType == 2)
                {
                    yield return emitterColor.Color1Animation;
                }

                if (emitterColor.Alpha0BehaviorType == 2)
                {
                    yield return emitterColor.Alpha0Animation;
                }

                if (emitterColor.Alpha1BehaviorType == 2)
                {
                    yield return emitterColor.Alpha1Animation;
                }

                var emitterShape = this.EmitterEmitterData.EmitterEmitterShapeData;

                if (emitterShape.ShapeScaleAnimation.EnableAnimation)
                {
                    yield return emitterShape.ShapeScaleAnimation;
                }
            }
        }

        /// <summary>
        /// バイナライズ用のエミッタ拡張パラメータプロパティです。
        /// </summary>
        [DataModelPropertyGuid("43f1f93b-04a0-46fe-93a1-d7e6c450a665")]
        public EmitterExtParamsSettingData SelectedEmitterExtParams
        {
            get
            {
                if (this.EmitterExtParams == null)
                {
                    return null;
                }
                else
                {
                    return this.EmitterExtParams.EmitterExtParamsSettingData;
                }
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.EmitterBasicSettingData = srcDataModel.EmitterBasicSettingData;
            this.EmitterEmissionData = srcDataModel.EmitterEmissionData;
            this.EmitterEmitterData = srcDataModel.EmitterEmitterData;
            this.EmitterParticleData = srcDataModel.EmitterParticleData;
            this.EmitterCombinerData = srcDataModel.EmitterCombinerData;
            this.Textures = srcDataModel.Textures;
            this.EmitterColorData = srcDataModel.EmitterColorData;
            this.EmitterScaleData = srcDataModel.EmitterScaleData;
            this.EmitterRotationData = srcDataModel.EmitterRotationData;
            this.EmitterList = srcDataModel.EmitterList;
            this.FieldList = srcDataModel.FieldList;
            this.UserDataList = srcDataModel.UserDataList;
            this.StripeData = srcDataModel.StripeData;
            this.EmitterCustomShaderData = srcDataModel.EmitterCustomShaderData;
            this.CustomActionData = srcDataModel.CustomActionData;
            this.ReservedShader = srcDataModel.ReservedShader;
            this.EmitterExtParams = srcDataModel.EmitterExtParams;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Name", this.Name);
            this.WriteElement(context, "EmitterBasicSettingData", this.EmitterBasicSettingData);
            this.WriteElement(context, "EmitterEmissionData", this.EmitterEmissionData);
            this.WriteElement(context, "EmitterEmitterData", this.EmitterEmitterData);
            this.WriteElement(context, "EmitterParticleData", this.EmitterParticleData);
            this.WriteElement(context, "EmitterCombinerData", this.EmitterCombinerData);
            this.WriteElement(context, "Textures", this.Textures);
            this.WriteElement(context, "EmitterColorData", this.EmitterColorData);
            this.WriteElement(context, "EmitterScaleData", this.EmitterScaleData);
            this.WriteElement(context, "EmitterRotationData", this.EmitterRotationData);
            this.WriteEnumerableElement(context, "EmitterList", this.EmitterList);
            this.WriteEnumerableElement(context, "FieldList", this.FieldList);
            this.WriteEnumerableElement(context, "UserDataList", this.UserDataList);
            this.WriteElement(context, "StripeData", this.StripeData);
            this.WriteElement(context, "EmitterCustomShaderData", this.EmitterCustomShaderData);
            this.WriteElement(context, "CustomActionData", this.CustomActionData);
            this.WriteElement(context, "ReservedShader", this.ReservedShader);
            this.WriteElement(context, "EmitterExtParams", this.EmitterExtParams);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Name = this.ReadElement(context, "Name", this.Name);
            this.EmitterBasicSettingData = this.ReadElement(context, "EmitterBasicSettingData", this.EmitterBasicSettingData);
            this.EmitterEmissionData = this.ReadElement(context, "EmitterEmissionData", this.EmitterEmissionData);
            this.EmitterEmitterData = this.ReadElement(context, "EmitterEmitterData", this.EmitterEmitterData);
            this.EmitterParticleData = this.ReadElement(context, "EmitterParticleData", this.EmitterParticleData);
            this.EmitterCombinerData = this.ReadElement(context, "EmitterCombinerData", this.EmitterCombinerData);
            this.Textures = this.ReadElement(context, "Textures", this.Textures);
            this.EmitterColorData = this.ReadElement(context, "EmitterColorData", this.EmitterColorData);
            this.EmitterScaleData = this.ReadElement(context, "EmitterScaleData", this.EmitterScaleData);
            this.EmitterRotationData = this.ReadElement(context, "EmitterRotationData", this.EmitterRotationData);
            this.EmitterList = this.ReadListElement(context, "EmitterList", this.EmitterList);
            this.FieldList = this.ReadListElement(context, "FieldList", this.FieldList);
            this.UserDataList = this.ReadListElement(context, "UserDataList", this.UserDataList);
            this.StripeData = this.ReadElement(context, "StripeData", this.StripeData);
            this.EmitterCustomShaderData = this.ReadElement(context, "EmitterCustomShaderData", this.EmitterCustomShaderData);
            this.CustomActionData = this.ReadElement(context, "CustomActionData", this.CustomActionData);
            this.ReservedShader = this.ReadElement(context, "ReservedShader", this.ReservedShader);
            this.EmitterExtParams = this.ReadElement(context, "EmitterExtParams", this.EmitterExtParams);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterData(PrevVersion.EmitterData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.EmitterBasicSettingData = srcDataModel.EmitterBasicSettingData;
            this.EmitterEmissionData = srcDataModel.EmitterEmissionData;
            this.EmitterEmitterData = srcDataModel.EmitterEmitterData;
            this.EmitterParticleData = srcDataModel.EmitterParticleData;
            this.EmitterCombinerData = srcDataModel.EmitterCombinerData;
            this.Textures = srcDataModel.Textures;
            this.EmitterColorData = srcDataModel.EmitterColorData;
            this.EmitterScaleData = srcDataModel.EmitterScaleData;
            this.EmitterRotationData = srcDataModel.EmitterRotationData;
            this.EmitterList = srcDataModel.EmitterList.Select(dm => (CurrVersion.EmitterData)dm).ToList();
            this.FieldList = this.ConvertProperty_FieldList(srcDataModel);
            this.UserDataList = this.ConvertProperty_UserDataList(srcDataModel);
            this.StripeData = srcDataModel.StripeData;
            this.EmitterCustomShaderData = srcDataModel.EmitterCustomShaderData;
            this.CustomActionData = srcDataModel.CustomActionData;
            this.ReservedShader = srcDataModel.ReservedShader;
            this.EmitterExtParams = srcDataModel.EmitterExtParams;

            return true;
        }

        /// <summary>
        /// Convert FieldList property from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The converted value.</returns>
        public List<FieldDataBase> ConvertProperty_FieldList(PrevVersion.EmitterData src)
        {
            return src.FieldList.Select(
                dm => (FieldDataBase)CurrVersionSerializer.DataModelSerializer.Instance.UpgradeDataModel(dm)).ToList();
        }

        /// <summary>
        /// Convert UserDataList property from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The converted value.</returns>
        public List<UserPageData> ConvertProperty_UserDataList(PrevVersion.EmitterData src)
        {
            return src.UserDataList;
        }
    }
}
