﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_6;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/基本設定タブ/LODグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterBasicLodData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterBasicLodData() :
            base()
        {
            this.EmissionRangeNear = 0.0f;
            this.EmissionRangeFar = -1.0f;
            this.TestAlways = false;
            this.InterpolateEmissionAmount = false;
            this.EmissionRatioFar = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// 放出範囲近距離を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4cf33665-6f80-469e-a217-ae555e287df9")]
        public float EmissionRangeNear { get; set; }

        /// <summary>
        /// 放出範囲遠距離を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("eb544911-5c6d-492a-861d-1fe93ad0bb17")]
        public float EmissionRangeFar { get; set; }

        /// <summary>
        /// 常時判定のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("90d7f38f-adda-49b9-94bc-3416f31627b0")]
        public bool TestAlways { get; set; }

        /// <summary>
        /// 放出量を補間のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8267f9d4-e5d1-48ab-8bb9-84b464909efe")]
        public bool InterpolateEmissionAmount { get; set; }

        /// <summary>
        /// 遠距離での割合を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7c708af2-eb91-4e56-b70e-9d716bc66520")]
        public int EmissionRatioFar { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterBasicLodData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmissionRangeNear = srcDataModel.EmissionRangeNear;
            this.EmissionRangeFar = srcDataModel.EmissionRangeFar;
            this.TestAlways = srcDataModel.TestAlways;
            this.InterpolateEmissionAmount = srcDataModel.InterpolateEmissionAmount;
            this.EmissionRatioFar = srcDataModel.EmissionRatioFar;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmissionRangeNear", this.EmissionRangeNear);
            this.WriteElement(context, "EmissionRangeFar", this.EmissionRangeFar);
            this.WriteElement(context, "TestAlways", this.TestAlways);
            this.WriteElement(context, "InterpolateEmissionAmount", this.InterpolateEmissionAmount);
            this.WriteElement(context, "EmissionRatioFar", this.EmissionRatioFar);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmissionRangeNear = this.ReadElement(context, "EmissionRangeNear", this.EmissionRangeNear);
            this.EmissionRangeFar = this.ReadElement(context, "EmissionRangeFar", this.EmissionRangeFar);
            this.TestAlways = this.ReadElement(context, "TestAlways", this.TestAlways);
            this.InterpolateEmissionAmount = this.ReadElement(context, "InterpolateEmissionAmount", this.InterpolateEmissionAmount);
            this.EmissionRatioFar = this.ReadElement(context, "EmissionRatioFar", this.EmissionRatioFar);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterBasicLodData(PrevVersion.EmitterBasicLodData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterBasicLodData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterBasicLodData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmissionRangeNear = srcDataModel.EmissionRangeNear;
            this.EmissionRangeFar = srcDataModel.EmissionRangeFar;
            this.TestAlways = srcDataModel.TestAlways;
            this.InterpolateEmissionAmount = srcDataModel.InterpolateEmissionAmount;
            this.EmissionRatioFar = srcDataModel.EmissionRatioFar;

            return true;
        }
    }
}
