﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_5;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/基本設定タブ/シーングループです。
    /// </summary>
    [Serializable]
    public class ViewerBasicSceneData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerBasicSceneData() :
            base()
        {
            this.FrameRate = 1.0f;
            this.IsLinearMode = true;
            this.DisplayGrid = true;
            this.GridType = 0;
            this.DisplayDebugInformation = true;
            this.DisplayGpuProfile = false;
            this.EnablePad = true;
            this.DisplayParentEmitterShape = false;
            this.DisplayChildEmitterShape = false;
            this.DisplayFieldShape = false;
            this.RestrainViewrWarnings = false;

            this.PostConstruct();
        }

        /// <summary>
        /// フレームレートを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("884bf906-1450-4e8d-8810-9cf8527e63c4")]
        public float FrameRate { get; set; }

        /// <summary>
        /// リニアモードです。
        /// </summary>
        [DataModelPropertyGuid("34362ed2-2d30-4c07-a9ef-254d0e34ef9d")]
        public bool IsLinearMode { get; set; }

        /// <summary>
        /// グリッド表示の On/Off を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("17632e8d-fbc9-4dab-8f0d-612203313d1c")]
        public bool DisplayGrid { get; set; }

        /// <summary>
        /// グリッドタイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("89944c6f-9ab7-4943-adc4-24b9f8443096")]
        public int GridType { get; set; }

        /// <summary>
        /// デバッグ情報の表示の On/Off を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("026fd5a5-e0a2-462e-94f4-3d7c0c601544")]
        public bool DisplayDebugInformation { get; set; }

        /// <summary>
        /// GPU 処理の計測結果の表示の On/Off を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9dd998da-594d-4c98-9f9b-30150a8a589a")]
        public bool DisplayGpuProfile { get; set; }

        /// <summary>
        /// Pad の On/Off を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("93ead31b-b115-4ea0-820d-fe61a49cc323")]
        public bool EnablePad { get; set; }

        /// <summary>
        /// 親エミッタ形状表示の On/Off を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("48cfe8cc-5ce1-4966-bf81-e78dac50df95")]
        public bool DisplayParentEmitterShape { get; set; }

        /// <summary>
        /// 子エミッタ形状表示の On/Off を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a84e5cf0-b901-4401-9e68-c5e4737fa9c0")]
        public bool DisplayChildEmitterShape { get; set; }

        /// <summary>
        /// フィールド形状表示の On/Off を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9dd7c295-00ce-4b96-861a-c890390d609b")]
        public bool DisplayFieldShape { get; set; }

        /// <summary>
        /// ビューア警告の抑制の On/Off を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("68508c58-ce0b-4b72-b139-40dd38150113")]
        public bool RestrainViewrWarnings { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ViewerBasicSceneData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.FrameRate = srcDataModel.FrameRate;
            this.IsLinearMode = srcDataModel.IsLinearMode;
            this.DisplayGrid = srcDataModel.DisplayGrid;
            this.GridType = srcDataModel.GridType;
            this.DisplayDebugInformation = srcDataModel.DisplayDebugInformation;
            this.DisplayGpuProfile = srcDataModel.DisplayGpuProfile;
            this.EnablePad = srcDataModel.EnablePad;
            this.DisplayParentEmitterShape = srcDataModel.DisplayParentEmitterShape;
            this.DisplayChildEmitterShape = srcDataModel.DisplayChildEmitterShape;
            this.DisplayFieldShape = srcDataModel.DisplayFieldShape;
            this.RestrainViewrWarnings = srcDataModel.RestrainViewrWarnings;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "FrameRate", this.FrameRate);
            this.WriteElement(context, "IsLinearMode", this.IsLinearMode);
            this.WriteElement(context, "DisplayGrid", this.DisplayGrid);
            this.WriteElement(context, "GridType", this.GridType);
            this.WriteElement(context, "DisplayDebugInformation", this.DisplayDebugInformation);
            this.WriteElement(context, "DisplayGpuProfile", this.DisplayGpuProfile);
            this.WriteElement(context, "EnablePad", this.EnablePad);
            this.WriteElement(context, "DisplayParentEmitterShape", this.DisplayParentEmitterShape);
            this.WriteElement(context, "DisplayChildEmitterShape", this.DisplayChildEmitterShape);
            this.WriteElement(context, "DisplayFieldShape", this.DisplayFieldShape);
            this.WriteElement(context, "RestrainViewrWarnings", this.RestrainViewrWarnings);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.FrameRate = this.ReadElement(context, "FrameRate", this.FrameRate);
            this.IsLinearMode = this.ReadElement(context, "IsLinearMode", this.IsLinearMode);
            this.DisplayGrid = this.ReadElement(context, "DisplayGrid", this.DisplayGrid);
            this.GridType = this.ReadElement(context, "GridType", this.GridType);
            this.DisplayDebugInformation = this.ReadElement(context, "DisplayDebugInformation", this.DisplayDebugInformation);
            this.DisplayGpuProfile = this.ReadElement(context, "DisplayGpuProfile", this.DisplayGpuProfile);
            this.EnablePad = this.ReadElement(context, "EnablePad", this.EnablePad);
            this.DisplayParentEmitterShape = this.ReadElement(context, "DisplayParentEmitterShape", this.DisplayParentEmitterShape);
            this.DisplayChildEmitterShape = this.ReadElement(context, "DisplayChildEmitterShape", this.DisplayChildEmitterShape);
            this.DisplayFieldShape = this.ReadElement(context, "DisplayFieldShape", this.DisplayFieldShape);
            this.RestrainViewrWarnings = this.ReadElement(context, "RestrainViewrWarnings", this.RestrainViewrWarnings);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.ViewerBasicSceneData(PrevVersion.ViewerBasicSceneData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.ViewerBasicSceneData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.ViewerBasicSceneData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.FrameRate = srcDataModel.FrameRate;
            this.IsLinearMode = srcDataModel.IsLinearMode;
            this.GridType = srcDataModel.GridType;

            return true;
        }
    }
}
