﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.ObjectModel;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_5;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// SRT制御のデータモデル.
    /// </summary>
    [Serializable]
    public class PreviewMatrixData : DataModelBase
    {
        /// <summary>
        /// 行列設定データです。
        /// </summary>
        private PreviewMatrixMatrixSettingsData previewMatrixMatrixSettingsData = null;

        /// <summary>
        /// モデル接続データです。
        /// </summary>
        private PreviewMatrixModelRelationData previewMatrixModelRelationData = null;

        /// <summary>
        /// オフセットデータです。
        /// </summary>
        private PreviewMatrixOffsetMatrixData previewMatrixOffsetMatrixData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewMatrixData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// 行列設定データです。
        /// </summary>
        [DataModelPropertyGuid("4a4e5f57-bcad-427e-9e47-965d7931382c")]
        public PreviewMatrixMatrixSettingsData PreviewMatrixMatrixSettingsData
        {
            get { return this.GetDataModelFromField(ref this.previewMatrixMatrixSettingsData, false); }
            set { this.SetDataModelToField(ref this.previewMatrixMatrixSettingsData, value); }
        }

        /// <summary>
        /// モデル接続データです。
        /// </summary>
        [DataModelPropertyGuid("84696848-5f46-4704-9111-50277515d92d")]
        public PreviewMatrixModelRelationData PreviewMatrixModelRelationData
        {
            get { return this.GetDataModelFromField(ref this.previewMatrixModelRelationData, false); }
            set { this.SetDataModelToField(ref this.previewMatrixModelRelationData, value); }
        }

        /// <summary>
        /// オフセットデータです。
        /// </summary>
        [DataModelPropertyGuid("89028b9f-3d9d-43a8-82cc-460d6f09cba9")]
        public PreviewMatrixOffsetMatrixData PreviewMatrixOffsetMatrixData
        {
            get { return this.GetDataModelFromField(ref this.previewMatrixOffsetMatrixData, false); }
            set { this.SetDataModelToField(ref this.previewMatrixOffsetMatrixData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewMatrixData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.PreviewMatrixMatrixSettingsData = srcDataModel.PreviewMatrixMatrixSettingsData;
            this.PreviewMatrixModelRelationData = srcDataModel.PreviewMatrixModelRelationData;
            this.PreviewMatrixOffsetMatrixData = srcDataModel.PreviewMatrixOffsetMatrixData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "PreviewMatrixMatrixSettingsData", this.PreviewMatrixMatrixSettingsData);
            this.WriteElement(context, "PreviewMatrixModelRelationData", this.PreviewMatrixModelRelationData);
            this.WriteElement(context, "PreviewMatrixOffsetMatrixData", this.PreviewMatrixOffsetMatrixData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.PreviewMatrixMatrixSettingsData = this.ReadElement(context, "PreviewMatrixMatrixSettingsData", this.PreviewMatrixMatrixSettingsData);
            this.PreviewMatrixModelRelationData = this.ReadElement(context, "PreviewMatrixModelRelationData", this.PreviewMatrixModelRelationData);
            this.PreviewMatrixOffsetMatrixData = this.ReadElement(context, "PreviewMatrixOffsetMatrixData", this.PreviewMatrixOffsetMatrixData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.PreviewMatrixData(PrevVersion.PreviewMatrixData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.PreviewMatrixData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.PreviewMatrixData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.PreviewMatrixMatrixSettingsData = srcDataModel.PreviewMatrixMatrixSettingsData;
            this.PreviewMatrixModelRelationData = srcDataModel.PreviewMatrixModelRelationData;
            this.PreviewMatrixOffsetMatrixData = srcDataModel.PreviewMatrixOffsetMatrixData;

            return true;
        }
    }
}
