﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_5;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// 自動移動.
    /// </summary>
    [Serializable]
    public class PreviewAutoMoveData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewAutoMoveData() :
            base()
        {
            this.MoveType = 0;
            this.MoveRadiusXZ = 8.0f;
            this.MoveSpeedXZ = 1.0f;
            this.ShakeAmplitudeY = 0.0f;
            this.ShakeSpeedY = 5.0f;
            this.RollSpeedZ = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// 自動移動タイプ
        /// </summary>
        [DataModelPropertyGuid("adac800f-172f-42f7-b959-891ae2b9d314")]
        public int MoveType { get; set; }

        /// <summary>
        /// XZ移動半径
        /// </summary>
        [DataModelPropertyGuid("fa26a663-1d8d-48a0-9437-642a37a1678e")]
        public float MoveRadiusXZ { get; set; }

        /// <summary>
        /// XZ移動速度.
        /// </summary>
        [DataModelPropertyGuid("f8b9ab81-df61-4689-a31e-a556df040551")]
        public float MoveSpeedXZ { get; set; }

        /// <summary>
        /// Y揺れ振幅
        /// </summary>
        [DataModelPropertyGuid("93e16459-d576-4ce5-af5e-707b43b853a9")]
        public float ShakeAmplitudeY { get; set; }

        /// <summary>
        /// Y揺れ速度
        /// </summary>
        [DataModelPropertyGuid("12dae9ab-66ec-4cb8-ae0b-9c4b4135abed")]
        public float ShakeSpeedY { get; set; }

        /// <summary>
        /// Zロール速度
        /// </summary>
        [DataModelPropertyGuid("3847865c-3c85-4b1f-9847-694f6d3499f1")]
        public float RollSpeedZ { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewAutoMoveData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.MoveType = srcDataModel.MoveType;
            this.MoveRadiusXZ = srcDataModel.MoveRadiusXZ;
            this.MoveSpeedXZ = srcDataModel.MoveSpeedXZ;
            this.ShakeAmplitudeY = srcDataModel.ShakeAmplitudeY;
            this.ShakeSpeedY = srcDataModel.ShakeSpeedY;
            this.RollSpeedZ = srcDataModel.RollSpeedZ;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "MoveType", this.MoveType);
            this.WriteElement(context, "MoveRadiusXZ", this.MoveRadiusXZ);
            this.WriteElement(context, "MoveSpeedXZ", this.MoveSpeedXZ);
            this.WriteElement(context, "ShakeAmplitudeY", this.ShakeAmplitudeY);
            this.WriteElement(context, "ShakeSpeedY", this.ShakeSpeedY);
            this.WriteElement(context, "RollSpeedZ", this.RollSpeedZ);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.MoveType = this.ReadElement(context, "MoveType", this.MoveType);
            this.MoveRadiusXZ = this.ReadElement(context, "MoveRadiusXZ", this.MoveRadiusXZ);
            this.MoveSpeedXZ = this.ReadElement(context, "MoveSpeedXZ", this.MoveSpeedXZ);
            this.ShakeAmplitudeY = this.ReadElement(context, "ShakeAmplitudeY", this.ShakeAmplitudeY);
            this.ShakeSpeedY = this.ReadElement(context, "ShakeSpeedY", this.ShakeSpeedY);
            this.RollSpeedZ = this.ReadElement(context, "RollSpeedZ", this.RollSpeedZ);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.PreviewAutoMoveData(PrevVersion.PreviewAutoMoveData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.PreviewAutoMoveData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.PreviewAutoMoveData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.MoveType = srcDataModel.MoveType;
            this.MoveRadiusXZ = srcDataModel.MoveRadiusXZ;
            this.MoveSpeedXZ = srcDataModel.MoveSpeedXZ;
            this.ShakeAmplitudeY = srcDataModel.ShakeAmplitudeY;
            this.ShakeSpeedY = srcDataModel.ShakeSpeedY;
            this.RollSpeedZ = srcDataModel.RollSpeedZ;

            return true;
        }
    }
}
