﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_5;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/GPUノイズタブ/基本設定グループデータです。
    /// </summary>
    [Serializable]
    public class RandomBasicSetting : DataModelBase
    {
        /// <summary>
        /// ノイズの強さを取得または設定します。
        /// </summary>
        private Vector3f randomVel = null;

        /// <summary>
        /// ノイズの強さのパーティクル時間アニメを取得または設定します。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public RandomBasicSetting() :
            base()
        {
            this.RandomVel = new Vector3f(2.0f, 2.0f, 2.0f);
            this.EnableAnimation = 0;
            this.EnableAirRegist = true;
            this.BaseFrequency = 1000;
            this.AnimationTable = new AnimationTableData(new AnimationTableData(0, 0.0f, 0.0f, 0.0f, 0.0f));
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// ノイズの強さを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("fa047502-ca68-4e12-8972-89b9853499c4")]
        public Vector3f RandomVel
        {
            get { return this.GetObjectFromField(ref this.randomVel, false); }
            set { this.SetISettableToField(ref this.randomVel, value); }
        }

        /// <summary>
        /// ノイズの強さのパーティクル時間アニメのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3fa94b91-e1b2-434b-b9d3-163c8c7c9be2")]
        public int EnableAnimation { get; set; }

        /// <summary>
        /// 「空気抵抗」を加味のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("85bd3be0-f8ad-41ab-832a-c604e649b505")]
        public bool EnableAirRegist { get; set; }

        /// <summary>
        /// 基本周期を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("03fafded-212e-4544-8985-23b8c7ea8302")]
        public int BaseFrequency { get; set; }

        /// <summary>
        /// ノイズの強さのパーティクル時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("36cfd537-a0f5-4941-b517-058e85f40bfe")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// ノイズの強さのパーティクル時間アニメについて再生方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4a60dd4a-143b-412e-b00f-753c75742c8e")]
        public int LoopMode { get; set; }

        /// <summary>
        /// ノイズの強さのパーティクル時間アニメについて終端フレームを取得または設定します。
        /// 再生方法をループ再生にしたときに使用します。
        /// </summary>
        [DataModelPropertyGuid("9759b009-382a-4439-82c2-073fdca8e791")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// ノイズの強さのエミッタ時間アニメについて開始位置のランダムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c3b437c0-394a-4bad-961e-e27dd6b194bf")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.RandomBasicSetting;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.RandomVel = srcDataModel.RandomVel;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.EnableAirRegist = srcDataModel.EnableAirRegist;
            this.BaseFrequency = srcDataModel.BaseFrequency;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "RandomVel", this.RandomVel);
            this.WriteElement(context, "EnableAnimation", this.EnableAnimation);
            this.WriteElement(context, "EnableAirRegist", this.EnableAirRegist);
            this.WriteElement(context, "BaseFrequency", this.BaseFrequency);
            this.WriteElement(context, "AnimationTable", this.AnimationTable);
            this.WriteElement(context, "LoopMode", this.LoopMode);
            this.WriteElement(context, "LoopEnd", this.LoopEnd);
            this.WriteElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.RandomVel = this.ReadElement(context, "RandomVel", this.RandomVel);
            this.EnableAnimation = this.ReadElement(context, "EnableAnimation", this.EnableAnimation);
            this.EnableAirRegist = this.ReadElement(context, "EnableAirRegist", this.EnableAirRegist);
            this.BaseFrequency = this.ReadElement(context, "BaseFrequency", this.BaseFrequency);
            this.AnimationTable = this.ReadElement(context, "AnimationTable", this.AnimationTable);
            this.LoopMode = this.ReadElement(context, "LoopMode", this.LoopMode);
            this.LoopEnd = this.ReadElement(context, "LoopEnd", this.LoopEnd);
            this.Randomize = this.ReadElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.RandomBasicSetting(PrevVersion.RandomBasicSetting src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.RandomBasicSetting();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.RandomBasicSetting;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.RandomVel = srcDataModel.RandomVel;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.EnableAirRegist = srcDataModel.EnableAirRegist;
            this.BaseFrequency = srcDataModel.BaseFrequency;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
