﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_4;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// カスタムフィールドデータです。
    /// </summary>
    [Serializable]
    public class CustomFieldData : FieldDataBase
    {
        /// <summary>
        /// カスタムフィールドのフラグデータです。
        /// </summary>
        private CustomFieldFlagData flagData = null;

        /// <summary>
        /// カスタムフィールドの数値データです。
        /// </summary>
        private CustomFieldValueData valueData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CustomFieldData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// カスタムフィールドのフラグデータです。
        /// </summary>
        [DataModelPropertyGuid("fc6c5dd0-eebc-48b5-bcfd-6fc5f6c1c1c8")]
        public CustomFieldFlagData FlagData
        {
            get { return this.GetDataModelFromField(ref this.flagData, false); }
            set { this.SetDataModelToField(ref this.flagData, value); }
        }

        /// <summary>
        /// カスタムフィールドの数値データです。
        /// </summary>
        [DataModelPropertyGuid("aeeca1e4-932d-4cfa-9016-913b94f4f698")]
        public CustomFieldValueData ValueData
        {
            get { return this.GetDataModelFromField(ref this.valueData, false); }
            set { this.SetDataModelToField(ref this.valueData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.CustomFieldData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.FlagData = srcDataModel.FlagData;
            this.ValueData = srcDataModel.ValueData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "FlagData", this.FlagData);
            this.WriteElement(context, "ValueData", this.ValueData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.FlagData = this.ReadElement(context, "FlagData", this.FlagData);
            this.ValueData = this.ReadElement(context, "ValueData", this.ValueData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.CustomFieldData(PrevVersion.CustomFieldData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.CustomFieldData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.CustomFieldData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.FlagData = srcDataModel.FlagData;
            this.ValueData = srcDataModel.ValueData;

            return true;
        }
    }
}
