﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/スケールタブデータです。
    /// </summary>
    [Serializable]
    public class EmitterScaleData : DataModelBase
    {
        /// <summary>
        /// 基本スケールグループデータです。
        /// </summary>
        private EmitterScaleBasicData emitterScaleBasicData = null;

        /// <summary>
        /// その他のスケール設定グループデータです。
        /// </summary>
        private EmitterScaleAdditionalAnimationData emitterScaleAnimationData = null;

        /// <summary>
        /// スケール（パーティクル時間アニメ）グループデータです。
        /// </summary>
        private EmitterScaleAnimationCurveData emitterScaleAnimationCurveData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterScaleData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// 基本スケールグループデータです。
        /// </summary>
        [DataModelPropertyGuid("74ae5f08-2811-4691-a876-8442437b23d5")]
        public EmitterScaleBasicData EmitterScaleBasicData
        {
            get { return this.GetDataModelFromField(ref this.emitterScaleBasicData, false); }
            set { this.SetDataModelToField(ref this.emitterScaleBasicData, value); }
        }

        /// <summary>
        /// その他のスケール設定グループデータです。
        /// </summary>
        [DataModelPropertyGuid("85c22f3c-f206-4be6-996c-76d8afaf3559")]
        public EmitterScaleAdditionalAnimationData EmitterScaleAnimationData
        {
            get { return this.GetDataModelFromField(ref this.emitterScaleAnimationData, false); }
            set { this.SetDataModelToField(ref this.emitterScaleAnimationData, value); }
        }

        /// <summary>
        /// スケール（パーティクル時間アニメ）グループデータです。
        /// </summary>
        [DataModelPropertyGuid("2852f154-33a8-457f-95b5-b68b9dc08387")]
        public EmitterScaleAnimationCurveData EmitterScaleAnimationCurveData
        {
            get { return this.GetDataModelFromField(ref this.emitterScaleAnimationCurveData, false); }
            set { this.SetDataModelToField(ref this.emitterScaleAnimationCurveData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterScaleData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterScaleBasicData = srcDataModel.EmitterScaleBasicData;
            this.EmitterScaleAnimationData = srcDataModel.EmitterScaleAnimationData;
            this.EmitterScaleAnimationCurveData = srcDataModel.EmitterScaleAnimationCurveData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterScaleBasicData", this.EmitterScaleBasicData);
            this.WriteElement(context, "EmitterScaleAnimationData", this.EmitterScaleAnimationData);
            this.WriteElement(context, "EmitterScaleAnimationCurveData", this.EmitterScaleAnimationCurveData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterScaleBasicData = this.ReadElement(context, "EmitterScaleBasicData", this.EmitterScaleBasicData);
            this.EmitterScaleAnimationData = this.ReadElement(context, "EmitterScaleAnimationData", this.EmitterScaleAnimationData);
            this.EmitterScaleAnimationCurveData = this.ReadElement(context, "EmitterScaleAnimationCurveData", this.EmitterScaleAnimationCurveData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterScaleData(PrevVersion.EmitterScaleData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterScaleData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterScaleData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterScaleBasicData = srcDataModel.EmitterScaleBasicData;
            this.EmitterScaleAnimationData = srcDataModel.EmitterScaleAnimationData;
            this.EmitterScaleAnimationCurveData = srcDataModel.EmitterScaleAnimationCurveData;

            return true;
        }
    }
}
