﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/スケールタブ/基本スケールグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterScaleBasicData : DataModelBase
    {
        /// <summary>
        /// 基準値を取得または設定します。
        /// </summary>
        private Vector3f scaleBasisValue = null;

        /// <summary>
        /// ランダム量(%)を取得または設定します。
        /// </summary>
        private Vector3f scaleBasisRandom = null;

        /// <summary>
        /// 基準値のエミッタ時間アニメを取得または設定します。
        /// </summary>
        private EmitterAnimationCommonData basicScaleAnimation = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterScaleBasicData() :
            base()
        {
            this.ScaleBasisValue = new Vector3f(1.0f, 1.0f ,1.0f);
            this.ScaleBasisRandom = new Vector3f(0.0f, 0.0f, 0.0f);
            this.ScaleBasisRandomOption = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// 基準値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f4086782-7479-44c8-845a-03b7cc4f0330")]
        public Vector3f ScaleBasisValue
        {
            get { return this.GetObjectFromField(ref this.scaleBasisValue, false); }
            set { this.SetISettableToField(ref this.scaleBasisValue, value); }
        }

        /// <summary>
        /// ランダム量(%)を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("18eb284d-9076-48cd-8ee7-c90ee0974d43")]
        public Vector3f ScaleBasisRandom
        {
            get { return this.GetObjectFromField(ref this.scaleBasisRandom, false); }
            set { this.SetISettableToField(ref this.scaleBasisRandom, value); }
        }

        /// <summary>
        /// 寿命ランダムです.
        /// </summary>
        [DataModelPropertyGuid("61f07141-d05d-4aab-8c6b-f60c00669959")]
        public int ScaleBasisRandomOption { get; set; }

        /// <summary>
        /// 基準値のエミッタ時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("16d6b881-7595-4107-bbf9-36be1c0b8364")]
        public EmitterAnimationCommonData BasicScaleAnimation
        {
            get { return this.GetDataModelFromField(ref this.basicScaleAnimation, false); }
            set { this.SetDataModelToField(ref this.basicScaleAnimation, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterScaleBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ScaleBasisValue = srcDataModel.ScaleBasisValue;
            this.ScaleBasisRandom = srcDataModel.ScaleBasisRandom;
            this.ScaleBasisRandomOption = srcDataModel.ScaleBasisRandomOption;
            this.BasicScaleAnimation = srcDataModel.BasicScaleAnimation;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ScaleBasisValue", this.ScaleBasisValue);
            this.WriteElement(context, "ScaleBasisRandom", this.ScaleBasisRandom);
            this.WriteElement(context, "ScaleBasisRandomOption", this.ScaleBasisRandomOption);
            this.WriteElement(context, "BasicScaleAnimation", this.BasicScaleAnimation);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ScaleBasisValue = this.ReadElement(context, "ScaleBasisValue", this.ScaleBasisValue);
            this.ScaleBasisRandom = this.ReadElement(context, "ScaleBasisRandom", this.ScaleBasisRandom);
            this.ScaleBasisRandomOption = this.ReadElement(context, "ScaleBasisRandomOption", this.ScaleBasisRandomOption);
            this.BasicScaleAnimation = this.ReadElement(context, "BasicScaleAnimation", this.BasicScaleAnimation);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterScaleBasicData(PrevVersion.EmitterScaleBasicData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterScaleBasicData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterScaleBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ScaleBasisValue = srcDataModel.ScaleBasisValue;
            this.ScaleBasisRandom = srcDataModel.ScaleBasisRandom;
            this.ScaleBasisRandomOption = srcDataModel.ScaleBasisRandomOption;
            this.BasicScaleAnimation = srcDataModel.BasicScaleAnimation;

            return true;
        }
    }
}
