﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/回転タブ/回転軸Yグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterRotationYData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterRotationYData() :
            base()
        {
            this.InitialRotation = 0.0f;
            this.InitialRotationRandom = 0.0f;
            this.EnableRotationRandom = false;
            this.RotationSpeed = 0.0f;
            this.RotationSpeedRandom = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// 初期回転の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2c2a1be3-cad2-4ac7-bf79-06050964c05b")]
        public float InitialRotation { get; set; }

        /// <summary>
        /// 初期回転のランダム幅を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1a226c00-d732-4313-b825-47671e8a04d0")]
        public float InitialRotationRandom { get; set; }

        /// <summary>
        /// 回転方向ランダムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("966aa19d-9a98-4691-837b-509702f76fc5")]
        public bool EnableRotationRandom { get; set; }

        /// <summary>
        /// 回転速度を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("cad0cd41-45ee-4f20-9823-79de97ff95c9")]
        public float RotationSpeed { get; set; }

        /// <summary>
        /// 回転速度のランダム幅を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3691a4ea-fa0a-4257-8c39-da933701f0b2")]
        public float RotationSpeedRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterRotationYData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.InitialRotation = srcDataModel.InitialRotation;
            this.InitialRotationRandom = srcDataModel.InitialRotationRandom;
            this.EnableRotationRandom = srcDataModel.EnableRotationRandom;
            this.RotationSpeed = srcDataModel.RotationSpeed;
            this.RotationSpeedRandom = srcDataModel.RotationSpeedRandom;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "InitialRotation", this.InitialRotation);
            this.WriteElement(context, "InitialRotationRandom", this.InitialRotationRandom);
            this.WriteElement(context, "EnableRotationRandom", this.EnableRotationRandom);
            this.WriteElement(context, "RotationSpeed", this.RotationSpeed);
            this.WriteElement(context, "RotationSpeedRandom", this.RotationSpeedRandom);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.InitialRotation = this.ReadElement(context, "InitialRotation", this.InitialRotation);
            this.InitialRotationRandom = this.ReadElement(context, "InitialRotationRandom", this.InitialRotationRandom);
            this.EnableRotationRandom = this.ReadElement(context, "EnableRotationRandom", this.EnableRotationRandom);
            this.RotationSpeed = this.ReadElement(context, "RotationSpeed", this.RotationSpeed);
            this.RotationSpeedRandom = this.ReadElement(context, "RotationSpeedRandom", this.RotationSpeedRandom);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterRotationYData(PrevVersion.EmitterRotationYData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterRotationYData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterRotationYData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.InitialRotation = srcDataModel.InitialRotation;
            this.InitialRotationRandom = srcDataModel.InitialRotationRandom;
            this.EnableRotationRandom = srcDataModel.EnableRotationRandom;
            this.RotationSpeed = srcDataModel.RotationSpeed;
            this.RotationSpeedRandom = srcDataModel.RotationSpeedRandom;

            return true;
        }
    }
}
