﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/コンバイナタブ/シェーダコンバイナツールグループのアニメーションデータです。
    /// </summary>
    [Serializable]
    public class EmitterCombinerEditorAnimationCurveData : DataModelBase
    {
        /// <summary>
        /// アニメーションテーブルです。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCombinerEditorAnimationCurveData() :
            base()
        {
            this.AnimationTable = new AnimationTableData(new AnimationTableData(0, 0.0f, 0.0f, 0.0f, 0.0f));
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// アニメーションテーブルです。
        /// </summary>
        [DataModelPropertyGuid("f56be7de-c309-422d-988f-591004c2b353")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// ループモードです。
        /// </summary>
        [DataModelPropertyGuid("a971b1ad-3194-4487-81bd-4455c7aaa652")]
        public int LoopMode { get; set; }

        /// <summary>
        /// ループ終端フレームです。
        /// </summary>
        [DataModelPropertyGuid("3e304463-a7ec-4158-a7c3-d835b6afc330")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// ランダム化です。
        /// </summary>
        [DataModelPropertyGuid("4e3904bc-70f5-4756-80cc-633e26c827e0")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterCombinerEditorAnimationCurveData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "AnimationTable", this.AnimationTable);
            this.WriteElement(context, "LoopMode", this.LoopMode);
            this.WriteElement(context, "LoopEnd", this.LoopEnd);
            this.WriteElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.AnimationTable = this.ReadElement(context, "AnimationTable", this.AnimationTable);
            this.LoopMode = this.ReadElement(context, "LoopMode", this.LoopMode);
            this.LoopEnd = this.ReadElement(context, "LoopEnd", this.LoopEnd);
            this.Randomize = this.ReadElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterCombinerEditorAnimationCurveData(PrevVersion.EmitterCombinerEditorAnimationCurveData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterCombinerEditorAnimationCurveData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterCombinerEditorAnimationCurveData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
