﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_2;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/基本設定タブです。
    /// </summary>
    [Serializable]
    public class ViewerBasicData : DataModelBase
    {
        /// <summary>
        /// シーングループです。
        /// </summary>
        private ViewerBasicSceneData sceneData = null;

        /// <summary>
        /// バイナリ転送グループです。
        /// </summary>
        private ViewerBasicPtclData ptclData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerBasicData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// シーングループです。
        /// </summary>
        [DataModelPropertyGuid("d191a525-dc8c-4d92-b29c-6341c943df4e")]
        public ViewerBasicSceneData SceneData
        {
            get { return this.GetDataModelFromField(ref this.sceneData, false); }
            set { this.SetDataModelToField(ref this.sceneData, value); }
        }

        /// <summary>
        /// バイナリ転送グループです。
        /// </summary>
        [DataModelPropertyGuid("ead863c6-417a-4465-b3fe-9634b7a4c754")]
        public ViewerBasicPtclData PtclData
        {
            get { return this.GetDataModelFromField(ref this.ptclData, false); }
            set { this.SetDataModelToField(ref this.ptclData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ViewerBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.SceneData = srcDataModel.SceneData;
            this.PtclData = srcDataModel.PtclData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "SceneData", this.SceneData);
            this.WriteElement(context, "PtclData", this.PtclData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.SceneData = this.ReadElement(context, "SceneData", this.SceneData);
            this.PtclData = this.ReadElement(context, "PtclData", this.PtclData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.ViewerBasicData(PrevVersion.ViewerBasicData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.ViewerBasicData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.ViewerBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.SceneData = srcDataModel.SceneData;
            this.PtclData = srcDataModel.PtclData;

            return true;
        }
    }
}
