﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_2;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/コンバイナタブ/カラー・アルファコンバイナグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterCombinerEquationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCombinerEquationData() :
            base()
        {
            this.ColorTexture0BlendType = 0;
            this.ColorTexture0Channel = 0;
            this.ColorTexture1BlendType = 0;
            this.ColorTexture1Channel = 0;
            this.ColorTexture2BlendType = 0;
            this.ColorTexture2Channel = 0;
            this.ColorTextureExpression = 1;
            this.ColorPrimitiveExpression = 0;
            this.ColorPrimitiveChannel = 0;
            this.AlphaTexture0BlendType = 0;
            this.AlphaTexture0Channel = 0;
            this.AlphaTexture1BlendType = 0;
            this.AlphaTexture1Channel = 0;
            this.AlphaTexture2BlendType = 0;
            this.AlphaTexture2Channel = 0;
            this.AlphaPrimitiveExpression = 0;
            this.AlphaPrimitiveChannel = 0;
            this.AlphaExpression = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// カラーコンバイナのテクスチャ0の演算子を取得または設定します。
        /// この値は使用しません。
        /// </summary>
        [DataModelPropertyGuid("4cb131a0-e0c2-46d4-9167-64129b99dcbf")]
        public int ColorTexture0BlendType { get; set; }

        /// <summary>
        /// カラーコンバイナのテクスチャ0のチャンネルの種類を取得します。
        /// </summary>
        [DataModelPropertyGuid("2e6117f7-d00c-4831-81a2-259b83dc8915")]
        public int ColorTexture0Channel { get; set; }

        /// <summary>
        /// カラーコンバイナのテクスチャ1の演算子を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1aef7528-957e-4cbb-a375-42e3a328bfcd")]
        public int ColorTexture1BlendType { get; set; }

        /// <summary>
        /// カラーコンバイナのテクスチャ1のチャンネルの種類を取得します。
        /// </summary>
        [DataModelPropertyGuid("0729433e-1152-42d4-a5b2-149100633aa0")]
        public int ColorTexture1Channel { get; set; }

        /// <summary>
        /// カラーコンバイナのテクスチャ2の演算子を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("30adbf8e-e0bd-4009-81b7-fef2188a8c5b")]
        public int ColorTexture2BlendType { get; set; }

        /// <summary>
        /// カラーコンバイナのテクスチャ2のチャンネルの種類を取得します。
        /// </summary>
        [DataModelPropertyGuid("96a9b7cc-6740-4e95-8ab9-efbfec66e84a")]
        public int ColorTexture2Channel { get; set; }

        /// <summary>
        /// カラーコンバイナの計算式を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d87d2ee8-3184-406e-98ab-bc5fc105f8fc")]
        public int ColorTextureExpression { get; set; }

        /// <summary>
        /// カラーコンバイナのプリミティブの演算子を取得します。
        /// </summary>
        [DataModelPropertyGuid("dc258f45-eac8-4619-ac0b-d1fb38fe8b2c")]
        public int ColorPrimitiveExpression { get; set; }

        /// <summary>
        /// カラーコンバイナのプリミティブのチャンネルの種類を取得します。
        /// </summary>
        [DataModelPropertyGuid("8f77463e-7436-4fd1-b735-a06c0f6d9a6e")]
        public int ColorPrimitiveChannel { get; set; }

        /// <summary>
        /// アルファコンバイナのテクスチャ0の演算子を取得または設定します。
        /// この値は使用しません。
        /// </summary>
        [DataModelPropertyGuid("0439bdcd-eb51-43a2-8d3e-4a9e38890015")]
        public int AlphaTexture0BlendType { get; set; }

        /// <summary>
        /// アルファコンバイナのテクスチャ0のチャンネルの種類を取得します。
        /// </summary>
        [DataModelPropertyGuid("4c9b0e58-c1c5-4c54-ad89-0d9f48539137")]
        public int AlphaTexture0Channel { get; set; }

        /// <summary>
        /// アルファコンバイナのテクスチャ1の演算子を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("71424e79-2c84-461b-96da-55e5cd3e4a4f")]
        public int AlphaTexture1BlendType { get; set; }

        /// <summary>
        /// アルファコンバイナのテクスチャ1のチャンネルの種類を取得します。
        /// </summary>
        [DataModelPropertyGuid("25ed6223-edc6-4306-80ec-face7e114406")]
        public int AlphaTexture1Channel { get; set; }

        /// <summary>
        /// アルファコンバイナのテクスチャ2の演算子を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b4f57eda-befe-4b19-9ea3-1126eed3a3f3")]
        public int AlphaTexture2BlendType { get; set; }

        /// <summary>
        /// アルファコンバイナのテクスチャ2のチャンネルの種類を取得します。
        /// </summary>
        [DataModelPropertyGuid("f8e38e7c-3a1d-4143-8956-1a0874692130")]
        public int AlphaTexture2Channel { get; set; }

        /// <summary>
        /// アルファコンバイナのプリミティブの演算子を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("41a6784d-e2c9-4958-88c1-c62d4aa1519a")]
        public int AlphaPrimitiveExpression { get; set; }

        /// <summary>
        /// アルファコンバイナのプリミティブのチャンネルの種類を取得します。
        /// </summary>
        [DataModelPropertyGuid("2be9e502-029d-42e5-9ab3-dea75f219da4")]
        public int AlphaPrimitiveChannel { get; set; }

        /// <summary>
        /// アルファコンバイナの計算式を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("78e1ac34-28cc-430f-8131-9111687bcfb7")]
        public int AlphaExpression { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterCombinerEquationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ColorTexture0BlendType = srcDataModel.ColorTexture0BlendType;
            this.ColorTexture0Channel = srcDataModel.ColorTexture0Channel;
            this.ColorTexture1BlendType = srcDataModel.ColorTexture1BlendType;
            this.ColorTexture1Channel = srcDataModel.ColorTexture1Channel;
            this.ColorTexture2BlendType = srcDataModel.ColorTexture2BlendType;
            this.ColorTexture2Channel = srcDataModel.ColorTexture2Channel;
            this.ColorTextureExpression = srcDataModel.ColorTextureExpression;
            this.ColorPrimitiveExpression = srcDataModel.ColorPrimitiveExpression;
            this.ColorPrimitiveChannel = srcDataModel.ColorPrimitiveChannel;
            this.AlphaTexture0BlendType = srcDataModel.AlphaTexture0BlendType;
            this.AlphaTexture0Channel = srcDataModel.AlphaTexture0Channel;
            this.AlphaTexture1BlendType = srcDataModel.AlphaTexture1BlendType;
            this.AlphaTexture1Channel = srcDataModel.AlphaTexture1Channel;
            this.AlphaTexture2BlendType = srcDataModel.AlphaTexture2BlendType;
            this.AlphaTexture2Channel = srcDataModel.AlphaTexture2Channel;
            this.AlphaPrimitiveExpression = srcDataModel.AlphaPrimitiveExpression;
            this.AlphaPrimitiveChannel = srcDataModel.AlphaPrimitiveChannel;
            this.AlphaExpression = srcDataModel.AlphaExpression;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ColorTexture0BlendType", this.ColorTexture0BlendType);
            this.WriteElement(context, "ColorTexture0Channel", this.ColorTexture0Channel);
            this.WriteElement(context, "ColorTexture1BlendType", this.ColorTexture1BlendType);
            this.WriteElement(context, "ColorTexture1Channel", this.ColorTexture1Channel);
            this.WriteElement(context, "ColorTexture2BlendType", this.ColorTexture2BlendType);
            this.WriteElement(context, "ColorTexture2Channel", this.ColorTexture2Channel);
            this.WriteElement(context, "ColorTextureExpression", this.ColorTextureExpression);
            this.WriteElement(context, "ColorPrimitiveExpression", this.ColorPrimitiveExpression);
            this.WriteElement(context, "ColorPrimitiveChannel", this.ColorPrimitiveChannel);
            this.WriteElement(context, "AlphaTexture0BlendType", this.AlphaTexture0BlendType);
            this.WriteElement(context, "AlphaTexture0Channel", this.AlphaTexture0Channel);
            this.WriteElement(context, "AlphaTexture1BlendType", this.AlphaTexture1BlendType);
            this.WriteElement(context, "AlphaTexture1Channel", this.AlphaTexture1Channel);
            this.WriteElement(context, "AlphaTexture2BlendType", this.AlphaTexture2BlendType);
            this.WriteElement(context, "AlphaTexture2Channel", this.AlphaTexture2Channel);
            this.WriteElement(context, "AlphaPrimitiveExpression", this.AlphaPrimitiveExpression);
            this.WriteElement(context, "AlphaPrimitiveChannel", this.AlphaPrimitiveChannel);
            this.WriteElement(context, "AlphaExpression", this.AlphaExpression);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ColorTexture0BlendType = this.ReadElement(context, "ColorTexture0BlendType", this.ColorTexture0BlendType);
            this.ColorTexture0Channel = this.ReadElement(context, "ColorTexture0Channel", this.ColorTexture0Channel);
            this.ColorTexture1BlendType = this.ReadElement(context, "ColorTexture1BlendType", this.ColorTexture1BlendType);
            this.ColorTexture1Channel = this.ReadElement(context, "ColorTexture1Channel", this.ColorTexture1Channel);
            this.ColorTexture2BlendType = this.ReadElement(context, "ColorTexture2BlendType", this.ColorTexture2BlendType);
            this.ColorTexture2Channel = this.ReadElement(context, "ColorTexture2Channel", this.ColorTexture2Channel);
            this.ColorTextureExpression = this.ReadElement(context, "ColorTextureExpression", this.ColorTextureExpression);
            this.ColorPrimitiveExpression = this.ReadElement(context, "ColorPrimitiveExpression", this.ColorPrimitiveExpression);
            this.ColorPrimitiveChannel = this.ReadElement(context, "ColorPrimitiveChannel", this.ColorPrimitiveChannel);
            this.AlphaTexture0BlendType = this.ReadElement(context, "AlphaTexture0BlendType", this.AlphaTexture0BlendType);
            this.AlphaTexture0Channel = this.ReadElement(context, "AlphaTexture0Channel", this.AlphaTexture0Channel);
            this.AlphaTexture1BlendType = this.ReadElement(context, "AlphaTexture1BlendType", this.AlphaTexture1BlendType);
            this.AlphaTexture1Channel = this.ReadElement(context, "AlphaTexture1Channel", this.AlphaTexture1Channel);
            this.AlphaTexture2BlendType = this.ReadElement(context, "AlphaTexture2BlendType", this.AlphaTexture2BlendType);
            this.AlphaTexture2Channel = this.ReadElement(context, "AlphaTexture2Channel", this.AlphaTexture2Channel);
            this.AlphaPrimitiveExpression = this.ReadElement(context, "AlphaPrimitiveExpression", this.AlphaPrimitiveExpression);
            this.AlphaPrimitiveChannel = this.ReadElement(context, "AlphaPrimitiveChannel", this.AlphaPrimitiveChannel);
            this.AlphaExpression = this.ReadElement(context, "AlphaExpression", this.AlphaExpression);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterCombinerEquationData(PrevVersion.EmitterCombinerEquationData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterCombinerEquationData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterCombinerEquationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ColorTexture0BlendType = srcDataModel.ColorTexture0BlendType;
            this.ColorTexture0Channel = srcDataModel.ColorTexture0Channel;
            this.ColorTexture1BlendType = srcDataModel.ColorTexture1BlendType;
            this.ColorTexture1Channel = srcDataModel.ColorTexture1Channel;
            this.ColorTexture2BlendType = srcDataModel.ColorTexture2BlendType;
            this.ColorTexture2Channel = srcDataModel.ColorTexture2Channel;
            this.ColorTextureExpression = srcDataModel.ColorTextureExpression;
            this.ColorPrimitiveExpression = srcDataModel.ColorPrimitiveExpression;
            this.ColorPrimitiveChannel = srcDataModel.ColorPrimitiveChannel;
            this.AlphaTexture0BlendType = srcDataModel.AlphaTexture0BlendType;
            this.AlphaTexture0Channel = srcDataModel.AlphaTexture0Channel;
            this.AlphaTexture1BlendType = srcDataModel.AlphaTexture1BlendType;
            this.AlphaTexture1Channel = srcDataModel.AlphaTexture1Channel;
            this.AlphaTexture2BlendType = srcDataModel.AlphaTexture2BlendType;
            this.AlphaTexture2Channel = srcDataModel.AlphaTexture2Channel;
            this.AlphaPrimitiveExpression = srcDataModel.AlphaPrimitiveExpression;
            this.AlphaPrimitiveChannel = srcDataModel.AlphaPrimitiveChannel;
            this.AlphaExpression = srcDataModel.AlphaExpression;

            return true;
        }
    }
}
