﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_1;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// プレビューデータです。
    /// </summary>
    [Serializable]
    public class PreviewData : DisplayableDataBase
    {
        /// <summary>
        /// 基本設定です.
        /// </summary>
        private PreviewBasicSettingData basicSettingData = null;

        /// <summary>
        /// SRT制御です.
        /// </summary>
        private PreviewMatrixData previewMatrixData = null;

        /// <summary>
        /// 自動移動データです。
        /// </summary>
        private PreviewAutoMoveData autoMoveData = null;

        /// <summary>
        /// カラーデータです。
        /// </summary>
        private PreviewColorData colorData = null;

        /// <summary>
        /// パーティクル放出データです。
        /// </summary>
        private PreviewParticleEmissionData particleEmissionData = null;

        /// <summary>
        /// パーティクルスケールデータです。
        /// </summary>
        private PreviewParticleScaleData particleScaleData = null;

        /// <summary>
        /// パーティクル制御データです。
        /// </summary>
        private PreviewParticleControlData particleControlData = null;

        /// <summary>
        /// エミッタデータです。
        /// </summary>
        private PreviewEmitterData emitterData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewData() :
            base()
        {
            this.Name = string.Empty;
            this.FilePath = string.Empty;
            this.EsetName = string.Empty;

            this.PostConstruct();
        }

        /// <summary>
        /// 名前です.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("fcdbf628-a924-4197-a5e9-cab48961e469")]
        public string Name { get; set; }

        /// <summary>
        /// ファイルパス(ファイル名を含まない)です.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("85186ea8-f46a-4edd-a4a4-4aac09872b9d")]
        public string FilePath { get; set; }

        /// <summary>
        /// 親エミッタセットの名前です.
        /// </summary>
        [DataModelPropertyGuid("0f2944ed-b5ce-4b7b-82c7-36788ac89564")]
        public string EsetName { get; set; }

        /// <summary>
        /// 基本設定です.
        /// </summary>
        [DataModelPropertyGuid("29edf967-bb75-4f0e-8b19-bccacd029237")]
        public PreviewBasicSettingData BasicSettingData
        {
            get { return this.GetDataModelFromField(ref this.basicSettingData, false); }
            set { this.SetDataModelToField(ref this.basicSettingData, value); }
        }

        /// <summary>
        /// SRT制御です.
        /// </summary>
        [DataModelPropertyGuid("7a1718af-9cc3-454e-b741-adacd7de94bf")]
        public PreviewMatrixData PreviewMatrixData
        {
            get { return this.GetDataModelFromField(ref this.previewMatrixData, false); }
            set { this.SetDataModelToField(ref this.previewMatrixData, value); }
        }

        /// <summary>
        /// 自動移動データです。
        /// </summary>
        [DataModelPropertyGuid("7352ed5d-5b2c-4f2d-8afc-1aff26b03efb")]
        public PreviewAutoMoveData AutoMoveData
        {
            get { return this.GetDataModelFromField(ref this.autoMoveData, false); }
            set { this.SetDataModelToField(ref this.autoMoveData, value); }
        }

        /// <summary>
        /// カラーデータです。
        /// </summary>
        [DataModelPropertyGuid("9e448cac-34ab-41b4-af79-d6ba63407ba2")]
        public PreviewColorData ColorData
        {
            get { return this.GetDataModelFromField(ref this.colorData, false); }
            set { this.SetDataModelToField(ref this.colorData, value); }
        }

        /// <summary>
        /// パーティクル放出データです。
        /// </summary>
        [DataModelPropertyGuid("3d5b35b6-96f1-433e-b870-0a8b2b14e42b")]
        public PreviewParticleEmissionData ParticleEmissionData
        {
            get { return this.GetDataModelFromField(ref this.particleEmissionData, false); }
            set { this.SetDataModelToField(ref this.particleEmissionData, value); }
        }

        /// <summary>
        /// パーティクルスケールデータです。
        /// </summary>
        [DataModelPropertyGuid("78cfd7bc-7153-4f17-86d6-6cfd06a0d095")]
        public PreviewParticleScaleData ParticleScaleData
        {
            get { return this.GetDataModelFromField(ref this.particleScaleData, false); }
            set { this.SetDataModelToField(ref this.particleScaleData, value); }
        }

        /// <summary>
        /// パーティクル制御データです。
        /// </summary>
        [DataModelPropertyGuid("4b08cf49-873c-445d-8cac-e9f4c638e795")]
        public PreviewParticleControlData ParticleControlData
        {
            get { return this.GetDataModelFromField(ref this.particleControlData, false); }
            set { this.SetDataModelToField(ref this.particleControlData, value); }
        }

        /// <summary>
        /// エミッタデータです。
        /// </summary>
        [DataModelPropertyGuid("3800c625-f34e-4db5-be33-fef98acae90e")]
        public PreviewEmitterData EmitterData
        {
            get { return this.GetDataModelFromField(ref this.emitterData, false); }
            set { this.SetDataModelToField(ref this.emitterData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.FilePath = srcDataModel.FilePath;
            this.EsetName = srcDataModel.EsetName;
            this.BasicSettingData = srcDataModel.BasicSettingData;
            this.PreviewMatrixData = srcDataModel.PreviewMatrixData;
            this.AutoMoveData = srcDataModel.AutoMoveData;
            this.ColorData = srcDataModel.ColorData;
            this.ParticleEmissionData = srcDataModel.ParticleEmissionData;
            this.ParticleScaleData = srcDataModel.ParticleScaleData;
            this.ParticleControlData = srcDataModel.ParticleControlData;
            this.EmitterData = srcDataModel.EmitterData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EsetName", this.EsetName);
            this.WriteElement(context, "BasicSettingData", this.BasicSettingData);
            this.WriteElement(context, "PreviewMatrixData", this.PreviewMatrixData);
            this.WriteElement(context, "AutoMoveData", this.AutoMoveData);
            this.WriteElement(context, "ColorData", this.ColorData);
            this.WriteElement(context, "ParticleEmissionData", this.ParticleEmissionData);
            this.WriteElement(context, "ParticleScaleData", this.ParticleScaleData);
            this.WriteElement(context, "ParticleControlData", this.ParticleControlData);
            this.WriteElement(context, "EmitterData", this.EmitterData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EsetName = this.ReadElement(context, "EsetName", this.EsetName);
            this.BasicSettingData = this.ReadElement(context, "BasicSettingData", this.BasicSettingData);
            this.PreviewMatrixData = this.ReadElement(context, "PreviewMatrixData", this.PreviewMatrixData);
            this.AutoMoveData = this.ReadElement(context, "AutoMoveData", this.AutoMoveData);
            this.ColorData = this.ReadElement(context, "ColorData", this.ColorData);
            this.ParticleEmissionData = this.ReadElement(context, "ParticleEmissionData", this.ParticleEmissionData);
            this.ParticleScaleData = this.ReadElement(context, "ParticleScaleData", this.ParticleScaleData);
            this.ParticleControlData = this.ReadElement(context, "ParticleControlData", this.ParticleControlData);
            this.EmitterData = this.ReadElement(context, "EmitterData", this.EmitterData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.PreviewData(PrevVersion.PreviewData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.PreviewData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.PreviewData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.FilePath = srcDataModel.FilePath;
            this.EsetName = srcDataModel.EsetName;
            this.BasicSettingData = srcDataModel.BasicSettingData;
            this.PreviewMatrixData = srcDataModel.PreviewMatrixData;
            this.AutoMoveData = srcDataModel.AutoMoveData;
            this.ColorData = srcDataModel.ColorData;
            this.ParticleEmissionData = srcDataModel.ParticleEmissionData;
            this.ParticleScaleData = srcDataModel.ParticleScaleData;
            this.ParticleControlData = srcDataModel.ParticleControlData;
            this.EmitterData = srcDataModel.EmitterData;

            return true;
        }
    }
}
