﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_1;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデルノード/基本設定タブ/再生設定グループデータです。
    /// </summary>
    [Serializable]
    public class ModelBasicPlaybackData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelBasicPlaybackData() :
            base()
        {
            this.AnimationSpeed = 1.0f;
            this.AnimationStartFrame = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// 再生速度です.
        /// </summary>
        [DataModelPropertyGuid("b42bc854-29a7-45a6-ae35-828062ee0f8d")]
        public float AnimationSpeed { get; set; }

        /// <summary>
        /// 再生開始フレームです.
        /// </summary>
        [DataModelPropertyGuid("ef360af6-649e-4178-9d23-d69059128d1b")]
        public float AnimationStartFrame { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ModelBasicPlaybackData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.AnimationSpeed = srcDataModel.AnimationSpeed;
            this.AnimationStartFrame = srcDataModel.AnimationStartFrame;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "AnimationSpeed", this.AnimationSpeed);
            this.WriteElement(context, "AnimationStartFrame", this.AnimationStartFrame);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.AnimationSpeed = this.ReadElement(context, "AnimationSpeed", this.AnimationSpeed);
            this.AnimationStartFrame = this.ReadElement(context, "AnimationStartFrame", this.AnimationStartFrame);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.ModelBasicPlaybackData(PrevVersion.ModelBasicPlaybackData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.ModelBasicPlaybackData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.ModelBasicPlaybackData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.AnimationSpeed = srcDataModel.AnimationSpeed;
            this.AnimationStartFrame = srcDataModel.AnimationStartFrame;

            return true;
        }
    }
}
