﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_1;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/GPUノイズタブデータです。
    /// </summary>
    [Serializable]
    public class RandomData : FieldDataBase
    {
        /// <summary>
        /// 基本設定グループデータを取得または設定します。
        /// </summary>
        private RandomBasicSetting randomBasicSetting = null;

        /// <summary>
        /// 波形成分の位相を統一グループデータを取得または設定します。
        /// </summary>
        private RandomUnifiedPhaseParam randomUnifiedPhaseParam = null;

        /// <summary>
        /// 波形成分の詳細設定グループデータを取得または設定します。
        /// </summary>
        private RandomDetailedOption randomDetailedOption = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public RandomData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// 基本設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a38fed82-41d8-4d0b-97cf-da2dbf134838")]
        public RandomBasicSetting RandomBasicSetting
        {
            get { return this.GetDataModelFromField(ref this.randomBasicSetting, false); }
            set { this.SetDataModelToField(ref this.randomBasicSetting, value); }
        }

        /// <summary>
        /// 波形成分の位相を統一グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5cc15027-4738-46a4-9fb5-939bafe3f782")]
        public RandomUnifiedPhaseParam RandomUnifiedPhaseParam
        {
            get { return this.GetDataModelFromField(ref this.randomUnifiedPhaseParam, false); }
            set { this.SetDataModelToField(ref this.randomUnifiedPhaseParam, value); }
        }

        /// <summary>
        /// 波形成分の詳細設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b5740c2e-fbb5-45b6-ba2a-30fa4c8d7f68")]
        public RandomDetailedOption RandomDetailedOption
        {
            get { return this.GetDataModelFromField(ref this.randomDetailedOption, false); }
            set { this.SetDataModelToField(ref this.randomDetailedOption, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.RandomData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.RandomBasicSetting = srcDataModel.RandomBasicSetting;
            this.RandomUnifiedPhaseParam = srcDataModel.RandomUnifiedPhaseParam;
            this.RandomDetailedOption = srcDataModel.RandomDetailedOption;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "RandomBasicSetting", this.RandomBasicSetting);
            this.WriteElement(context, "RandomUnifiedPhaseParam", this.RandomUnifiedPhaseParam);
            this.WriteElement(context, "RandomDetailedOption", this.RandomDetailedOption);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.RandomBasicSetting = this.ReadElement(context, "RandomBasicSetting", this.RandomBasicSetting);
            this.RandomUnifiedPhaseParam = this.ReadElement(context, "RandomUnifiedPhaseParam", this.RandomUnifiedPhaseParam);
            this.RandomDetailedOption = this.ReadElement(context, "RandomDetailedOption", this.RandomDetailedOption);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.RandomData(PrevVersion.RandomData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.RandomData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.RandomData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.RandomBasicSetting = srcDataModel.RandomBasicSetting;
            this.RandomUnifiedPhaseParam = srcDataModel.RandomUnifiedPhaseParam;
            this.RandomDetailedOption = srcDataModel.RandomDetailedOption;

            return true;
        }
    }
}
