﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Collections;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_1;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタセットノードデータです。
    /// </summary>
    [Serializable]
    public class EmitterSetData : DisplayableDataBase
    {
        /// <summary>
        /// ファイル管理データです。
        /// </summary>
        private EmitterSetBasicData emitterSetBasicData = null;

        /// <summary>
        /// ユーザーデータ.
        /// </summary>
        private EmitterSetUserData emitterSetUserData = null;

        /// <summary>
        /// エミッタリストを取得または設定します。
        /// </summary>
        private List<EmitterData> emitterList = null;

        /// <summary>
        /// プレビューリストを取得または設定します。
        /// </summary>
        private List<PreviewData> previewList = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterSetData() :
            base()
        {
            this.Name = string.Empty;
            this.FilePath = string.Empty;

            this.PostConstruct();
        }

        /// <summary>
        /// 名前を取得または設定します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("0b3a8c4e-2327-4f8d-8384-6139531dd500")]
        public string Name { get; set; }

        /// <summary>
        /// ファイルパスを取得または設定します。
        /// このパスにはファイル名を含みません。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("72c7b81c-a8a7-4a21-997e-9644ec599725")]
        public string FilePath { get; set; }

        /// <summary>
        /// ファイル管理データです。
        /// </summary>
        [DataModelPropertyGuid("99d1cfbe-186d-4f51-9deb-216b3504c40d")]
        public EmitterSetBasicData EmitterSetBasicData
        {
            get { return this.GetDataModelFromField(ref this.emitterSetBasicData, false); }
            set { this.SetDataModelToField(ref this.emitterSetBasicData, value); }
        }

        /// <summary>
        /// ユーザーデータ.
        /// </summary>
        [DataModelPropertyGuid("e3f52400-9117-46db-9f24-d6c86c78fd4c")]
        public EmitterSetUserData EmitterSetUserData
        {
            get { return this.GetDataModelFromField(ref this.emitterSetUserData, false); }
            set { this.SetDataModelToField(ref this.emitterSetUserData, value); }
        }

        /// <summary>
        /// Enumerate the file path of all the textures the child emitters use.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e7df4bf5-feba-4c9a-9c82-4d5d728bf807")]
        public IEnumerable<string> TexturePaths
        {
            get
            {
                return this.AllChildEmitters.SelectMany(em => em.TexturePaths);
            }
        }

        /// <summary>
        /// Enumerate the file path of all the primitive the child emitters use.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("fc446954-416c-4bff-a162-1cf1e11f2133")]
        public IEnumerable<string> PrimitivePaths
        {
            get
            {
                return this.AllChildEmitters.SelectMany(em => em.PrimitivePaths);
            }
        }

        /// <summary>
        /// Enumerate the index of all the custom shader the child emitters use.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("da99770a-7504-4e4f-9537-690d7fcec013")]
        public IEnumerable<int> CustomShaderIndices
        {
            get
            {
                return this.AllChildEmitters.Select(em => em.CustomShaderIndex);
            }
        }

        /// <summary>
        /// Get all the emitters by performing a recursive search through all the child emitters.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("5d21f6a7-c4ba-4585-bd7e-b52c2062cda6")]
        public IEnumerable<EmitterData> AllChildEmitters
        {
            get
            {
                foreach (EmitterData item in this.EmitterList)
                {
                    yield return item;
                    foreach (EmitterData child in item.AllChildEmitters)
                    {
                        yield return child;
                    }
                }
            }
        }

        /// <summary>
        /// バイナリコンバートが有効なエミッタを再帰的に辿ったリストを取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("6536aa93-6224-4aeb-958d-ae1cc3f9b3ca")]
        public IEnumerable<EmitterData> AllActiveChildEmitters
        {
            get
            {
                foreach (EmitterData item in this.ActiveEmitterList)
                {
                    yield return item;
                    foreach (EmitterData child in item.AllActiveChildEmitters)
                    {
                        yield return child;
                    }
                }
            }
        }

        /// <summary>
        /// エミッタリストを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("89081083-7ed2-46cf-a2ae-55fc121e0acb")]
        public List<EmitterData> EmitterList
        {
            get { return this.GetDataModelListFromField(ref this.emitterList); }
            set { this.SetDataModelListToField(ref this.emitterList, value); }
        }

        /// <summary>
        /// バイナリコンバートが有効なエミッタのリストを取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("2b08a381-dc9e-41a8-bcb5-e1ba12e9bfdd")]
        public IEnumerable<EmitterData> ActiveEmitterList
        {
            get
            {
                foreach (EmitterData item in this.EmitterList)
                {
                    if (item.EnableConvert == false)
                    {
                        continue;
                    }

                    yield return item;
                }
            }
        }

        /// <summary>
        /// プレビューリストを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c1b2a6b9-5d84-4b97-93b0-5eb97f296459")]
        public List<PreviewData> PreviewList
        {
            get { return this.GetDataModelListFromField(ref this.previewList); }
            set { this.SetDataModelListToField(ref this.previewList, value); }
        }

        /// <summary>
        /// エミッタ名とテクスチャファイルパスの対を列挙します。
        /// 列挙するエミッタはバイナリコンバートが有効なものに限ります。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("64b2e693-c7f5-4a3b-bbad-f5a973c521c0")]
        public IEnumerable<StringPair> EmitterNameAndTexturePaths
        {
            get
            {
                return this.AllActiveChildEmitters.SelectMany(em => em.EmitterNameAndTexturePaths);
            }
        }

        /// <summary>
        /// エミッタ名とプリミティブファイルパスの対を列挙します。
        /// プリミティブは G3D プリミティブバイナリに変換するものだけを列挙します。
        /// 列挙するエミッタはバイナリコンバートが有効なものに限ります。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("94886424-7162-4536-bbf4-583d124b9b33")]
        public IEnumerable<StringPair> EmitterNameAndPrimitivePaths
        {
            get
            {
                return this.AllActiveChildEmitters.SelectMany(em => em.EmitterNameAndPrimitivePaths);
            }
        }

        /// <summary>
        /// エミッタ名とトリミングプリミティブファイルパスの対を列挙します。
        /// 列挙するエミッタはバイナリコンバートが有効なものに限ります。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("480567ce-a26a-40e5-b271-e32f44239bce")]
        public IEnumerable<StringPair> EmitterNameAndTrimmingTexturePaths
        {
            get
            {
                return this.AllActiveChildEmitters.SelectMany(em => em.EmitterNameAndTrimmingTexturePaths);
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterSetData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.FilePath = srcDataModel.FilePath;
            this.EmitterSetBasicData = srcDataModel.EmitterSetBasicData;
            this.EmitterSetUserData = srcDataModel.EmitterSetUserData;
            this.EmitterList = srcDataModel.EmitterList;
            this.PreviewList = srcDataModel.PreviewList;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterSetBasicData", this.EmitterSetBasicData);
            this.WriteElement(context, "EmitterSetUserData", this.EmitterSetUserData);
            this.WriteEnumerableElement(context, "EmitterList", this.EmitterList);
            this.WriteEnumerableElement(context, "PreviewList", this.PreviewList);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterSetBasicData = this.ReadElement(context, "EmitterSetBasicData", this.EmitterSetBasicData);
            this.EmitterSetUserData = this.ReadElement(context, "EmitterSetUserData", this.EmitterSetUserData);
            this.EmitterList = this.ReadListElement(context, "EmitterList", this.EmitterList);
            this.PreviewList = this.ReadListElement(context, "PreviewList", this.PreviewList);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterSetData(PrevVersion.EmitterSetData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterSetData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterSetData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.FilePath = srcDataModel.FilePath;
            this.EmitterSetBasicData = srcDataModel.EmitterSetBasicData;
            this.EmitterSetUserData = srcDataModel.EmitterSetUserData;
            this.EmitterList = srcDataModel.EmitterList.Select(dm => (CurrVersion.EmitterData)dm).ToList();
            this.PreviewList = srcDataModel.PreviewList.Select(dm => (CurrVersion.PreviewData)dm).ToList();

            return true;
        }
    }
}
