﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_1;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/放出タブ/初速設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterEmissionVelocityData : DataModelBase
    {
        /// <summary>
        /// 全方向初速のエミッタ時間アニメを取得または設定します。
        /// </summary>
        private EmitterAnimationCommonData omnidirectionalVelocityAnimation = null;

        /// <summary>
        /// 指定方向初速の指定方向を取得または設定します。
        /// </summary>
        private Vector3f orientedDirection = null;

        /// <summary>
        /// 指定方向初速のエミッタ時間アニメを取得または設定します。
        /// </summary>
        private EmitterAnimationCommonData orientedDirectionVelocityAnimation = null;

        /// <summary>
        /// 拡散初速を取得または設定します。
        /// </summary>
        private Vector3f diffusionVelocity = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmissionVelocityData() :
            base()
        {
            this.OmnidirectionalVelocity = 0.1f;
            this.OrientedVelocity = 0.0f;
            this.EnableOrientedVelocity = false;
            this.OrientedDirection = new Vector3f(0.0f, 1.0f, 0.0f);
            this.OrientedDirectionalDiffusionAngle = 0.0f;
            this.YaxisDiffusionVelocity = 0.0f;
            this.DiffusionVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
            this.VelocityRandom = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// 全方向初速を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("bf814947-364f-414c-9848-f51f9480b11e")]
        public float OmnidirectionalVelocity { get; set; }

        /// <summary>
        /// 全方向初速のエミッタ時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8921ab73-f43a-4c08-ac8e-ffb841990389")]
        public EmitterAnimationCommonData OmnidirectionalVelocityAnimation
        {
            get { return this.GetDataModelFromField(ref this.omnidirectionalVelocityAnimation, false); }
            set { this.SetDataModelToField(ref this.omnidirectionalVelocityAnimation, value); }
        }

        /// <summary>
        /// 指定方向初速を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f0a6c91b-e34d-4e49-bc3c-5c7f657904c2")]
        public float OrientedVelocity { get; set; }

        /// <summary>
        /// 指定方向初速のエミッタ時間アニメのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b042e868-f1dc-4f75-a080-3eba89e81ac9")]
        public bool EnableOrientedVelocity { get; set; }

        /// <summary>
        /// 指定方向初速の指定方向を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9d666727-dc45-4fd0-bc73-38b8d27c732e")]
        public Vector3f OrientedDirection
        {
            get { return this.GetObjectFromField(ref this.orientedDirection, false); }
            set { this.SetISettableToField(ref this.orientedDirection, value); }
        }

        /// <summary>
        /// 指定方向初速のエミッタ時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8f241f14-f295-40cf-a6a7-73868479f1c3")]
        public EmitterAnimationCommonData OrientedDirectionVelocityAnimation
        {
            get { return this.GetDataModelFromField(ref this.orientedDirectionVelocityAnimation, false); }
            set { this.SetDataModelToField(ref this.orientedDirectionVelocityAnimation, value); }
        }

        /// <summary>
        /// 指定方向初速の指定方向拡散角度を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f2cfe40b-e088-4d1a-923c-91e42b8a5ae7")]
        public float OrientedDirectionalDiffusionAngle { get; set; }

        /// <summary>
        /// Y軸拡散初速を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c683265e-e253-40cc-8b29-49d9db1606e8")]
        public float YaxisDiffusionVelocity { get; set; }

        /// <summary>
        /// 拡散初速を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("cd45588b-f068-4f86-8bf0-1478f1619404")]
        public Vector3f DiffusionVelocity
        {
            get { return this.GetObjectFromField(ref this.diffusionVelocity, false); }
            set { this.SetISettableToField(ref this.diffusionVelocity, value); }
        }

        /// <summary>
        /// 初速度のランダム(%)の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("6caac401-6217-4555-a5fd-9700797860a0")]
        public float VelocityRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterEmissionVelocityData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.OmnidirectionalVelocity = srcDataModel.OmnidirectionalVelocity;
            this.OmnidirectionalVelocityAnimation = srcDataModel.OmnidirectionalVelocityAnimation;
            this.OrientedVelocity = srcDataModel.OrientedVelocity;
            this.EnableOrientedVelocity = srcDataModel.EnableOrientedVelocity;
            this.OrientedDirection = srcDataModel.OrientedDirection;
            this.OrientedDirectionVelocityAnimation = srcDataModel.OrientedDirectionVelocityAnimation;
            this.OrientedDirectionalDiffusionAngle = srcDataModel.OrientedDirectionalDiffusionAngle;
            this.YaxisDiffusionVelocity = srcDataModel.YaxisDiffusionVelocity;
            this.DiffusionVelocity = srcDataModel.DiffusionVelocity;
            this.VelocityRandom = srcDataModel.VelocityRandom;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "OmnidirectionalVelocity", this.OmnidirectionalVelocity);
            this.WriteElement(context, "OmnidirectionalVelocityAnimation", this.OmnidirectionalVelocityAnimation);
            this.WriteElement(context, "OrientedVelocity", this.OrientedVelocity);
            this.WriteElement(context, "EnableOrientedVelocity", this.EnableOrientedVelocity);
            this.WriteElement(context, "OrientedDirection", this.OrientedDirection);
            this.WriteElement(context, "OrientedDirectionVelocityAnimation", this.OrientedDirectionVelocityAnimation);
            this.WriteElement(context, "OrientedDirectionalDiffusionAngle", this.OrientedDirectionalDiffusionAngle);
            this.WriteElement(context, "YaxisDiffusionVelocity", this.YaxisDiffusionVelocity);
            this.WriteElement(context, "DiffusionVelocity", this.DiffusionVelocity);
            this.WriteElement(context, "VelocityRandom", this.VelocityRandom);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.OmnidirectionalVelocity = this.ReadElement(context, "OmnidirectionalVelocity", this.OmnidirectionalVelocity);
            this.OmnidirectionalVelocityAnimation = this.ReadElement(context, "OmnidirectionalVelocityAnimation", this.OmnidirectionalVelocityAnimation);
            this.OrientedVelocity = this.ReadElement(context, "OrientedVelocity", this.OrientedVelocity);
            this.EnableOrientedVelocity = this.ReadElement(context, "EnableOrientedVelocity", this.EnableOrientedVelocity);
            this.OrientedDirection = this.ReadElement(context, "OrientedDirection", this.OrientedDirection);
            this.OrientedDirectionVelocityAnimation = this.ReadElement(context, "OrientedDirectionVelocityAnimation", this.OrientedDirectionVelocityAnimation);
            this.OrientedDirectionalDiffusionAngle = this.ReadElement(context, "OrientedDirectionalDiffusionAngle", this.OrientedDirectionalDiffusionAngle);
            this.YaxisDiffusionVelocity = this.ReadElement(context, "YaxisDiffusionVelocity", this.YaxisDiffusionVelocity);
            this.DiffusionVelocity = this.ReadElement(context, "DiffusionVelocity", this.DiffusionVelocity);
            this.VelocityRandom = this.ReadElement(context, "VelocityRandom", this.VelocityRandom);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterEmissionVelocityData(PrevVersion.EmitterEmissionVelocityData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterEmissionVelocityData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterEmissionVelocityData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.OmnidirectionalVelocity = srcDataModel.OmnidirectionalVelocity;
            this.OmnidirectionalVelocityAnimation = srcDataModel.OmnidirectionalVelocityAnimation;
            this.OrientedVelocity = srcDataModel.OrientedVelocity;
            this.EnableOrientedVelocity = srcDataModel.EnableOrientedVelocity;
            this.OrientedDirection = srcDataModel.OrientedDirection;
            this.OrientedDirectionVelocityAnimation = srcDataModel.OrientedDirectionVelocityAnimation;
            this.OrientedDirectionalDiffusionAngle = srcDataModel.OrientedDirectionalDiffusionAngle;
            this.YaxisDiffusionVelocity = srcDataModel.YaxisDiffusionVelocity;
            this.DiffusionVelocity = srcDataModel.DiffusionVelocity;
            this.VelocityRandom = srcDataModel.VelocityRandom;

            return true;
        }
    }
}
