﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ワークスペースデータです。
    /// </summary>
    [Serializable]
    public class WorkspaceData : DataModelBase
    {
        /// <summary>
        /// Enumerate the emitter sets.
        /// </summary>
        private List<EmitterSetData> emitterSetList = null;

        /// <summary>
        /// Get or set the viewer data.
        /// </summary>
        private ViewerData viewerData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public WorkspaceData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// Enumerate the file path of all the textures the child emitter sets use.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("dd8f955e-fc4d-426d-81aa-f012fded2917")]
        public IEnumerable<string> TexturePaths
        {
            get
            {
                return this.EmitterSetList.SelectMany(eset => eset.TexturePaths);
            }
        }

        /// <summary>
        /// Enumerate the emitter sets.
        /// </summary>
        [DataModelPropertyGuid("052b8cf7-3f07-4a39-8b69-1afa0c928037")]
        public List<EmitterSetData> EmitterSetList
        {
            get { return this.GetDataModelListFromField(ref this.emitterSetList); }
            set { this.SetDataModelListToField(ref this.emitterSetList, value); }
        }

        /// <summary>
        /// Get or set the viewer data.
        /// </summary>
        [DataModelPropertyGuid("6cf56145-9bf8-4b2a-a7d9-8b7c57e8e8e2")]
        public ViewerData ViewerData
        {
            get { return this.GetDataModelFromField(ref this.viewerData, false); }
            set { this.SetDataModelToField(ref this.viewerData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.WorkspaceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterSetList = srcDataModel.EmitterSetList;
            this.ViewerData = srcDataModel.ViewerData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteEnumerableElement(context, "EmitterSetList", this.EmitterSetList);
            this.WriteElement(context, "ViewerData", this.ViewerData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterSetList = this.ReadListElement(context, "EmitterSetList", this.EmitterSetList);
            this.ViewerData = this.ReadElement(context, "ViewerData", this.ViewerData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.WorkspaceData(PrevVersion.WorkspaceData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.WorkspaceData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.WorkspaceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterSetList = srcDataModel.EmitterSetList.Select(dm => (CurrVersion.EmitterSetData)dm).ToList();
            this.ViewerData = srcDataModel.ViewerData;

            return true;
        }
    }
}
