﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/カメラタブ/ビュー・射影グループです。
    /// </summary>
    [Serializable]
    public class ViewerCameraViewProjectionData : DataModelBase
    {
        /// <summary>
        /// カメラの位置です.
        /// </summary>
        private Vector3f cameraPosition = null;

        /// <summary>
        /// カメラの注視点です.
        /// </summary>
        private Vector3f cameraTarget = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerCameraViewProjectionData() :
            base()
        {
            this.CameraPosition = new Vector3f(0.0f, 50.0f, 150.0f);
            this.CameraTarget = new Vector3f(0.0f, 0.0f, 0.0f);
            this.CameraRotation = 0.0f;
            this.ProjectionType = 0;
            this.AspectRatio = 1.77f;
            this.ImageSize = 72.0f;
            this.FieldOfView = 60.0f;
            this.NearClip = 0.1f;
            this.FarClip = 1000.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// カメラの位置です.
        /// </summary>
        [DataModelPropertyGuid("7fb72e00-4c96-44be-b5c6-35fe407918a1")]
        public Vector3f CameraPosition
        {
            get { return this.GetObjectFromField(ref this.cameraPosition, false); }
            set { this.SetISettableToField(ref this.cameraPosition, value); }
        }

        /// <summary>
        /// カメラの注視点です.
        /// </summary>
        [DataModelPropertyGuid("34b15ed0-01e9-4621-bc8f-667370f98f38")]
        public Vector3f CameraTarget
        {
            get { return this.GetObjectFromField(ref this.cameraTarget, false); }
            set { this.SetISettableToField(ref this.cameraTarget, value); }
        }

        /// <summary>
        /// カメラの回転角(ツイスト角)です.
        /// </summary>
        [DataModelPropertyGuid("9f1ed308-6e31-43b8-b993-5bc9632de948")]
        public float CameraRotation { get; set; }

        /// <summary>
        /// 射影タイプです.
        /// </summary>
        [DataModelPropertyGuid("e02c374b-2c82-49f3-b74c-01357f6b1dfd")]
        public int ProjectionType { get; set; }

        /// <summary>
        /// アスペクト比です.
        /// </summary>
        [DataModelPropertyGuid("f6400c72-c61e-4d12-9b9b-570796cfaf84")]
        public float AspectRatio { get; set; }

        /// <summary>
        /// イメージサイズです.
        /// </summary>
        [DataModelPropertyGuid("9c31edbc-1aa2-4f30-9100-b979435d5252")]
        public float ImageSize { get; set; }

        /// <summary>
        /// 垂直画角です.
        /// </summary>
        [DataModelPropertyGuid("46c2e3c8-7a7b-48fc-9194-89e1e01e860d")]
        public float FieldOfView { get; set; }

        /// <summary>
        /// 近クリップ平面への距離です.
        /// </summary>
        [DataModelPropertyGuid("b260efa2-0ed8-4a2a-a047-ea6ad4d9f667")]
        public float NearClip { get; set; }

        /// <summary>
        /// 遠クリップ平面への距離です.
        /// </summary>
        [DataModelPropertyGuid("195f3b61-78fb-44a8-a0d3-4f3effaa0b86")]
        public float FarClip { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ViewerCameraViewProjectionData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.CameraPosition = srcDataModel.CameraPosition;
            this.CameraTarget = srcDataModel.CameraTarget;
            this.CameraRotation = srcDataModel.CameraRotation;
            this.ProjectionType = srcDataModel.ProjectionType;
            this.AspectRatio = srcDataModel.AspectRatio;
            this.ImageSize = srcDataModel.ImageSize;
            this.FieldOfView = srcDataModel.FieldOfView;
            this.NearClip = srcDataModel.NearClip;
            this.FarClip = srcDataModel.FarClip;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "CameraPosition", this.CameraPosition);
            this.WriteElement(context, "CameraTarget", this.CameraTarget);
            this.WriteElement(context, "CameraRotation", this.CameraRotation);
            this.WriteElement(context, "ProjectionType", this.ProjectionType);
            this.WriteElement(context, "AspectRatio", this.AspectRatio);
            this.WriteElement(context, "ImageSize", this.ImageSize);
            this.WriteElement(context, "FieldOfView", this.FieldOfView);
            this.WriteElement(context, "NearClip", this.NearClip);
            this.WriteElement(context, "FarClip", this.FarClip);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.CameraPosition = this.ReadElement(context, "CameraPosition", this.CameraPosition);
            this.CameraTarget = this.ReadElement(context, "CameraTarget", this.CameraTarget);
            this.CameraRotation = this.ReadElement(context, "CameraRotation", this.CameraRotation);
            this.ProjectionType = this.ReadElement(context, "ProjectionType", this.ProjectionType);
            this.AspectRatio = this.ReadElement(context, "AspectRatio", this.AspectRatio);
            this.ImageSize = this.ReadElement(context, "ImageSize", this.ImageSize);
            this.FieldOfView = this.ReadElement(context, "FieldOfView", this.FieldOfView);
            this.NearClip = this.ReadElement(context, "NearClip", this.NearClip);
            this.FarClip = this.ReadElement(context, "FarClip", this.FarClip);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.ViewerCameraViewProjectionData(PrevVersion.ViewerCameraViewProjectionData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.ViewerCameraViewProjectionData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.ViewerCameraViewProjectionData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.CameraPosition = srcDataModel.CameraPosition;
            this.CameraTarget = srcDataModel.CameraTarget;
            this.CameraRotation = srcDataModel.CameraRotation;
            this.ProjectionType = srcDataModel.ProjectionType;
            this.AspectRatio = srcDataModel.AspectRatio;
            this.ImageSize = srcDataModel.ImageSize;
            this.FieldOfView = srcDataModel.FieldOfView;
            this.NearClip = srcDataModel.NearClip;
            this.FarClip = srcDataModel.FarClip;

            return true;
        }
    }
}
