﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/基本設定タブ/バイナリ転送
    /// </summary>
    [Serializable]
    public class ViewerBasicPtclData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerBasicPtclData() :
            base()
        {
            this.ReloadCtrl = 0;
            this.FilePath = string.Empty;

            this.PostConstruct();
        }

        /// <summary>
        /// リロードの呼び出しを数値の差分でコントロールします。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("db71bedd-3c01-45ea-aa36-ae4129933af2")]
        public int ReloadCtrl { get; set; }

        /// <summary>
        /// 再生するエミッタセットを数値の差分でコントロールします。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("cbdbf85c-9d0c-49a8-9785-b9ccd228a7eb")]
        public int EsetIndexCtrl { get; set; }

        /// <summary>
        /// ptclファイルパスです。
        /// </summary>
        [DataModelPropertyGuid("3de86594-3e79-4c73-8012-8159ca2ce408")]
        public string FilePath { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ViewerBasicPtclData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ReloadCtrl = srcDataModel.ReloadCtrl;
            this.EsetIndexCtrl = srcDataModel.EsetIndexCtrl;
            this.FilePath = srcDataModel.FilePath;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "FilePath", this.FilePath);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.FilePath = this.ReadElement(context, "FilePath", this.FilePath);

            return success;
        }
    }
}
